/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu.csv;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.bean.CsvToBean;
import au.com.bytecode.opencsv.bean.MappingStrategy;
import com.cybelia.sandra.ibu.MigrationContext;
import com.cybelia.sandra.ibu.csv.DatePropertyEditor;
import com.cybelia.sandra.ibu.csv.HeaderColumnNameTranslateMappingStrategy;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.Resource;

public abstract class CSVReaderGeneric<E>
extends CsvToBean {
    protected final Log log = LogFactory.getLog(CSVReaderGeneric.class);
    public static final char DELIM = ';';
    protected HeaderColumnNameTranslateMappingStrategy strategy = new HeaderColumnNameTranslateMappingStrategy();

    public CSVReaderGeneric() {
        this.initStrategy();
        PropertyEditorManager.registerEditor(Date.class, DatePropertyEditor.class);
    }

    public List<E> parseResource(MigrationContext contextMigration, String resourceName) {
        try {
            URL csvFileName = Resource.getURL((String)resourceName);
            return this.parse(contextMigration, new FileReader(new File(csvFileName.toURI())));
        }
        catch (Exception e) {
            this.log.error((Object)"Parser error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<E> parseFile(MigrationContext contextMigration, String csvFileName) {
        try {
            return this.parse(contextMigration, new FileReader(csvFileName));
        }
        catch (Exception e) {
            this.log.error((Object)"Parser error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<E> parse(MigrationContext contextMigration, Reader reader) {
        try {
            String[] line;
            ArrayList<Object> objects = new ArrayList<Object>();
            CSVReader csv = new CSVReader(reader, ';');
            int lineNumber = 0;
            String errorContent = "";
            this.strategy.captureHeader(csv);
            String header = this.getInLine(this.strategy.getHeader());
            errorContent = errorContent + header;
            contextMigration.getLines().add(header);
            while (null != (line = csv.readNext())) {
                ++lineNumber;
                contextMigration.getLines().add(this.getInLine(line));
                try {
                    Object object = this.processLine((MappingStrategy)this.strategy, line);
                    objects.add(object);
                }
                catch (Exception e) {
                    this.log.error((Object)"Parser line error", (Throwable)e);
                    contextMigration.addErrorMsg("Parser line error at " + lineNumber);
                    contextMigration.getParserErrorLineNumbers().add(lineNumber);
                    objects.add(null);
                }
            }
            return objects;
        }
        catch (Exception e) {
            this.log.error((Object)"Parser error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected String getInLine(String[] line) {
        String result = "";
        if (line != null) {
            for (String field : line) {
                result = result + "\"" + field + "\"" + String.valueOf(';');
            }
        }
        result = result + "\n";
        return result;
    }

    protected abstract void initStrategy();
}

