/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.ibu;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class MigrationContext {
    protected List<String> errorMsgs = new ArrayList<String>();
    protected List<String> lines;
    protected List<Integer> parserErrorLineNumbers = new ArrayList<Integer>();
    protected List<Integer> injectorErrorLineNumbers = new ArrayList<Integer>();
    protected String errorBaseFileName;
    protected String sourceFilePath;
    protected String sourceFileName;

    public MigrationContext() {
        this.lines = new ArrayList<String>();
    }

    public List<String> getErrorMsgs() {
        return this.errorMsgs;
    }

    public void addErrorMsg(String errorMsg) {
        this.errorMsgs.add(errorMsg);
    }

    public void setFilePath(String inputFileName) {
        this.sourceFilePath = inputFileName;
        this.sourceFileName = new File(inputFileName).getName();
    }

    public void setErrorFilePath(String outputFolder) {
        this.errorBaseFileName = outputFolder + File.separatorChar + this.sourceFileName;
    }

    public List<Integer> getParserErrorLineNumbers() {
        return this.parserErrorLineNumbers;
    }

    public String getParserErrorFilePath() {
        return this.errorBaseFileName + "_parsing.err";
    }

    public String getInjectorErrorFilePath() {
        return this.errorBaseFileName + "_injector.err";
    }

    public List<String> getLines() {
        return this.lines;
    }

    public String getLinesAsString() {
        String result = "";
        for (String l : this.lines) {
            result = result + l;
        }
        return result;
    }

    public String getParserErrorLinesAsString() {
        String result = "";
        for (int i : this.parserErrorLineNumbers) {
            result = result + this.lines.get(i);
        }
        return result;
    }

    public List<String> getParserErrorLines() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i : this.parserErrorLineNumbers) {
            result.add(this.lines.get(i));
        }
        return result;
    }

    public String getInjectorErrorLinesAsString() {
        String result = "";
        for (int i : this.injectorErrorLineNumbers) {
            result = result + this.lines.get(i);
        }
        return result;
    }

    public List<String> getInjectorErrorLines() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i : this.injectorErrorLineNumbers) {
            result.add(this.lines.get(i));
        }
        return result;
    }

    public void setLines(List<String> lines) {
        this.lines = lines;
    }

    public List<Integer> getInjectorErrorLineNumbers() {
        return this.injectorErrorLineNumbers;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public synchronized String getSourceFileName() {
        return this.sourceFileName;
    }

    public synchronized String getSourceFilePath() {
        return this.sourceFilePath;
    }

    public String getErrorBaseFileName() {
        return this.errorBaseFileName;
    }
}

