/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra;

import com.cybelia.sandra.SandraConfig;
import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.SandraSchedulerConfigHelper;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.UserIndicateurs;
import com.cybelia.sandra.entities.UserIndicateursDAO;
import com.cybelia.sandra.entities.trace.SuiviTour;
import com.google.common.collect.ListMultimap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.util.ApplicationConfig;

public class SandraHelper {
    protected static final Log log = LogFactory.getLog(SandraHelper.class);
    public static final String SUIVI_TOUR_PREFIX = "_";
    public static final String SUIVI_TOUR_EXTENTION = ".txt";

    public static int getDifferenceInMilliseconds(Date beginDate, Date endDate) {
        long begin = beginDate.getTime();
        long end = endDate.getTime();
        return (int)Math.ceil(end - begin);
    }

    public static String[] convertToStringArray(Object[] datas) {
        String[] params = new String[datas.length];
        System.arraycopy(datas, 0, params, 0, datas.length);
        return params;
    }

    public static int pareInt(String s) {
        return s == null || "".equals(s) ? 0 : Integer.parseInt(s);
    }

    public static List<List<String>> reformatData(List<String[]> datas) {
        ArrayList<List<String>> datasResult = new ArrayList<List<String>>();
        ArrayList<String> etapeTopiaIds = new ArrayList<String>();
        ArrayList<String> eleveurTopiaIds = new ArrayList<String>();
        ArrayList<String> tourTopiaIds = new ArrayList<String>();
        ArrayList<String> camionTopiaIds = new ArrayList<String>();
        for (String[] data : datas) {
            etapeTopiaIds.add(data[0]);
            eleveurTopiaIds.add(data[1]);
            tourTopiaIds.add(data[2]);
            camionTopiaIds.add(data[3]);
        }
        datasResult.add(etapeTopiaIds);
        datasResult.add(eleveurTopiaIds);
        datasResult.add(tourTopiaIds);
        datasResult.add(camionTopiaIds);
        return datasResult;
    }

    public static Date getLastWeekDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, -7);
        return cal.getTime();
    }

    public static String convertEntitiesToListForNotifier(Collection<? extends TopiaEntity> entities) {
        return SandraHelper.convertToListForNotifier(SandraHelper.extractIds(entities));
    }

    public static String convertToListForNotifier(Collection<?> list) {
        return StringUtils.join(list, (String)"&&") + "&&";
    }

    public static String convertToSubListForNotifier(Collection<?> list) {
        return StringUtils.join(list, (String)"##") + "##";
    }

    public static <K, V> String convertToListOfListForNotifier(ListMultimap<K, V> multimap) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object key : multimap.keySet()) {
            List values = multimap.get(key);
            String subList = SandraHelper.convertToSubListForNotifier(values);
            list.add(subList);
        }
        String result = SandraHelper.convertToListForNotifier(list);
        return result;
    }

    public static List<String> extractIds(Collection<? extends TopiaEntity> entities) {
        ArrayList<String> result = new ArrayList<String>();
        for (TopiaEntity topiaEntity : entities) {
            result.add(topiaEntity.getTopiaId());
        }
        return result;
    }

    public static String convertDateToString(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(5) + "/" + c.get(2) + "/" + c.get(1) + " \u00e0 " + c.get(11) + " h " + c.get(12);
    }

    public static int getWorstSecurityLevel(Eleveur breeder) {
        return SandraHelper.getWorstInfoAccessSecurityLevel(breeder).getNiveauSecurite();
    }

    public static InfoAccess getWorstInfoAccessSecurityLevel(Eleveur breeder) {
        InfoAccess result = breeder.getAccesEleveur();
        Collection ass = breeder.getActiveAccesSilo();
        int worstSecurityLevel = result.getNiveauSecurite();
        for (InfoAccess as : ass) {
            int siloSecurity;
            if (as == null || worstSecurityLevel >= (siloSecurity = as.getNiveauSecurite())) continue;
            worstSecurityLevel = siloSecurity;
            result = as;
        }
        return result;
    }

    public static UserIndicateurs razUserIndicateurs(UserIndicateurs userIndicateurs) {
        userIndicateurs.setNbMaj(0);
        userIndicateurs.setNbGpsMaj(0);
        userIndicateurs.setNbSecuMaj(0);
        userIndicateurs.setNbSynchGPRS(0);
        userIndicateurs.setNbSynchWifi(0);
        userIndicateurs.setNbSynchKo(0);
        userIndicateurs.setNbNotifs(0);
        userIndicateurs.setNbOctetsReceivedGPRS(0);
        userIndicateurs.setNbOctetsSendGPRS(0);
        userIndicateurs.setNbOctetsReceivedWifi(0);
        userIndicateurs.setNbOctetsSendWifi(0);
        return userIndicateurs;
    }

    public static String addOrder(String alias, String sortCriterion, int sortDirection) {
        return SandraHelper.addOrder(alias, false, sortCriterion, sortDirection);
    }

    public static String addOrder(String alias, boolean isNull, String sortCriterion, int sortDirection) {
        String criteria = alias + "." + sortCriterion;
        if (!isNull) {
            return " ORDER BY " + criteria + " " + (sortDirection == 1 ? "DESC" : "ASC");
        }
        return " ORDER BY CASE WHEN " + criteria + " IS NULL THEN 1 ELSE 0 END, " + criteria + " " + (sortDirection == 1 ? "DESC" : "ASC");
    }

    public static UserIndicateurs createUserIndicateurIfDontExist(TopiaContext transaction, TaasUser user) throws TopiaException {
        UserIndicateursDAO userIndicateursDAO = SandraDAOHelper.getUserIndicateursDAO((TopiaContext)transaction);
        UserIndicateurs userIndicateurs = userIndicateursDAO.findByTaasUser(user);
        if (userIndicateurs == null) {
            userIndicateurs = (UserIndicateurs)userIndicateursDAO.create(new Object[0]);
            userIndicateurs = SandraHelper.razUserIndicateurs(userIndicateurs);
            userIndicateurs.setTaasUser(user);
            userIndicateursDAO.update((TopiaEntity)userIndicateurs);
        }
        return userIndicateurs;
    }

    public static List<TaasUser> getAllCamionUser(TopiaContext transaction) throws TopiaException {
        String hql = "SELECT user FROM " + TaasUser.class.getName() + " user" + " JOIN user.principals AS principal WHERE" + " principal.name = 'synchro' AND user.login != 'synchro'";
        List users = transaction.find(hql, new Object[0]);
        for (TaasUser user : users) {
            user.getPrincipals().size();
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSuiviTourCSV(Tour tour, SuiviTour suiviTour) throws IOException {
        ApplicationConfig config = SandraConfig.getConfig();
        String suiviTourPath = SandraSchedulerConfigHelper.getSuiviTourPath(config);
        SimpleDateFormat format = new SimpleDateFormat("yyMMdd");
        String now = format.format(new Date());
        File file = new File(suiviTourPath + File.separator + tour.getCamion().getSociete().getCode() + SUIVI_TOUR_PREFIX + now + SUIVI_TOUR_EXTENTION);
        Camion camion = tour.getCamion();
        String codeSociete = camion.getSociete().getCode();
        String codeCamion = camion.getCode();
        int numeroTour = tour.getNumero();
        Date dateLivraisonTour = tour.getDateLivraison();
        SimpleDateFormat dateLivraisonPatern = new SimpleDateFormat("dd/MM/yyyy");
        String dateLivraisonAsString = dateLivraisonPatern.format(dateLivraisonTour);
        int kmTotal = suiviTour.getKmTotal();
        Date duree = suiviTour.getDuree();
        String dureeAsString = "00,00";
        if (duree != null) {
            SimpleDateFormat dureePatern = new SimpleDateFormat("HH,mm");
            dureeAsString = dureePatern.format(duree);
        }
        int litresGasoil = suiviTour.getLitresGasoil();
        String lineToWrite = dateLivraisonAsString + ';' + "\"" + codeSociete + "-" + codeCamion + "\"" + ';' + numeroTour + ';' + kmTotal + ';' + dureeAsString + ';' + litresGasoil + "\n";
        OutputStreamWriter writer = null;
        try {
            if (!file.exists()) {
                writer = new FileWriter(file, true);
                writer.write("DAT_LIV;CAM_GROUP;TOU;KM;h_REEL;L_GO\n");
            }
            if (writer == null) {
                writer = new FileWriter(file, true);
            }
            writer.write(lineToWrite);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

