package com.cybelia.sandra.entities.trace;

import com.cybelia.sandra.SandraEntityEnum;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.Usine;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class CompteursKmDAOAbstract<E extends CompteursKm> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)CompteursKm.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.CompteursKm;
    }

    public E findByNaturalId(Date dateSortie, Camion camion, Usine usine) throws TopiaException {
        return findByProperties(CompteursKm.PROPERTY_DATE_SORTIE, dateSortie, CompteursKm.PROPERTY_CAMION, camion, CompteursKm.PROPERTY_USINE, usine);
    }

    public boolean existByNaturalId(Date dateSortie, Camion camion, Usine usine) throws TopiaException {
        return existByProperties(CompteursKm.PROPERTY_DATE_SORTIE, dateSortie, CompteursKm.PROPERTY_CAMION, camion, CompteursKm.PROPERTY_USINE, usine);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param dateSortie 
     * @param camion 
     * @param usine 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(Date dateSortie, Camion camion, Usine usine) throws TopiaException {
        return create(CompteursKm.PROPERTY_DATE_SORTIE, dateSortie, CompteursKm.PROPERTY_CAMION, camion, CompteursKm.PROPERTY_USINE, usine);
    }

    public E createByNaturalId(Date dateSortie, Camion camion, Usine usine) throws TopiaException {
        return create(CompteursKm.PROPERTY_DATE_SORTIE, dateSortie, CompteursKm.PROPERTY_CAMION, camion, CompteursKm.PROPERTY_USINE, usine);
    }

    public E createByNotNull(Date dateSortie, Camion camion, Usine usine) throws TopiaException {
        return create(CompteursKm.PROPERTY_DATE_SORTIE, dateSortie, CompteursKm.PROPERTY_CAMION, camion, CompteursKm.PROPERTY_USINE, usine);
    }

    public E findByDateSortie(Date v) throws TopiaException {
        E result = findByProperty(CompteursKm.PROPERTY_DATE_SORTIE, v);
        return result;
    }

    public List<E> findAllByDateSortie(Date v) throws TopiaException {
        List<E> result = findAllByProperty(CompteursKm.PROPERTY_DATE_SORTIE, v);
        return result;
    }

    public E findByCompteur(int v) throws TopiaException {
        E result = findByProperty(CompteursKm.PROPERTY_COMPTEUR, v);
        return result;
    }

    public List<E> findAllByCompteur(int v) throws TopiaException {
        List<E> result = findAllByProperty(CompteursKm.PROPERTY_COMPTEUR, v);
        return result;
    }

    public E findByDateEntree(Date v) throws TopiaException {
        E result = findByProperty(CompteursKm.PROPERTY_DATE_ENTREE, v);
        return result;
    }

    public List<E> findAllByDateEntree(Date v) throws TopiaException {
        List<E> result = findAllByProperty(CompteursKm.PROPERTY_DATE_ENTREE, v);
        return result;
    }

    public E findByCamion(Camion v) throws TopiaException {
        E result = findByProperty(CompteursKm.PROPERTY_CAMION, v);
        return result;
    }

    public List<E> findAllByCamion(Camion v) throws TopiaException {
        List<E> result = findAllByProperty(CompteursKm.PROPERTY_CAMION, v);
        return result;
    }

    public E findByUsine(Usine v) throws TopiaException {
        E result = findByProperty(CompteursKm.PROPERTY_USINE, v);
        return result;
    }

    public List<E> findAllByUsine(Usine v) throws TopiaException {
        List<E> result = findAllByProperty(CompteursKm.PROPERTY_USINE, v);
        return result;
    }

    public E findByTour(Tour v) throws TopiaException {
        E result = findByProperty(CompteursKm.PROPERTY_TOUR, v);
        return result;
    }

    public List<E> findAllByTour(Tour v) throws TopiaException {
        List<E> result = findAllByProperty(CompteursKm.PROPERTY_TOUR, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //CompteursKmDAOAbstract<E extends CompteursKm>
