package com.cybelia.sandra.entities.trace;

import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.Usine;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class CompteursKmAbstract extends TopiaEntityAbstract implements CompteursKm {

    /**
     * Nom de l'attribut en BD : dateSortie
     */
    protected Date dateSortie;

    /**
     * Nom de l'attribut en BD : compteur
     */
    protected int compteur;

    /**
     * Nom de l'attribut en BD : dateEntree
     */
    protected Date dateEntree;

    /**
     * Nom de l'attribut en BD : camion
     */
    protected Camion camion;

    /**
     * Nom de l'attribut en BD : usine
     */
    protected Usine usine;

    /**
     * Nom de l'attribut en BD : tour
     */
    protected Tour tour;

    private static final long serialVersionUID = 4123388924043289697L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_DATE_SORTIE, Date.class, dateSortie);
        visitor.visit(this, PROPERTY_COMPTEUR, int.class, compteur);
        visitor.visit(this, PROPERTY_DATE_ENTREE, Date.class, dateEntree);
        visitor.visit(this, PROPERTY_CAMION, Camion.class, camion);
        visitor.visit(this, PROPERTY_USINE, Usine.class, usine);
        visitor.visit(this, PROPERTY_TOUR, Tour.class, tour);
        visitor.end(this);
    }

    @Override
    public void setDateSortie(Date dateSortie) {
        Date oldValue = this.dateSortie;
        fireOnPreWrite(PROPERTY_DATE_SORTIE, oldValue, dateSortie);
        this.dateSortie = dateSortie;
        fireOnPostWrite(PROPERTY_DATE_SORTIE, oldValue, dateSortie);
    }

    @Override
    public Date getDateSortie() {
        fireOnPreRead(PROPERTY_DATE_SORTIE, dateSortie);
        Date result = this.dateSortie;
        fireOnPostRead(PROPERTY_DATE_SORTIE, dateSortie);
        return result;
    }

    @Override
    public void setCompteur(int compteur) {
        int oldValue = this.compteur;
        fireOnPreWrite(PROPERTY_COMPTEUR, oldValue, compteur);
        this.compteur = compteur;
        fireOnPostWrite(PROPERTY_COMPTEUR, oldValue, compteur);
    }

    @Override
    public int getCompteur() {
        fireOnPreRead(PROPERTY_COMPTEUR, compteur);
        int result = this.compteur;
        fireOnPostRead(PROPERTY_COMPTEUR, compteur);
        return result;
    }

    @Override
    public void setDateEntree(Date dateEntree) {
        Date oldValue = this.dateEntree;
        fireOnPreWrite(PROPERTY_DATE_ENTREE, oldValue, dateEntree);
        this.dateEntree = dateEntree;
        fireOnPostWrite(PROPERTY_DATE_ENTREE, oldValue, dateEntree);
    }

    @Override
    public Date getDateEntree() {
        fireOnPreRead(PROPERTY_DATE_ENTREE, dateEntree);
        Date result = this.dateEntree;
        fireOnPostRead(PROPERTY_DATE_ENTREE, dateEntree);
        return result;
    }

    @Override
    public void setCamion(Camion camion) {
        Camion oldValue = this.camion;
        fireOnPreWrite(PROPERTY_CAMION, oldValue, camion);
        this.camion = camion;
        fireOnPostWrite(PROPERTY_CAMION, oldValue, camion);
    }

    @Override
    public Camion getCamion() {
        fireOnPreRead(PROPERTY_CAMION, camion);
        Camion result = this.camion;
        fireOnPostRead(PROPERTY_CAMION, camion);
        return result;
    }

    @Override
    public void setUsine(Usine usine) {
        Usine oldValue = this.usine;
        fireOnPreWrite(PROPERTY_USINE, oldValue, usine);
        this.usine = usine;
        fireOnPostWrite(PROPERTY_USINE, oldValue, usine);
    }

    @Override
    public Usine getUsine() {
        fireOnPreRead(PROPERTY_USINE, usine);
        Usine result = this.usine;
        fireOnPostRead(PROPERTY_USINE, usine);
        return result;
    }

    @Override
    public void setTour(Tour tour) {
        Tour oldValue = this.tour;
        fireOnPreWrite(PROPERTY_TOUR, oldValue, tour);
        this.tour = tour;
        fireOnPostWrite(PROPERTY_TOUR, oldValue, tour);
    }

    @Override
    public Tour getTour() {
        fireOnPreRead(PROPERTY_TOUR, tour);
        Tour result = this.tour;
        fireOnPostRead(PROPERTY_TOUR, tour);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_DATE_SORTIE, this.dateSortie).
            append(PROPERTY_COMPTEUR, this.compteur).
            append(PROPERTY_DATE_ENTREE, this.dateEntree).
            append(PROPERTY_CAMION, this.camion).
            append(PROPERTY_USINE, this.usine).
            append(PROPERTY_TOUR, this.tour).
         toString();
        return result;
    }

} //CompteursKmAbstract
