package com.cybelia.sandra.entities.notifier;

import com.cybelia.sandra.SandraEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class EventDAOAbstract<E extends Event> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Event.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.Event;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Cron> list = getContext()
                                                    .getDAO(Cron.class)
                                                    .findAllByProperties(Cron.PROPERTY_EVENT, entity);
                                            for (Cron item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getEvent())) {
                                                    item.setEvent(null);
                                                }
                        
                    }
                }

                                        {
                                        List<Queue> list = getContext()
                                                    .getDAO(Queue.class)
                                                    .findAllByProperties(Queue.PROPERTY_EVENT, entity);
                                            for (Queue item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getEvent())) {
                                                    item.setEvent(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByType(String v) throws TopiaException {
        E result = findByProperty(Event.PROPERTY_TYPE, v);
        return result;
    }

    public List<E> findAllByType(String v) throws TopiaException {
        List<E> result = findAllByProperty(Event.PROPERTY_TYPE, v);
        return result;
    }

    public E findContainsVariables(String v) throws TopiaException {
        E result = findContains(Event.PROPERTY_VARIABLES, v);
        return result;
    }

    public List<E> findAllContainsVariables(String v) throws TopiaException {
        List<E> result = findAllContains(Event.PROPERTY_VARIABLES, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Queue.class) {
            QueueDAO dao = (QueueDAO)
                getContext().getDAO(Queue.class);
            tmp = dao.findAllByEvent(entity);
            result.addAll(tmp);
        }

        if (type == Cron.class) {
            CronDAO dao = (CronDAO)
                getContext().getDAO(Cron.class);
            tmp = dao.findAllByEvent(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(Queue.class, entity);
        if (!list.isEmpty()) {
            result.put(Queue.class, list);
        }

        list = findUsages(Cron.class, entity);
        if (!list.isEmpty()) {
            result.put(Cron.class, list);
        }

        return result;
    }

} //EventDAOAbstract<E extends Event>
