package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraEntityEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.taas.entities.TaasUser;

public abstract class UserIndicateursDAOAbstract<E extends UserIndicateurs> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)UserIndicateurs.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.UserIndicateurs;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Camion> list = getContext()
                                                    .getDAO(Camion.class)
                                                    .findAllByProperties(Camion.PROPERTY_USER_INDICATEURS, entity);
                                            for (Camion item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getUserIndicateurs())) {
                                                    item.setUserIndicateurs(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByNaturalId(TaasUser taasUser) throws TopiaException {
        return findByProperties(UserIndicateurs.PROPERTY_TAAS_USER, taasUser);
    }

    public boolean existByNaturalId(TaasUser taasUser) throws TopiaException {
        return existByProperties(UserIndicateurs.PROPERTY_TAAS_USER, taasUser);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param taasUser 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(TaasUser taasUser) throws TopiaException {
        return create(UserIndicateurs.PROPERTY_TAAS_USER, taasUser);
    }

    public E createByNaturalId(TaasUser taasUser) throws TopiaException {
        return create(UserIndicateurs.PROPERTY_TAAS_USER, taasUser);
    }

    public E createByNotNull(TaasUser taasUser) throws TopiaException {
        return create(UserIndicateurs.PROPERTY_TAAS_USER, taasUser);
    }

    public E findByNbGpsMaj(int v) throws TopiaException {
        E result = findByProperty(UserIndicateurs.PROPERTY_NB_GPS_MAJ, v);
        return result;
    }

    public List<E> findAllByNbGpsMaj(int v) throws TopiaException {
        List<E> result = findAllByProperty(UserIndicateurs.PROPERTY_NB_GPS_MAJ, v);
        return result;
    }

    public E findByNbSecuMaj(int v) throws TopiaException {
        E result = findByProperty(UserIndicateurs.PROPERTY_NB_SECU_MAJ, v);
        return result;
    }

    public List<E> findAllByNbSecuMaj(int v) throws TopiaException {
        List<E> result = findAllByProperty(UserIndicateurs.PROPERTY_NB_SECU_MAJ, v);
        return result;
    }

    public E findByNbMaj(int v) throws TopiaException {
        E result = findByProperty(UserIndicateurs.PROPERTY_NB_MAJ, v);
        return result;
    }

    public List<E> findAllByNbMaj(int v) throws TopiaException {
        List<E> result = findAllByProperty(UserIndicateurs.PROPERTY_NB_MAJ, v);
        return result;
    }

    public E findByNbSynchWifi(int v) throws TopiaException {
        E result = findByProperty(UserIndicateurs.PROPERTY_NB_SYNCH_WIFI, v);
        return result;
    }

    public List<E> findAllByNbSynchWifi(int v) throws TopiaException {
        List<E> result = findAllByProperty(UserIndicateurs.PROPERTY_NB_SYNCH_WIFI, v);
        return result;
    }

    public E findByNbSynchAuto(int v) throws TopiaException {
        E result = findByProperty(UserIndicateurs.PROPERTY_NB_SYNCH_AUTO, v);
        return result;
    }

    public List<E> findAllByNbSynchAuto(int v) throws TopiaException {
        List<E> result = findAllByProperty(UserIndicateurs.PROPERTY_NB_SYNCH_AUTO, v);
        return result;
    }

    public E findByNbSynchGPRS(int v) throws TopiaException {
        E result = findByProperty(UserIndicateurs.PROPERTY_NB_SYNCH_GPRS, v);
        return result;
    }

    public List<E> findAllByNbSynchGPRS(int v) throws TopiaException {
        List<E> result = findAllByProperty(UserIndicateurs.PROPERTY_NB_SYNCH_GPRS, v);
        return result;
    }

    public E findByNbSynchKo(int v) throws TopiaException {
        E result = findByProperty(UserIndicateurs.PROPERTY_NB_SYNCH_KO, v);
        return result;
    }

    public List<E> findAllByNbSynchKo(int v) throws TopiaException {
        List<E> result = findAllByProperty(UserIndicateurs.PROPERTY_NB_SYNCH_KO, v);
        return result;
    }

    public E findByNbOctetsReceivedGPRS(int v) throws TopiaException {
        E result = findByProperty(UserIndicateurs.PROPERTY_NB_OCTETS_RECEIVED_GPRS, v);
        return result;
    }

    public List<E> findAllByNbOctetsReceivedGPRS(int v) throws TopiaException {
        List<E> result = findAllByProperty(UserIndicateurs.PROPERTY_NB_OCTETS_RECEIVED_GPRS, v);
        return result;
    }

    public E findByNbOctetsSendGPRS(int v) throws TopiaException {
        E result = findByProperty(UserIndicateurs.PROPERTY_NB_OCTETS_SEND_GPRS, v);
        return result;
    }

    public List<E> findAllByNbOctetsSendGPRS(int v) throws TopiaException {
        List<E> result = findAllByProperty(UserIndicateurs.PROPERTY_NB_OCTETS_SEND_GPRS, v);
        return result;
    }

    public E findByNbOctetsReceivedWifi(int v) throws TopiaException {
        E result = findByProperty(UserIndicateurs.PROPERTY_NB_OCTETS_RECEIVED_WIFI, v);
        return result;
    }

    public List<E> findAllByNbOctetsReceivedWifi(int v) throws TopiaException {
        List<E> result = findAllByProperty(UserIndicateurs.PROPERTY_NB_OCTETS_RECEIVED_WIFI, v);
        return result;
    }

    public E findByNbOctetsSendWifi(int v) throws TopiaException {
        E result = findByProperty(UserIndicateurs.PROPERTY_NB_OCTETS_SEND_WIFI, v);
        return result;
    }

    public List<E> findAllByNbOctetsSendWifi(int v) throws TopiaException {
        List<E> result = findAllByProperty(UserIndicateurs.PROPERTY_NB_OCTETS_SEND_WIFI, v);
        return result;
    }

    public E findByNbNotifs(int v) throws TopiaException {
        E result = findByProperty(UserIndicateurs.PROPERTY_NB_NOTIFS, v);
        return result;
    }

    public List<E> findAllByNbNotifs(int v) throws TopiaException {
        List<E> result = findAllByProperty(UserIndicateurs.PROPERTY_NB_NOTIFS, v);
        return result;
    }

    public E findByLastSynch(Date v) throws TopiaException {
        E result = findByProperty(UserIndicateurs.PROPERTY_LAST_SYNCH, v);
        return result;
    }

    public List<E> findAllByLastSynch(Date v) throws TopiaException {
        List<E> result = findAllByProperty(UserIndicateurs.PROPERTY_LAST_SYNCH, v);
        return result;
    }

    public E findByLastModif(Date v) throws TopiaException {
        E result = findByProperty(UserIndicateurs.PROPERTY_LAST_MODIF, v);
        return result;
    }

    public List<E> findAllByLastModif(Date v) throws TopiaException {
        List<E> result = findAllByProperty(UserIndicateurs.PROPERTY_LAST_MODIF, v);
        return result;
    }

    public E findByTaasUser(TaasUser v) throws TopiaException {
        E result = findByProperty(UserIndicateurs.PROPERTY_TAAS_USER, v);
        return result;
    }

    public List<E> findAllByTaasUser(TaasUser v) throws TopiaException {
        List<E> result = findAllByProperty(UserIndicateurs.PROPERTY_TAAS_USER, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Camion.class) {
            CamionDAO dao = (CamionDAO)
                getContext().getDAO(Camion.class);
            tmp = dao.findAllByUserIndicateurs(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Camion.class, entity);
        if (!list.isEmpty()) {
            result.put(Camion.class, list);
        }

        return result;
    }

} //UserIndicateursDAOAbstract<E extends UserIndicateurs>
