package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class TransporteurDAOAbstract<E extends Transporteur> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Transporteur.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.Transporteur;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Camion> list = getContext()
                                                    .getDAO(Camion.class)
                                                    .findAllByProperties(Camion.PROPERTY_TRANSPORTEUR, entity);
                                            for (Camion item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getTransporteur())) {
                                                    item.setTransporteur(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByNaturalId(String code) throws TopiaException {
        return findByProperties(Transporteur.PROPERTY_CODE, code);
    }

    public boolean existByNaturalId(String code) throws TopiaException {
        return existByProperties(Transporteur.PROPERTY_CODE, code);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param code 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(String code) throws TopiaException {
        return create(Transporteur.PROPERTY_CODE, code);
    }

    public E createByNaturalId(String code) throws TopiaException {
        return create(Transporteur.PROPERTY_CODE, code);
    }

    public E createByNotNull(String code) throws TopiaException {
        return create(Transporteur.PROPERTY_CODE, code);
    }

    public E findByCode(String v) throws TopiaException {
        E result = findByProperty(Transporteur.PROPERTY_CODE, v);
        return result;
    }

    public List<E> findAllByCode(String v) throws TopiaException {
        List<E> result = findAllByProperty(Transporteur.PROPERTY_CODE, v);
        return result;
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Transporteur.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Transporteur.PROPERTY_NAME, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Camion.class) {
            CamionDAO dao = (CamionDAO)
                getContext().getDAO(Camion.class);
            tmp = dao.findAllByTransporteur(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Camion.class, entity);
        if (!list.isEmpty()) {
            result.put(Camion.class, list);
        }

        return result;
    }

} //TransporteurDAOAbstract<E extends Transporteur>
