package com.cybelia.sandra.entities;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class TourImpl extends TourAbstract {

    private static final long serialVersionUID = 1L;

    @Override
    public boolean isActif() {
        List<Etape> etapes = getEtapes();
        boolean isActif = (etapes != null && !etapes.isEmpty());

        // keep it for futures requests
        super.setActif(isActif);

        return isActif;
    }

    @Override
    public List<Etape> getEtapes() {
        List<Etape> etapes = super.getEtapes();
        if (etapes == null) {
            return null;
        }
        List<Etape> actifEtapes = Lists.newArrayList();
        for (Etape etape : etapes) {
            if (etape.isActif()) {
                actifEtapes.add(etape);
            }
        }
        return actifEtapes;
    }

    @Override
    public int sizeEtapes() {
        List<Etape> etapeList = getEtapes();
        if (etapeList == null) {
            return 0;
        }
        return etapeList.size();
    }

    @Override
    public Date getDateChargement() {
        if (dateChargementReel != null) {
            return dateChargementReel;
            
        } else if (notificationRetourUsine != null) {
            return notificationRetourUsine;
            
        } else if (suiviTour != null
                && suiviTour.getSuiviUsines() != null
                && !suiviTour.getSuiviUsines().isEmpty()) {
            return suiviTour.getSuiviUsines().get(0).getDateChargementPrevue();
            
        } else {
            return dateChargementInitiale;
        }
    }

    @Override
    public void setDateChargement(Date date) {
        if (dateChargementInitiale == null) {
            dateChargementInitiale = date;
        } else {
            dateChargementReel = date;
        }
        
    }

    @Override
    public boolean hasCRTour() {
        if (suiviTour == null) {
            return false;
        } else {
            return suiviTour.getCRTour() != null;
        }
    }
}
