package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraEntityEnum;
import com.cybelia.sandra.entities.trace.CompteursKm;
import com.cybelia.sandra.entities.trace.CompteursKmDAO;
import com.cybelia.sandra.entities.trace.SuiviTour;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class TourDAOAbstract<E extends Tour> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Tour.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.Tour;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Etape> list = getContext()
                                                    .getDAO(Etape.class)
                                                    .findAllByProperties(Etape.PROPERTY_TOUR, entity);
                                            for (Etape item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getTour())) {
                                                    item.setTour(null);
                                                }
                        
                    }
                }

                                        {
                                        List<CompteursKm> list = getContext()
                                                    .getDAO(CompteursKm.class)
                                                    .findAllByProperties(CompteursKm.PROPERTY_TOUR, entity);
                                            for (CompteursKm item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getTour())) {
                                                    item.setTour(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByNaturalId(Date dateLivraison, int numero, Camion camion) throws TopiaException {
        return findByProperties(Tour.PROPERTY_DATE_LIVRAISON, dateLivraison, Tour.PROPERTY_NUMERO, numero, Tour.PROPERTY_CAMION, camion);
    }

    public boolean existByNaturalId(Date dateLivraison, int numero, Camion camion) throws TopiaException {
        return existByProperties(Tour.PROPERTY_DATE_LIVRAISON, dateLivraison, Tour.PROPERTY_NUMERO, numero, Tour.PROPERTY_CAMION, camion);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param dateLivraison 
     * @param numero 
     * @param camion 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(Date dateLivraison, int numero, Camion camion) throws TopiaException {
        return create(Tour.PROPERTY_DATE_LIVRAISON, dateLivraison, Tour.PROPERTY_NUMERO, numero, Tour.PROPERTY_CAMION, camion);
    }

    public E createByNaturalId(Date dateLivraison, int numero, Camion camion) throws TopiaException {
        return create(Tour.PROPERTY_DATE_LIVRAISON, dateLivraison, Tour.PROPERTY_NUMERO, numero, Tour.PROPERTY_CAMION, camion);
    }

    public E createByNotNull(Date dateLivraison, int numero, Camion camion) throws TopiaException {
        return create(Tour.PROPERTY_DATE_LIVRAISON, dateLivraison, Tour.PROPERTY_NUMERO, numero, Tour.PROPERTY_CAMION, camion);
    }

    public E findByDateLivraison(Date v) throws TopiaException {
        E result = findByProperty(Tour.PROPERTY_DATE_LIVRAISON, v);
        return result;
    }

    public List<E> findAllByDateLivraison(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Tour.PROPERTY_DATE_LIVRAISON, v);
        return result;
    }

    public E findByNumero(int v) throws TopiaException {
        E result = findByProperty(Tour.PROPERTY_NUMERO, v);
        return result;
    }

    public List<E> findAllByNumero(int v) throws TopiaException {
        List<E> result = findAllByProperty(Tour.PROPERTY_NUMERO, v);
        return result;
    }

    public E findByCommentaire(String v) throws TopiaException {
        E result = findByProperty(Tour.PROPERTY_COMMENTAIRE, v);
        return result;
    }

    public List<E> findAllByCommentaire(String v) throws TopiaException {
        List<E> result = findAllByProperty(Tour.PROPERTY_COMMENTAIRE, v);
        return result;
    }

    public E findByDateChargementReel(Date v) throws TopiaException {
        E result = findByProperty(Tour.PROPERTY_DATE_CHARGEMENT_REEL, v);
        return result;
    }

    public List<E> findAllByDateChargementReel(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Tour.PROPERTY_DATE_CHARGEMENT_REEL, v);
        return result;
    }

    public E findByActif(boolean v) throws TopiaException {
        E result = findByProperty(Tour.PROPERTY_ACTIF, v);
        return result;
    }

    public List<E> findAllByActif(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Tour.PROPERTY_ACTIF, v);
        return result;
    }

    public E findByDateChargementInitiale(Date v) throws TopiaException {
        E result = findByProperty(Tour.PROPERTY_DATE_CHARGEMENT_INITIALE, v);
        return result;
    }

    public List<E> findAllByDateChargementInitiale(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Tour.PROPERTY_DATE_CHARGEMENT_INITIALE, v);
        return result;
    }

    public E findByNotificationRetourUsine(Date v) throws TopiaException {
        E result = findByProperty(Tour.PROPERTY_NOTIFICATION_RETOUR_USINE, v);
        return result;
    }

    public List<E> findAllByNotificationRetourUsine(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Tour.PROPERTY_NOTIFICATION_RETOUR_USINE, v);
        return result;
    }

    public E findContainsEtapes(Etape v) throws TopiaException {
        E result = findContains(Tour.PROPERTY_ETAPES, v);
        return result;
    }

    public List<E> findAllContainsEtapes(Etape v) throws TopiaException {
        List<E> result = findAllContains(Tour.PROPERTY_ETAPES, v);
        return result;
    }

    public E findByCamion(Camion v) throws TopiaException {
        E result = findByProperty(Tour.PROPERTY_CAMION, v);
        return result;
    }

    public List<E> findAllByCamion(Camion v) throws TopiaException {
        List<E> result = findAllByProperty(Tour.PROPERTY_CAMION, v);
        return result;
    }

    public E findByDefautChauffeur(Chauffeur v) throws TopiaException {
        E result = findByProperty(Tour.PROPERTY_DEFAUT_CHAUFFEUR, v);
        return result;
    }

    public List<E> findAllByDefautChauffeur(Chauffeur v) throws TopiaException {
        List<E> result = findAllByProperty(Tour.PROPERTY_DEFAUT_CHAUFFEUR, v);
        return result;
    }

    public E findBySuiviTour(SuiviTour v) throws TopiaException {
        E result = findByProperty(Tour.PROPERTY_SUIVI_TOUR, v);
        return result;
    }

    public List<E> findAllBySuiviTour(SuiviTour v) throws TopiaException {
        List<E> result = findAllByProperty(Tour.PROPERTY_SUIVI_TOUR, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == CompteursKm.class) {
            CompteursKmDAO dao = (CompteursKmDAO)
                getContext().getDAO(CompteursKm.class);
            tmp = dao.findAllByTour(entity);
            result.addAll(tmp);
        }

        if (type == Etape.class) {
            EtapeDAO dao = (EtapeDAO)
                getContext().getDAO(Etape.class);
            tmp = dao.findAllByTour(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(CompteursKm.class, entity);
        if (!list.isEmpty()) {
            result.put(CompteursKm.class, list);
        }

        list = findUsages(Etape.class, entity);
        if (!list.isEmpty()) {
            result.put(Etape.class, list);
        }

        return result;
    }

} //TourDAOAbstract<E extends Tour>
