package com.cybelia.sandra.entities;

import com.cybelia.sandra.entities.trace.SuiviTour;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class TourAbstract extends TopiaEntityAbstract implements Tour {

    /**
     * Nom de l'attribut en BD : dateLivraison
     */
    protected Date dateLivraison;

    /**
     * Nom de l'attribut en BD : numero
     */
    protected int numero;

    /**
     * Nom de l'attribut en BD : commentaire
     */
    protected String commentaire;

    /**
     * Nom de l'attribut en BD : dateChargementReel
     */
    protected Date dateChargementReel;

    /**
     * Nom de l'attribut en BD : actif
     */
    protected boolean actif;

    /**
     * Nom de l'attribut en BD : dateChargementInitiale
     */
    protected Date dateChargementInitiale;

    /**
     * Nom de l'attribut en BD : notificationRetourUsine
     */
    protected Date notificationRetourUsine;

    /**
     * containt all the etape defined for this tour.
     * Nom de l'attribut en BD : etapes
     */
    protected List<Etape> etapes;

    /**
     * Nom de l'attribut en BD : camion
     */
    protected Camion camion;

    /**
     * Nom de l'attribut en BD : defautChauffeur
     */
    protected Chauffeur defautChauffeur;

    /**
     * Nom de l'attribut en BD : suiviTour
     */
    protected SuiviTour suiviTour;

    private static final long serialVersionUID = 7148445389700871986L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_DATE_LIVRAISON, Date.class, dateLivraison);
        visitor.visit(this, PROPERTY_NUMERO, int.class, numero);
        visitor.visit(this, PROPERTY_COMMENTAIRE, String.class, commentaire);
        visitor.visit(this, PROPERTY_DATE_CHARGEMENT_REEL, Date.class, dateChargementReel);
        visitor.visit(this, PROPERTY_ACTIF, boolean.class, actif);
        visitor.visit(this, PROPERTY_DATE_CHARGEMENT_INITIALE, Date.class, dateChargementInitiale);
        visitor.visit(this, PROPERTY_NOTIFICATION_RETOUR_USINE, Date.class, notificationRetourUsine);
        visitor.visit(this, PROPERTY_ETAPES, List.class, Etape.class, etapes);
        visitor.visit(this, PROPERTY_CAMION, Camion.class, camion);
        visitor.visit(this, PROPERTY_DEFAUT_CHAUFFEUR, Chauffeur.class, defautChauffeur);
        visitor.visit(this, PROPERTY_SUIVI_TOUR, SuiviTour.class, suiviTour);
        visitor.end(this);
    }

    @Override
    public void setDateLivraison(Date dateLivraison) {
        Date oldValue = this.dateLivraison;
        fireOnPreWrite(PROPERTY_DATE_LIVRAISON, oldValue, dateLivraison);
        this.dateLivraison = dateLivraison;
        fireOnPostWrite(PROPERTY_DATE_LIVRAISON, oldValue, dateLivraison);
    }

    @Override
    public Date getDateLivraison() {
        fireOnPreRead(PROPERTY_DATE_LIVRAISON, dateLivraison);
        Date result = this.dateLivraison;
        fireOnPostRead(PROPERTY_DATE_LIVRAISON, dateLivraison);
        return result;
    }

    @Override
    public void setNumero(int numero) {
        int oldValue = this.numero;
        fireOnPreWrite(PROPERTY_NUMERO, oldValue, numero);
        this.numero = numero;
        fireOnPostWrite(PROPERTY_NUMERO, oldValue, numero);
    }

    @Override
    public int getNumero() {
        fireOnPreRead(PROPERTY_NUMERO, numero);
        int result = this.numero;
        fireOnPostRead(PROPERTY_NUMERO, numero);
        return result;
    }

    @Override
    public void setCommentaire(String commentaire) {
        String oldValue = this.commentaire;
        fireOnPreWrite(PROPERTY_COMMENTAIRE, oldValue, commentaire);
        this.commentaire = commentaire;
        fireOnPostWrite(PROPERTY_COMMENTAIRE, oldValue, commentaire);
    }

    @Override
    public String getCommentaire() {
        fireOnPreRead(PROPERTY_COMMENTAIRE, commentaire);
        String result = this.commentaire;
        fireOnPostRead(PROPERTY_COMMENTAIRE, commentaire);
        return result;
    }

    @Override
    public void setDateChargementReel(Date dateChargementReel) {
        Date oldValue = this.dateChargementReel;
        fireOnPreWrite(PROPERTY_DATE_CHARGEMENT_REEL, oldValue, dateChargementReel);
        this.dateChargementReel = dateChargementReel;
        fireOnPostWrite(PROPERTY_DATE_CHARGEMENT_REEL, oldValue, dateChargementReel);
    }

    @Override
    public Date getDateChargementReel() {
        fireOnPreRead(PROPERTY_DATE_CHARGEMENT_REEL, dateChargementReel);
        Date result = this.dateChargementReel;
        fireOnPostRead(PROPERTY_DATE_CHARGEMENT_REEL, dateChargementReel);
        return result;
    }

    @Override
    public void setActif(boolean actif) {
        boolean oldValue = this.actif;
        fireOnPreWrite(PROPERTY_ACTIF, oldValue, actif);
        this.actif = actif;
        fireOnPostWrite(PROPERTY_ACTIF, oldValue, actif);
    }

    @Override
    public boolean isActif() {
        fireOnPreRead(PROPERTY_ACTIF, actif);
        boolean result = this.actif;
        fireOnPostRead(PROPERTY_ACTIF, actif);
        return result;
    }

    @Override
    public boolean getActif() {
        fireOnPreRead(PROPERTY_ACTIF, actif);
        boolean result = this.actif;
        fireOnPostRead(PROPERTY_ACTIF, actif);
        return result;
    }

    @Override
    public void setDateChargementInitiale(Date dateChargementInitiale) {
        Date oldValue = this.dateChargementInitiale;
        fireOnPreWrite(PROPERTY_DATE_CHARGEMENT_INITIALE, oldValue, dateChargementInitiale);
        this.dateChargementInitiale = dateChargementInitiale;
        fireOnPostWrite(PROPERTY_DATE_CHARGEMENT_INITIALE, oldValue, dateChargementInitiale);
    }

    @Override
    public Date getDateChargementInitiale() {
        fireOnPreRead(PROPERTY_DATE_CHARGEMENT_INITIALE, dateChargementInitiale);
        Date result = this.dateChargementInitiale;
        fireOnPostRead(PROPERTY_DATE_CHARGEMENT_INITIALE, dateChargementInitiale);
        return result;
    }

    @Override
    public void setNotificationRetourUsine(Date notificationRetourUsine) {
        Date oldValue = this.notificationRetourUsine;
        fireOnPreWrite(PROPERTY_NOTIFICATION_RETOUR_USINE, oldValue, notificationRetourUsine);
        this.notificationRetourUsine = notificationRetourUsine;
        fireOnPostWrite(PROPERTY_NOTIFICATION_RETOUR_USINE, oldValue, notificationRetourUsine);
    }

    @Override
    public Date getNotificationRetourUsine() {
        fireOnPreRead(PROPERTY_NOTIFICATION_RETOUR_USINE, notificationRetourUsine);
        Date result = this.notificationRetourUsine;
        fireOnPostRead(PROPERTY_NOTIFICATION_RETOUR_USINE, notificationRetourUsine);
        return result;
    }

    @Override
    public void addEtapes(Etape etapes) {
        fireOnPreWrite(PROPERTY_ETAPES, null, etapes);
        if (this.etapes == null) {
            this.etapes = new ArrayList<Etape>();
        }

        etapes.setTour(this);

        this.etapes.add(etapes);
        fireOnPostWrite(PROPERTY_ETAPES, this.etapes.size(), null, etapes);
    }

    @Override
    public void addAllEtapes(List<Etape> etapes) {
        if (etapes == null) {
            return;
        }
        for (Etape item : etapes) {
            addEtapes(item);
        }
    }

    @Override
    public void setEtapes(List<Etape> etapes) {
        // Copy elements to keep data for fire with new reference
        List<Etape> oldValue = this.etapes != null ? new ArrayList<Etape>(this.etapes) : null;
        fireOnPreWrite(PROPERTY_ETAPES, oldValue, etapes);
        this.etapes = etapes;
        fireOnPostWrite(PROPERTY_ETAPES, oldValue, etapes);
    }

    @Override
    public void removeEtapes(Etape etapes) {
        fireOnPreWrite(PROPERTY_ETAPES, etapes, null);
        if (this.etapes == null || !this.etapes.remove(etapes)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        etapes.setTour(null);

        fireOnPostWrite(PROPERTY_ETAPES, this.etapes.size() + 1, etapes, null);
    }

    @Override
    public void clearEtapes() {
        if (this.etapes == null) {
            return;
        }
        for (Etape item : this.etapes) {
            item.setTour(null);
        }
        List<Etape> oldValue = new ArrayList<Etape>(this.etapes);
        fireOnPreWrite(PROPERTY_ETAPES, oldValue, this.etapes);
        this.etapes.clear();
        fireOnPostWrite(PROPERTY_ETAPES, oldValue, this.etapes);
    }

    @Override
    public List<Etape> getEtapes() {
        return etapes;
    }

    @Override
    public Etape getEtapesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(etapes, topiaId);
    }

    @Override
    public int sizeEtapes() {
        if (etapes == null) {
            return 0;
        }
        return etapes.size();
    }

    @Override
    public boolean isEtapesEmpty() {
        int size = sizeEtapes();
        return size == 0;
    }

    @Override
    public void setCamion(Camion camion) {
        Camion oldValue = this.camion;
        fireOnPreWrite(PROPERTY_CAMION, oldValue, camion);
        this.camion = camion;
        fireOnPostWrite(PROPERTY_CAMION, oldValue, camion);
    }

    @Override
    public Camion getCamion() {
        fireOnPreRead(PROPERTY_CAMION, camion);
        Camion result = this.camion;
        fireOnPostRead(PROPERTY_CAMION, camion);
        return result;
    }

    @Override
    public void setDefautChauffeur(Chauffeur defautChauffeur) {
        Chauffeur oldValue = this.defautChauffeur;
        fireOnPreWrite(PROPERTY_DEFAUT_CHAUFFEUR, oldValue, defautChauffeur);
        this.defautChauffeur = defautChauffeur;
        fireOnPostWrite(PROPERTY_DEFAUT_CHAUFFEUR, oldValue, defautChauffeur);
    }

    @Override
    public Chauffeur getDefautChauffeur() {
        fireOnPreRead(PROPERTY_DEFAUT_CHAUFFEUR, defautChauffeur);
        Chauffeur result = this.defautChauffeur;
        fireOnPostRead(PROPERTY_DEFAUT_CHAUFFEUR, defautChauffeur);
        return result;
    }

    @Override
    public void setSuiviTour(SuiviTour suiviTour) {
        SuiviTour oldValue = this.suiviTour;
        fireOnPreWrite(PROPERTY_SUIVI_TOUR, oldValue, suiviTour);
        this.suiviTour = suiviTour;
        fireOnPostWrite(PROPERTY_SUIVI_TOUR, oldValue, suiviTour);
    }

    @Override
    public SuiviTour getSuiviTour() {
        fireOnPreRead(PROPERTY_SUIVI_TOUR, suiviTour);
        SuiviTour result = this.suiviTour;
        fireOnPostRead(PROPERTY_SUIVI_TOUR, suiviTour);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        if (getEtapes() != null) {
              tmp.addAll(getEtapes());
           }
        tmp.add(getSuiviTour());

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_DATE_LIVRAISON, this.dateLivraison).
            append(PROPERTY_NUMERO, this.numero).
            append(PROPERTY_COMMENTAIRE, this.commentaire).
            append(PROPERTY_DATE_CHARGEMENT_REEL, this.dateChargementReel).
            append(PROPERTY_ACTIF, this.actif).
            append(PROPERTY_DATE_CHARGEMENT_INITIALE, this.dateChargementInitiale).
            append(PROPERTY_NOTIFICATION_RETOUR_USINE, this.notificationRetourUsine).
            append(PROPERTY_CAMION, this.camion).
            append(PROPERTY_DEFAUT_CHAUFFEUR, this.defautChauffeur).
            append(PROPERTY_SUIVI_TOUR, this.suiviTour).
         toString();
        return result;
    }

} //TourAbstract
