package com.cybelia.sandra.entities;

import java.awt.Color;

/**
 * Cette enumeration represente les differents status d'une tournee.
 * <p/>
 * On y retrouve comme caracteristiques :
 * <ul>
 * <li>le code du status (celui qui est en base)</li>
 * <li>le code couleur associe</li>
 * </ul>
 *
 * @author chemit
 */
public enum StatutEnum {
    PLANIFIE(0, Color.RED),
    SEMI_DISPONIBLE(1, Color.MAGENTA),
    DISPONIBLE(2, Color.GREEN),
    CHARGE(3, Color.CYAN),
    SEMI_LIVRE(4, Color.BLUE),
    LIVRE(5, Color.GRAY),
    TERMINE(6, Color.BLACK);

    private final int code;
    private final Color color;

    private StatutEnum(int code, Color color) {
        this.code = code;
        this.color = color;
    }

    public int getCode() {
        return code;
    }

    public Color getColor() {
        return color;
    }

    public static StatutEnum valueOfFromCode(int code) {
        for (StatutEnum anEnum : values()) {
            if (anEnum.code == code) {
                return anEnum;
            }
        }
        throw new IllegalArgumentException("could not find StatutEnum from code " + code);
    }
}
