package com.cybelia.sandra.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class LigneProduitAbstract extends TopiaEntityAbstract implements LigneProduit {

    /**
     * Nom de l'attribut en BD : code
     */
    protected String code;

    /**
     * Nom de l'attribut en BD : libelle
     */
    protected String libelle;

    /**
     * PR 2lettres FI/GR
     * Nom de l'attribut en BD : presentation
     */
    protected String presentation;

    /**
     * CU  lettre V/S +deux chiffres V25
     * Nom de l'attribut en BD : conditionnement
     */
    protected String conditionnement;

    /**
     * Nom de l'attribut en BD : capaciteUnitaire
     */
    protected String capaciteUnitaire;

    /**
     * defined in Sandra
     * Nom de l'attribut en BD : quantiteCommandee
     */
    protected int quantiteCommandee;

    /**
     * defined in Sandra
     * Nom de l'attribut en BD : quantiteACharger
     */
    protected int quantiteACharger;

    /**
     * Nom de l'attribut en BD : medicament
     */
    protected boolean medicament;

    /**
     * Nom de l'attribut en BD : ordre
     */
    protected int ordre;

    /**
     * Nom de l'attribut en BD : commentaire
     */
    protected String commentaire;

    /**
     * Nom de l'attribut en BD : acces
     */
    protected String acces;

    /**
     * Nom de l'attribut en BD : equipement
     */
    protected String equipement;

    /**
     * Nom de l'attribut en BD : disponible
     */
    protected boolean disponible;

    /**
     * Nom de l'attribut en BD : etape
     */
    protected Etape etape;

    /**
     * Nom de l'attribut en BD : commande
     */
    protected Commande commande;

    /**
     * Nom de l'attribut en BD : usine
     */
    protected Usine usine;

    /**
     * Nom de l'attribut en BD : infoChargement
     */
    protected InfoChargement infoChargement;

    /**
     * Nom de l'attribut en BD : silo
     */
    protected InfoAccess silo;

    private static final long serialVersionUID = 7162466349881898297L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_CODE, String.class, code);
        visitor.visit(this, PROPERTY_LIBELLE, String.class, libelle);
        visitor.visit(this, PROPERTY_PRESENTATION, String.class, presentation);
        visitor.visit(this, PROPERTY_CONDITIONNEMENT, String.class, conditionnement);
        visitor.visit(this, PROPERTY_CAPACITE_UNITAIRE, String.class, capaciteUnitaire);
        visitor.visit(this, PROPERTY_QUANTITE_COMMANDEE, int.class, quantiteCommandee);
        visitor.visit(this, PROPERTY_QUANTITE_ACHARGER, int.class, quantiteACharger);
        visitor.visit(this, PROPERTY_MEDICAMENT, boolean.class, medicament);
        visitor.visit(this, PROPERTY_ORDRE, int.class, ordre);
        visitor.visit(this, PROPERTY_COMMENTAIRE, String.class, commentaire);
        visitor.visit(this, PROPERTY_ACCES, String.class, acces);
        visitor.visit(this, PROPERTY_EQUIPEMENT, String.class, equipement);
        visitor.visit(this, PROPERTY_DISPONIBLE, boolean.class, disponible);
        visitor.visit(this, PROPERTY_ETAPE, Etape.class, etape);
        visitor.visit(this, PROPERTY_COMMANDE, Commande.class, commande);
        visitor.visit(this, PROPERTY_USINE, Usine.class, usine);
        visitor.visit(this, PROPERTY_INFO_CHARGEMENT, InfoChargement.class, infoChargement);
        visitor.visit(this, PROPERTY_SILO, InfoAccess.class, silo);
        visitor.end(this);
    }

    @Override
    public void setCode(String code) {
        String oldValue = this.code;
        fireOnPreWrite(PROPERTY_CODE, oldValue, code);
        this.code = code;
        fireOnPostWrite(PROPERTY_CODE, oldValue, code);
    }

    @Override
    public String getCode() {
        fireOnPreRead(PROPERTY_CODE, code);
        String result = this.code;
        fireOnPostRead(PROPERTY_CODE, code);
        return result;
    }

    @Override
    public void setLibelle(String libelle) {
        String oldValue = this.libelle;
        fireOnPreWrite(PROPERTY_LIBELLE, oldValue, libelle);
        this.libelle = libelle;
        fireOnPostWrite(PROPERTY_LIBELLE, oldValue, libelle);
    }

    @Override
    public String getLibelle() {
        fireOnPreRead(PROPERTY_LIBELLE, libelle);
        String result = this.libelle;
        fireOnPostRead(PROPERTY_LIBELLE, libelle);
        return result;
    }

    @Override
    public void setPresentation(String presentation) {
        String oldValue = this.presentation;
        fireOnPreWrite(PROPERTY_PRESENTATION, oldValue, presentation);
        this.presentation = presentation;
        fireOnPostWrite(PROPERTY_PRESENTATION, oldValue, presentation);
    }

    @Override
    public String getPresentation() {
        fireOnPreRead(PROPERTY_PRESENTATION, presentation);
        String result = this.presentation;
        fireOnPostRead(PROPERTY_PRESENTATION, presentation);
        return result;
    }

    @Override
    public void setConditionnement(String conditionnement) {
        String oldValue = this.conditionnement;
        fireOnPreWrite(PROPERTY_CONDITIONNEMENT, oldValue, conditionnement);
        this.conditionnement = conditionnement;
        fireOnPostWrite(PROPERTY_CONDITIONNEMENT, oldValue, conditionnement);
    }

    @Override
    public String getConditionnement() {
        fireOnPreRead(PROPERTY_CONDITIONNEMENT, conditionnement);
        String result = this.conditionnement;
        fireOnPostRead(PROPERTY_CONDITIONNEMENT, conditionnement);
        return result;
    }

    @Override
    public void setCapaciteUnitaire(String capaciteUnitaire) {
        String oldValue = this.capaciteUnitaire;
        fireOnPreWrite(PROPERTY_CAPACITE_UNITAIRE, oldValue, capaciteUnitaire);
        this.capaciteUnitaire = capaciteUnitaire;
        fireOnPostWrite(PROPERTY_CAPACITE_UNITAIRE, oldValue, capaciteUnitaire);
    }

    @Override
    public String getCapaciteUnitaire() {
        fireOnPreRead(PROPERTY_CAPACITE_UNITAIRE, capaciteUnitaire);
        String result = this.capaciteUnitaire;
        fireOnPostRead(PROPERTY_CAPACITE_UNITAIRE, capaciteUnitaire);
        return result;
    }

    @Override
    public void setQuantiteCommandee(int quantiteCommandee) {
        int oldValue = this.quantiteCommandee;
        fireOnPreWrite(PROPERTY_QUANTITE_COMMANDEE, oldValue, quantiteCommandee);
        this.quantiteCommandee = quantiteCommandee;
        fireOnPostWrite(PROPERTY_QUANTITE_COMMANDEE, oldValue, quantiteCommandee);
    }

    @Override
    public int getQuantiteCommandee() {
        fireOnPreRead(PROPERTY_QUANTITE_COMMANDEE, quantiteCommandee);
        int result = this.quantiteCommandee;
        fireOnPostRead(PROPERTY_QUANTITE_COMMANDEE, quantiteCommandee);
        return result;
    }

    @Override
    public void setQuantiteACharger(int quantiteACharger) {
        int oldValue = this.quantiteACharger;
        fireOnPreWrite(PROPERTY_QUANTITE_ACHARGER, oldValue, quantiteACharger);
        this.quantiteACharger = quantiteACharger;
        fireOnPostWrite(PROPERTY_QUANTITE_ACHARGER, oldValue, quantiteACharger);
    }

    @Override
    public int getQuantiteACharger() {
        fireOnPreRead(PROPERTY_QUANTITE_ACHARGER, quantiteACharger);
        int result = this.quantiteACharger;
        fireOnPostRead(PROPERTY_QUANTITE_ACHARGER, quantiteACharger);
        return result;
    }

    @Override
    public void setMedicament(boolean medicament) {
        boolean oldValue = this.medicament;
        fireOnPreWrite(PROPERTY_MEDICAMENT, oldValue, medicament);
        this.medicament = medicament;
        fireOnPostWrite(PROPERTY_MEDICAMENT, oldValue, medicament);
    }

    @Override
    public boolean isMedicament() {
        fireOnPreRead(PROPERTY_MEDICAMENT, medicament);
        boolean result = this.medicament;
        fireOnPostRead(PROPERTY_MEDICAMENT, medicament);
        return result;
    }

    @Override
    public boolean getMedicament() {
        fireOnPreRead(PROPERTY_MEDICAMENT, medicament);
        boolean result = this.medicament;
        fireOnPostRead(PROPERTY_MEDICAMENT, medicament);
        return result;
    }

    @Override
    public void setOrdre(int ordre) {
        int oldValue = this.ordre;
        fireOnPreWrite(PROPERTY_ORDRE, oldValue, ordre);
        this.ordre = ordre;
        fireOnPostWrite(PROPERTY_ORDRE, oldValue, ordre);
    }

    @Override
    public int getOrdre() {
        fireOnPreRead(PROPERTY_ORDRE, ordre);
        int result = this.ordre;
        fireOnPostRead(PROPERTY_ORDRE, ordre);
        return result;
    }

    @Override
    public void setCommentaire(String commentaire) {
        String oldValue = this.commentaire;
        fireOnPreWrite(PROPERTY_COMMENTAIRE, oldValue, commentaire);
        this.commentaire = commentaire;
        fireOnPostWrite(PROPERTY_COMMENTAIRE, oldValue, commentaire);
    }

    @Override
    public String getCommentaire() {
        fireOnPreRead(PROPERTY_COMMENTAIRE, commentaire);
        String result = this.commentaire;
        fireOnPostRead(PROPERTY_COMMENTAIRE, commentaire);
        return result;
    }

    @Override
    public void setAcces(String acces) {
        String oldValue = this.acces;
        fireOnPreWrite(PROPERTY_ACCES, oldValue, acces);
        this.acces = acces;
        fireOnPostWrite(PROPERTY_ACCES, oldValue, acces);
    }

    @Override
    public String getAcces() {
        fireOnPreRead(PROPERTY_ACCES, acces);
        String result = this.acces;
        fireOnPostRead(PROPERTY_ACCES, acces);
        return result;
    }

    @Override
    public void setEquipement(String equipement) {
        String oldValue = this.equipement;
        fireOnPreWrite(PROPERTY_EQUIPEMENT, oldValue, equipement);
        this.equipement = equipement;
        fireOnPostWrite(PROPERTY_EQUIPEMENT, oldValue, equipement);
    }

    @Override
    public String getEquipement() {
        fireOnPreRead(PROPERTY_EQUIPEMENT, equipement);
        String result = this.equipement;
        fireOnPostRead(PROPERTY_EQUIPEMENT, equipement);
        return result;
    }

    @Override
    public void setDisponible(boolean disponible) {
        boolean oldValue = this.disponible;
        fireOnPreWrite(PROPERTY_DISPONIBLE, oldValue, disponible);
        this.disponible = disponible;
        fireOnPostWrite(PROPERTY_DISPONIBLE, oldValue, disponible);
    }

    @Override
    public boolean isDisponible() {
        fireOnPreRead(PROPERTY_DISPONIBLE, disponible);
        boolean result = this.disponible;
        fireOnPostRead(PROPERTY_DISPONIBLE, disponible);
        return result;
    }

    @Override
    public boolean getDisponible() {
        fireOnPreRead(PROPERTY_DISPONIBLE, disponible);
        boolean result = this.disponible;
        fireOnPostRead(PROPERTY_DISPONIBLE, disponible);
        return result;
    }

    @Override
    public void setEtape(Etape etape) {
        Etape oldValue = this.etape;
        fireOnPreWrite(PROPERTY_ETAPE, oldValue, etape);
        this.etape = etape;
        fireOnPostWrite(PROPERTY_ETAPE, oldValue, etape);
    }

    @Override
    public Etape getEtape() {
        fireOnPreRead(PROPERTY_ETAPE, etape);
        Etape result = this.etape;
        fireOnPostRead(PROPERTY_ETAPE, etape);
        return result;
    }

    @Override
    public void setCommande(Commande commande) {
        Commande oldValue = this.commande;
        fireOnPreWrite(PROPERTY_COMMANDE, oldValue, commande);
        this.commande = commande;
        fireOnPostWrite(PROPERTY_COMMANDE, oldValue, commande);
    }

    @Override
    public Commande getCommande() {
        fireOnPreRead(PROPERTY_COMMANDE, commande);
        Commande result = this.commande;
        fireOnPostRead(PROPERTY_COMMANDE, commande);
        return result;
    }

    @Override
    public void setUsine(Usine usine) {
        Usine oldValue = this.usine;
        fireOnPreWrite(PROPERTY_USINE, oldValue, usine);
        this.usine = usine;
        fireOnPostWrite(PROPERTY_USINE, oldValue, usine);
    }

    @Override
    public Usine getUsine() {
        fireOnPreRead(PROPERTY_USINE, usine);
        Usine result = this.usine;
        fireOnPostRead(PROPERTY_USINE, usine);
        return result;
    }

    @Override
    public void setInfoChargement(InfoChargement infoChargement) {
        InfoChargement oldValue = this.infoChargement;
        fireOnPreWrite(PROPERTY_INFO_CHARGEMENT, oldValue, infoChargement);
        this.infoChargement = infoChargement;
        fireOnPostWrite(PROPERTY_INFO_CHARGEMENT, oldValue, infoChargement);
    }

    @Override
    public InfoChargement getInfoChargement() {
        fireOnPreRead(PROPERTY_INFO_CHARGEMENT, infoChargement);
        InfoChargement result = this.infoChargement;
        fireOnPostRead(PROPERTY_INFO_CHARGEMENT, infoChargement);
        return result;
    }

    @Override
    public void setSilo(InfoAccess silo) {
        InfoAccess oldValue = this.silo;
        fireOnPreWrite(PROPERTY_SILO, oldValue, silo);
        this.silo = silo;
        fireOnPostWrite(PROPERTY_SILO, oldValue, silo);
    }

    @Override
    public InfoAccess getSilo() {
        fireOnPreRead(PROPERTY_SILO, silo);
        InfoAccess result = this.silo;
        fireOnPostRead(PROPERTY_SILO, silo);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getInfoChargement());

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_CODE, this.code).
            append(PROPERTY_LIBELLE, this.libelle).
            append(PROPERTY_PRESENTATION, this.presentation).
            append(PROPERTY_CONDITIONNEMENT, this.conditionnement).
            append(PROPERTY_CAPACITE_UNITAIRE, this.capaciteUnitaire).
            append(PROPERTY_QUANTITE_COMMANDEE, this.quantiteCommandee).
            append(PROPERTY_QUANTITE_ACHARGER, this.quantiteACharger).
            append(PROPERTY_MEDICAMENT, this.medicament).
            append(PROPERTY_ORDRE, this.ordre).
            append(PROPERTY_COMMENTAIRE, this.commentaire).
            append(PROPERTY_ACCES, this.acces).
            append(PROPERTY_EQUIPEMENT, this.equipement).
            append(PROPERTY_DISPONIBLE, this.disponible).
            append(PROPERTY_COMMANDE, this.commande).
            append(PROPERTY_USINE, this.usine).
            append(PROPERTY_INFO_CHARGEMENT, this.infoChargement).
            append(PROPERTY_SILO, this.silo).
         toString();
        return result;
    }

} //LigneProduitAbstract
