package com.cybelia.sandra.entities;

import java.util.ArrayList;
import java.util.Collection;

public class EleveurImpl extends EleveurAbstract {

    private static final long serialVersionUID = 1L;

    public String getNom() {
        return getRaisonSociale();
    }

    public String getCodeRegion() {
        String codePostal = getCodePostal();
        if (codePostal == null) {
            return "00";
        }
        return codePostal.substring(0, 2);
    }

    @Override
    public Collection<InfoAccess> getActiveAccesSilo() {

        // Remove deleted
        Collection<InfoAccess> accesSilosFromBeanLessDeleted = new ArrayList<InfoAccess>();
        Collection<InfoAccess> accesSilosFromBean = getAccesSilos();
        if (accesSilosFromBean != null) {
            for (InfoAccess silo : accesSilosFromBean) {
                if (silo.getEtat() != InfoAccessEtat.INFOACCESS_SUPPR) {
                    accesSilosFromBeanLessDeleted.add(silo);
                }
            }
        }
        return accesSilosFromBeanLessDeleted;
    }

    @Override
    public int getGloabalNiveauSecurite() {
        int niveauSecuriteMax = -1;

        if (accesSilos != null && !accesSilos.isEmpty()) {
            
            for (InfoAccess infoAccess : accesSilos) {
                int niveauSecuriteSilo = infoAccess.getNiveauSecurite();
                if (niveauSecuriteMax < niveauSecuriteSilo) {
                    niveauSecuriteMax = niveauSecuriteSilo;
                }
            }
            
        } else if (accesEleveur != null) {
            niveauSecuriteMax = accesEleveur.getNiveauSecurite();
        }
        
        return niveauSecuriteMax;
    }
    
} //EleveurImpl
