package com.cybelia.sandra.entities;

import java.util.Collection;

public interface Eleveur extends Lieu {

    String PROPERTY_RAISON_SOCIALE = "raisonSociale";

    String PROPERTY_TELEPHONE = "telephone";

    String PROPERTY_MOBILE = "mobile";

    String PROPERTY_ADRESSE = "adresse";

    String PROPERTY_VILLE = "ville";

    String PROPERTY_CODE_POSTAL = "codePostal";

    String PROPERTY_NIVEAU_SECURITE = "niveauSecurite";

    String PROPERTY_EMAIL = "email";

    String PROPERTY_CODE_INSEE = "codeINSEE";

    String PROPERTY_COMMENTAIRE = "commentaire";

    String PROPERTY_CONTRAINTE_HORAIRE = "contrainteHoraire";

    String PROPERTY_NB_TOM_TOM_GPSMODIF = "nbTomTomGPSModif";

    String PROPERTY_ACCES_ELEVEUR = "accesEleveur";

    String PROPERTY_ACCES_SILOS = "accesSilos";

    String PROPERTY_SOCIETE = "societe";

    String PROPERTY_NOTES = "notes";

    String PROPERTY_ACTION_SECURITE = "actionSecurite";

    void setRaisonSociale(String raisonSociale);

    String getRaisonSociale();

    void setTelephone(String telephone);

    String getTelephone();

    void setMobile(String mobile);

    String getMobile();

    void setAdresse(String adresse);

    String getAdresse();

    void setVille(String ville);

    String getVille();

    void setCodePostal(String codePostal);

    String getCodePostal();

    void setNiveauSecurite(int niveauSecurite);

    int getNiveauSecurite();

    void setEmail(String email);

    String getEmail();

    void setCodeINSEE(String codeINSEE);

    String getCodeINSEE();

    void setCommentaire(String commentaire);

    String getCommentaire();

    void setContrainteHoraire(String contrainteHoraire);

    String getContrainteHoraire();

    void setNbTomTomGPSModif(int nbTomTomGPSModif);

    int getNbTomTomGPSModif();

    void setAccesEleveur(InfoAccess accesEleveur);

    InfoAccess getAccesEleveur();

    void addAccesSilos(InfoAccess accesSilos);

    void addAllAccesSilos(Collection<InfoAccess> accesSilos);

    void setAccesSilos(Collection<InfoAccess> accesSilos);

    void removeAccesSilos(InfoAccess accesSilos);

    void clearAccesSilos();

    Collection<InfoAccess> getAccesSilos();

    InfoAccess getAccesSilosByTopiaId(String topiaId);

    int sizeAccesSilos();

    boolean isAccesSilosEmpty();

    void setSociete(Societe societe);

    Societe getSociete();

    void addNotes(Note notes);

    void addAllNotes(Collection<Note> notes);

    void setNotes(Collection<Note> notes);

    void removeNotes(Note notes);

    void clearNotes();

    Collection<Note> getNotes();

    Note getNotesByTopiaId(String topiaId);

    int sizeNotes();

    boolean isNotesEmpty();

    void addActionSecurite(ActionSecurite actionSecurite);

    void addAllActionSecurite(Collection<ActionSecurite> actionSecurite);

    void setActionSecurite(Collection<ActionSecurite> actionSecurite);

    void removeActionSecurite(ActionSecurite actionSecurite);

    void clearActionSecurite();

    Collection<ActionSecurite> getActionSecurite();

    ActionSecurite getActionSecuriteByTopiaId(String topiaId);

    int sizeActionSecurite();

    boolean isActionSecuriteEmpty();

    String getNom();

    Collection<InfoAccess> getActiveAccesSilo();

    int getGloabalNiveauSecurite();

} //Eleveur
