package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraEntityEnum;
import com.cybelia.sandra.entities.trace.SuiviTour;
import com.cybelia.sandra.entities.trace.SuiviTourDAO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class ChauffeurDAOAbstract<E extends Chauffeur> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Chauffeur.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.Chauffeur;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<SuiviTour> list = getContext()
                                                    .getDAO(SuiviTour.class)
                                                    .findAllByProperties(SuiviTour.PROPERTY_REEL, entity);
                                            for (SuiviTour item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getReel())) {
                                                    item.setReel(null);
                                                }
                        
                    }
                }

                                        {
                                        List<Tour> list = getContext()
                                                    .getDAO(Tour.class)
                                                    .findAllByProperties(Tour.PROPERTY_DEFAUT_CHAUFFEUR, entity);
                                            for (Tour item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getDefautChauffeur())) {
                                                    item.setDefautChauffeur(null);
                                                }
                        
                    }
                }

        {
            List<Camion> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from camion main, camions_defautchauffeurs secondary " +
                    "where main.topiaid=secondary.camions" +
                    " and secondary.defautChauffeurs='" + entity.getTopiaId() + "'")
                    .addEntity("main", com.cybelia.sandra.SandraDAOHelper.getImplementationClass(Camion.class)).list();

            for (Camion item : list) {
                item.removeDefautChauffeurs(entity);
            }
        }

        super.delete(entity);
    }

    public E findByNaturalId(String code) throws TopiaException {
        return findByProperties(Chauffeur.PROPERTY_CODE, code);
    }

    public boolean existByNaturalId(String code) throws TopiaException {
        return existByProperties(Chauffeur.PROPERTY_CODE, code);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param code 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(String code) throws TopiaException {
        return create(Chauffeur.PROPERTY_CODE, code);
    }

    public E createByNaturalId(String code) throws TopiaException {
        return create(Chauffeur.PROPERTY_CODE, code);
    }

    public E createByNotNull(String code) throws TopiaException {
        return create(Chauffeur.PROPERTY_CODE, code);
    }

    public E findByCode(String v) throws TopiaException {
        E result = findByProperty(Chauffeur.PROPERTY_CODE, v);
        return result;
    }

    public List<E> findAllByCode(String v) throws TopiaException {
        List<E> result = findAllByProperty(Chauffeur.PROPERTY_CODE, v);
        return result;
    }

    public E findByTrigramme(String v) throws TopiaException {
        E result = findByProperty(Chauffeur.PROPERTY_TRIGRAMME, v);
        return result;
    }

    public List<E> findAllByTrigramme(String v) throws TopiaException {
        List<E> result = findAllByProperty(Chauffeur.PROPERTY_TRIGRAMME, v);
        return result;
    }

    public E findByNom(String v) throws TopiaException {
        E result = findByProperty(Chauffeur.PROPERTY_NOM, v);
        return result;
    }

    public List<E> findAllByNom(String v) throws TopiaException {
        List<E> result = findAllByProperty(Chauffeur.PROPERTY_NOM, v);
        return result;
    }

    public E findByPrenom(String v) throws TopiaException {
        E result = findByProperty(Chauffeur.PROPERTY_PRENOM, v);
        return result;
    }

    public List<E> findAllByPrenom(String v) throws TopiaException {
        List<E> result = findAllByProperty(Chauffeur.PROPERTY_PRENOM, v);
        return result;
    }

    public E findContainsCamions(Camion v) throws TopiaException {
        E result = findContains(Chauffeur.PROPERTY_CAMIONS, v);
        return result;
    }

    public List<E> findAllContainsCamions(Camion v) throws TopiaException {
        List<E> result = findAllContains(Chauffeur.PROPERTY_CAMIONS, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Tour.class) {
            TourDAO dao = (TourDAO)
                getContext().getDAO(Tour.class);
            tmp = dao.findAllByDefautChauffeur(entity);
            result.addAll(tmp);
        }

        if (type == SuiviTour.class) {
            SuiviTourDAO dao = (SuiviTourDAO)
                getContext().getDAO(SuiviTour.class);
            tmp = dao.findAllByReel(entity);
            result.addAll(tmp);
        }

        if (type == Camion.class) {
            CamionDAO dao = (CamionDAO)
                getContext().getDAO(Camion.class);
            tmp = dao.findAllContainsDefautChauffeurs(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(3);

        List<? extends TopiaEntity> list;

        list = findUsages(Tour.class, entity);
        if (!list.isEmpty()) {
            result.put(Tour.class, list);
        }

        list = findUsages(SuiviTour.class, entity);
        if (!list.isEmpty()) {
            result.put(SuiviTour.class, list);
        }

        list = findUsages(Camion.class, entity);
        if (!list.isEmpty()) {
            result.put(Camion.class, list);
        }

        return result;
    }

} //ChauffeurDAOAbstract<E extends Chauffeur>
