package com.cybelia.sandra.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class ChauffeurAbstract extends TopiaEntityAbstract implements Chauffeur {

    /**
     * Nom de l'attribut en BD : code
     */
    protected String code;

    /**
     * TriGramme of the chauffeur. Must always be defined. Never null.
     * Nom de l'attribut en BD : trigramme
     */
    protected String trigramme;

    /**
     * Nom de l'attribut en BD : nom
     */
    protected String nom;

    /**
     * Nom de l'attribut en BD : prenom
     */
    protected String prenom;

    /**
     * Nom de l'attribut en BD : camions
     */
    protected Collection<Camion> camions;

    private static final long serialVersionUID = 3835151753200022583L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_CODE, String.class, code);
        visitor.visit(this, PROPERTY_TRIGRAMME, String.class, trigramme);
        visitor.visit(this, PROPERTY_NOM, String.class, nom);
        visitor.visit(this, PROPERTY_PRENOM, String.class, prenom);
        visitor.visit(this, PROPERTY_CAMIONS, Collection.class, Camion.class, camions);
        visitor.end(this);
    }

    @Override
    public void setCode(String code) {
        String oldValue = this.code;
        fireOnPreWrite(PROPERTY_CODE, oldValue, code);
        this.code = code;
        fireOnPostWrite(PROPERTY_CODE, oldValue, code);
    }

    @Override
    public String getCode() {
        fireOnPreRead(PROPERTY_CODE, code);
        String result = this.code;
        fireOnPostRead(PROPERTY_CODE, code);
        return result;
    }

    @Override
    public void setTrigramme(String trigramme) {
        String oldValue = this.trigramme;
        fireOnPreWrite(PROPERTY_TRIGRAMME, oldValue, trigramme);
        this.trigramme = trigramme;
        fireOnPostWrite(PROPERTY_TRIGRAMME, oldValue, trigramme);
    }

    @Override
    public String getTrigramme() {
        fireOnPreRead(PROPERTY_TRIGRAMME, trigramme);
        String result = this.trigramme;
        fireOnPostRead(PROPERTY_TRIGRAMME, trigramme);
        return result;
    }

    @Override
    public void setNom(String nom) {
        String oldValue = this.nom;
        fireOnPreWrite(PROPERTY_NOM, oldValue, nom);
        this.nom = nom;
        fireOnPostWrite(PROPERTY_NOM, oldValue, nom);
    }

    @Override
    public String getNom() {
        fireOnPreRead(PROPERTY_NOM, nom);
        String result = this.nom;
        fireOnPostRead(PROPERTY_NOM, nom);
        return result;
    }

    @Override
    public void setPrenom(String prenom) {
        String oldValue = this.prenom;
        fireOnPreWrite(PROPERTY_PRENOM, oldValue, prenom);
        this.prenom = prenom;
        fireOnPostWrite(PROPERTY_PRENOM, oldValue, prenom);
    }

    @Override
    public String getPrenom() {
        fireOnPreRead(PROPERTY_PRENOM, prenom);
        String result = this.prenom;
        fireOnPostRead(PROPERTY_PRENOM, prenom);
        return result;
    }

    @Override
    public void addCamions(Camion camions) {
        fireOnPreWrite(PROPERTY_CAMIONS, null, camions);
        if (this.camions == null) {
            this.camions = new ArrayList<Camion>();
        }

        if (camions.getDefautChauffeurs() == null) {
            camions.setDefautChauffeurs(new ArrayList<Chauffeur>());
        }
        camions.getDefautChauffeurs().add(this);

        this.camions.add(camions);
        fireOnPostWrite(PROPERTY_CAMIONS, this.camions.size(), null, camions);
    }

    @Override
    public void addAllCamions(Collection<Camion> camions) {
        if (camions == null) {
            return;
        }
        for (Camion item : camions) {
            addCamions(item);
        }
    }

    @Override
    public void setCamions(Collection<Camion> camions) {
        // Copy elements to keep data for fire with new reference
        Collection<Camion> oldValue = this.camions != null ? new ArrayList<Camion>(this.camions) : null;
        fireOnPreWrite(PROPERTY_CAMIONS, oldValue, camions);
        this.camions = camions;
        fireOnPostWrite(PROPERTY_CAMIONS, oldValue, camions);
    }

    @Override
    public void removeCamions(Camion camions) {
        fireOnPreWrite(PROPERTY_CAMIONS, camions, null);
        if (this.camions == null || !this.camions.remove(camions)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        camions.getDefautChauffeurs().remove(this);

        fireOnPostWrite(PROPERTY_CAMIONS, this.camions.size() + 1, camions, null);
    }

    @Override
    public void clearCamions() {
        if (this.camions == null) {
            return;
        }
        for (Camion item : this.camions) {
            item.getDefautChauffeurs().remove(this);
        }
        Collection<Camion> oldValue = new ArrayList<Camion>(this.camions);
        fireOnPreWrite(PROPERTY_CAMIONS, oldValue, this.camions);
        this.camions.clear();
        fireOnPostWrite(PROPERTY_CAMIONS, oldValue, this.camions);
    }

    @Override
    public Collection<Camion> getCamions() {
        return camions;
    }

    @Override
    public Camion getCamionsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(camions, topiaId);
    }

    @Override
    public int sizeCamions() {
        if (camions == null) {
            return 0;
        }
        return camions.size();
    }

    @Override
    public boolean isCamionsEmpty() {
        int size = sizeCamions();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_CODE, this.code).
            append(PROPERTY_TRIGRAMME, this.trigramme).
            append(PROPERTY_NOM, this.nom).
            append(PROPERTY_PRENOM, this.prenom).
         toString();
        return result;
    }

} //ChauffeurAbstract
