package com.cybelia.sandra.entities;

import java.util.Collection;
import java.util.List;
import org.nuiton.topia.persistence.TopiaEntity;

public interface Camion extends TopiaEntity {

    String PROPERTY_CODE = "code";

    String PROPERTY_NOMBRE_COMPARTIMENTS = "nombreCompartiments";

    String PROPERTY_ACTIF = "actif";

    String PROPERTY_PARC = "parc";

    String PROPERTY_CONDITIONNEMENT = "conditionnement";

    String PROPERTY_CAMIONS_ASSOCIES = "camionsAssocies";

    String PROPERTY_DEFAUT_CHAUFFEURS = "defautChauffeurs";

    String PROPERTY_TRANSPORTEUR = "transporteur";

    String PROPERTY_SOCIETE = "societe";

    String PROPERTY_USER_INDICATEURS = "userIndicateurs";

    void setCode(String code);

    String getCode();

    void setNombreCompartiments(int nombreCompartiments);

    int getNombreCompartiments();

    void setActif(boolean actif);

    boolean isActif();

    boolean getActif();

    void setParc(String parc);

    String getParc();

    void setConditionnement(String conditionnement);

    String getConditionnement();

    void addCamionsAssocies(Camion camionsAssocies);

    void addAllCamionsAssocies(List<Camion> camionsAssocies);

    void setCamionsAssocies(List<Camion> camionsAssocies);

    void removeCamionsAssocies(Camion camionsAssocies);

    void clearCamionsAssocies();

    List<Camion> getCamionsAssocies();

    Camion getCamionsAssociesByTopiaId(String topiaId);

    int sizeCamionsAssocies();

    boolean isCamionsAssociesEmpty();

    void addDefautChauffeurs(Chauffeur defautChauffeurs);

    void addAllDefautChauffeurs(Collection<Chauffeur> defautChauffeurs);

    void setDefautChauffeurs(Collection<Chauffeur> defautChauffeurs);

    void removeDefautChauffeurs(Chauffeur defautChauffeurs);

    void clearDefautChauffeurs();

    Collection<Chauffeur> getDefautChauffeurs();

    Chauffeur getDefautChauffeursByTopiaId(String topiaId);

    int sizeDefautChauffeurs();

    boolean isDefautChauffeursEmpty();

    void setTransporteur(Transporteur transporteur);

    Transporteur getTransporteur();

    void setSociete(Societe societe);

    Societe getSociete();

    void setUserIndicateurs(UserIndicateurs userIndicateurs);

    UserIndicateurs getUserIndicateurs();

} //Camion
