package com.cybelia.sandra;

import com.cybelia.sandra.entities.ActionSecurite;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.ChargementUsineConfig;
import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.Commande;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.EleveursDoublons;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.InfoChargement;
import com.cybelia.sandra.entities.Label;
import com.cybelia.sandra.entities.Lieu;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.Note;
import com.cybelia.sandra.entities.SecuriteGroupe;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.Transporteur;
import com.cybelia.sandra.entities.UserIndicateurs;
import com.cybelia.sandra.entities.Usine;
import com.cybelia.sandra.entities.notifier.Cron;
import com.cybelia.sandra.entities.notifier.Event;
import com.cybelia.sandra.entities.notifier.Queue;
import com.cybelia.sandra.entities.sig.PointGPS;
import com.cybelia.sandra.entities.sig.TraceGPS;
import com.cybelia.sandra.entities.synchro.Log;
import com.cybelia.sandra.entities.synchro.Synchro;
import com.cybelia.sandra.entities.trace.CREtape;
import com.cybelia.sandra.entities.trace.CRTour;
import com.cybelia.sandra.entities.trace.CRUsine;
import com.cybelia.sandra.entities.trace.CompteursKm;
import com.cybelia.sandra.entities.trace.SuiviEtape;
import com.cybelia.sandra.entities.trace.SuiviLigneProduit;
import com.cybelia.sandra.entities.trace.SuiviTour;
import com.cybelia.sandra.entities.trace.SuiviUsine;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.EntityOperatorStore;
import org.nuiton.topia.taas.entities.TaasUser;


public enum SandraEntityEnum implements TopiaEntityEnum {
    ActionSecurite(ActionSecurite.class, ArrayUtils.EMPTY_STRING_ARRAY),
    Camion(Camion.class, new String[]{ "code", "societe" }, "code", "societe"),
    ChargementUsineConfig(ChargementUsineConfig.class, ArrayUtils.EMPTY_STRING_ARRAY),
    Chauffeur(Chauffeur.class, new String[]{ "code" }, "code"),
    Commande(Commande.class, new String[]{ "numero" }, "numero"),
    Eleveur(Eleveur.class, new String[]{ "societe", "code" }, "societe", "code"),
    EleveursDoublons(EleveursDoublons.class, ArrayUtils.EMPTY_STRING_ARRAY),
    Etape(Etape.class, new String[]{ "ordre", "tour", "eleveur" }, "ordre", "tour", "eleveur"),
    InfoAccess(InfoAccess.class, ArrayUtils.EMPTY_STRING_ARRAY),
    InfoChargement(InfoChargement.class, ArrayUtils.EMPTY_STRING_ARRAY),
    Label(Label.class, new String[]{ "id", "categorie" }, "id", "categorie"),
    Lieu(Lieu.class, new String[]{ "code" }, "code"),
    LigneProduit(LigneProduit.class, new String[]{ "ordre", "commande" }, "ordre", "commande"),
    Note(Note.class, ArrayUtils.EMPTY_STRING_ARRAY),
    SecuriteGroupe(SecuriteGroupe.class, ArrayUtils.EMPTY_STRING_ARRAY),
    Societe(Societe.class, new String[]{ "code" }, "code"),
    Tour(Tour.class, new String[]{ "dateLivraison", "numero", "camion" }, "dateLivraison", "numero", "camion"),
    Transporteur(Transporteur.class, new String[]{ "code" }, "code"),
    UserIndicateurs(UserIndicateurs.class, new String[]{ "taasUser" }, "taasUser"),
    Usine(Usine.class, new String[]{ "code" }, "code"),
    Cron(Cron.class, ArrayUtils.EMPTY_STRING_ARRAY),
    Event(Event.class, ArrayUtils.EMPTY_STRING_ARRAY),
    Queue(Queue.class, ArrayUtils.EMPTY_STRING_ARRAY),
    PointGPS(PointGPS.class, ArrayUtils.EMPTY_STRING_ARRAY),
    TraceGPS(TraceGPS.class, ArrayUtils.EMPTY_STRING_ARRAY),
    Log(Log.class, ArrayUtils.EMPTY_STRING_ARRAY),
    Synchro(Synchro.class, ArrayUtils.EMPTY_STRING_ARRAY),
    CREtape(CREtape.class, ArrayUtils.EMPTY_STRING_ARRAY),
    CRTour(CRTour.class, ArrayUtils.EMPTY_STRING_ARRAY),
    CRUsine(CRUsine.class, ArrayUtils.EMPTY_STRING_ARRAY),
    CompteursKm(CompteursKm.class, new String[]{ "dateSortie", "camion", "usine" }, "dateSortie", "camion", "usine"),
    SuiviEtape(SuiviEtape.class, ArrayUtils.EMPTY_STRING_ARRAY),
    SuiviLigneProduit(SuiviLigneProduit.class, ArrayUtils.EMPTY_STRING_ARRAY),
    SuiviTour(SuiviTour.class, ArrayUtils.EMPTY_STRING_ARRAY),
    SuiviUsine(SuiviUsine.class, ArrayUtils.EMPTY_STRING_ARRAY),
    TaasUser(TaasUser.class, ArrayUtils.EMPTY_STRING_ARRAY);

    /**
     * The contract of the entity.
     */
    protected Class<? extends TopiaEntity> contract;

    /**
     * The fully qualified name of the implementation of the entity.
     */
    protected String implementationFQN;

    /**
     * The implementation class of the entity (will be lazy computed at runtime).
     */
    protected Class<? extends TopiaEntity> implementation;

    /**
     * The array of property involved in the natural key of the entity.
     */
    protected String[] naturalIds;

    /**
     * The array of not null properties of the entity.
     */
    protected String[] notNulls;

    SandraEntityEnum(Class<? extends TopiaEntity > contract, String[] notNulls, String... naturalIds) {
        this.contract = contract;
        this.notNulls = notNulls;
        this.naturalIds = naturalIds;
        implementationFQN = contract.getName() + "Impl";
    }

    @Override
    public Class<? extends TopiaEntity> getContract() {
        return contract;
    }

    @Override
    public String[] getNaturalIds() {
        return naturalIds;
    }

    @Override
    public boolean isUseNaturalIds() {
        return naturalIds.length > 0;
    }

    @Override
    public String[] getNotNulls() {
        return notNulls;
    }

    @Override
    public boolean isUseNotNulls() {
        return notNulls.length > 0;
    }

    @Override
    public String getImplementationFQN() {
        return implementationFQN;
    }

    @Override
    public void setImplementationFQN(String implementationFQN) {
        this.implementationFQN = implementationFQN;
        implementation = null;
        // reinit the operators store
        EntityOperatorStore.clear();
    }

    @Override
    public boolean accept(Class<? extends TopiaEntity> klass) {
        return SandraDAOHelper.getContractClass(klass) == contract;
    }

    @Override
    public Class<? extends TopiaEntity> getImplementation() {
        if (implementation == null) {
        try {
                implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
            } catch (ClassNotFoundException e) {
                throw new TopiaRuntimeException("could not find class " + implementationFQN, e);
            }
        }
        return implementation;
    }

    public static SandraEntityEnum valueOf(TopiaEntity entity) {
        return valueOf(entity.getClass());
    }

    public static SandraEntityEnum valueOf(Class<?> klass) {
        if (klass.isInterface()) {
           return valueOf(klass.getSimpleName());
        }
        for (SandraEntityEnum entityEnum : SandraEntityEnum.values()) {
            if (entityEnum.getContract().isAssignableFrom(klass)) {
                //todo check it works for inheritance
                return entityEnum;
            }
        }
        throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(SandraEntityEnum.values()));
    }

} //SandraEntityEnum
