/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.entities.notifier;

import com.cybelia.sandra.entities.notifier.Cron;
import com.cybelia.sandra.entities.notifier.Event;
import com.cybelia.sandra.entities.notifier.Queue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class QueueAbstract
extends TopiaEntityAbstract
implements Queue {
    protected Date date;
    protected Collection<String> values;
    protected Event event;
    protected Collection<Cron> cron;
    private static final long serialVersionUID = 3847817019067216432L;

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "date", Date.class, (Object)this.date);
        visitor.visit((TopiaEntity)this, "values", Collection.class, String.class, this.values);
        visitor.visit((TopiaEntity)this, "event", Event.class, (Object)this.event);
        visitor.visit((TopiaEntity)this, "cron", Collection.class, Cron.class, this.cron);
        visitor.end((TopiaEntity)this);
    }

    @Override
    public void setDate(Date date) {
        Date oldValue = this.date;
        this.fireOnPreWrite("date", oldValue, date);
        this.date = date;
        this.fireOnPostWrite("date", oldValue, date);
    }

    @Override
    public Date getDate() {
        this.fireOnPreRead("date", this.date);
        Date result = this.date;
        this.fireOnPostRead("date", this.date);
        return result;
    }

    @Override
    public void addValues(String values) {
        this.fireOnPreWrite("values", null, values);
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(values);
        this.fireOnPostWrite("values", this.values.size(), null, values);
    }

    @Override
    public void addAllValues(Collection<String> values) {
        if (values == null) {
            return;
        }
        for (String item : values) {
            this.addValues(item);
        }
    }

    @Override
    public void setValues(Collection<String> values) {
        ArrayList<String> oldValue = this.values != null ? new ArrayList<String>(this.values) : null;
        this.fireOnPreWrite("values", oldValue, values);
        this.values = values;
        this.fireOnPostWrite("values", oldValue, values);
    }

    @Override
    public void removeValues(String values) {
        this.fireOnPreWrite("values", values, null);
        if (this.values == null || !this.values.remove(values)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("values", this.values.size() + 1, values, null);
    }

    @Override
    public void clearValues() {
        if (this.values == null) {
            return;
        }
        ArrayList<String> oldValue = new ArrayList<String>(this.values);
        this.fireOnPreWrite("values", oldValue, this.values);
        this.values.clear();
        this.fireOnPostWrite("values", oldValue, this.values);
    }

    @Override
    public Collection<String> getValues() {
        return this.values;
    }

    @Override
    public int sizeValues() {
        if (this.values == null) {
            return 0;
        }
        return this.values.size();
    }

    @Override
    public boolean isValuesEmpty() {
        int size = this.sizeValues();
        return size == 0;
    }

    @Override
    public void setEvent(Event event) {
        Event oldValue = this.event;
        this.fireOnPreWrite("event", oldValue, event);
        this.event = event;
        this.fireOnPostWrite("event", oldValue, event);
    }

    @Override
    public Event getEvent() {
        this.fireOnPreRead("event", this.event);
        Event result = this.event;
        this.fireOnPostRead("event", this.event);
        return result;
    }

    @Override
    public void addCron(Cron cron) {
        this.fireOnPreWrite("cron", null, cron);
        if (this.cron == null) {
            this.cron = new ArrayList<Cron>();
        }
        this.cron.add(cron);
        this.fireOnPostWrite("cron", this.cron.size(), null, cron);
    }

    @Override
    public void addAllCron(Collection<Cron> cron) {
        if (cron == null) {
            return;
        }
        for (Cron item : cron) {
            this.addCron(item);
        }
    }

    @Override
    public void setCron(Collection<Cron> cron) {
        ArrayList<Cron> oldValue = this.cron != null ? new ArrayList<Cron>(this.cron) : null;
        this.fireOnPreWrite("cron", oldValue, cron);
        this.cron = cron;
        this.fireOnPostWrite("cron", oldValue, cron);
    }

    @Override
    public void removeCron(Cron cron) {
        this.fireOnPreWrite("cron", cron, null);
        if (this.cron == null || !this.cron.remove(cron)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("cron", this.cron.size() + 1, cron, null);
    }

    @Override
    public void clearCron() {
        if (this.cron == null) {
            return;
        }
        ArrayList<Cron> oldValue = new ArrayList<Cron>(this.cron);
        this.fireOnPreWrite("cron", oldValue, this.cron);
        this.cron.clear();
        this.fireOnPostWrite("cron", oldValue, this.cron);
    }

    @Override
    public Collection<Cron> getCron() {
        return this.cron;
    }

    @Override
    public Cron getCronByTopiaId(String topiaId) {
        return (Cron)TopiaEntityHelper.getEntityByTopiaId(this.cron, (String)topiaId);
    }

    @Override
    public int sizeCron() {
        if (this.cron == null) {
            return 0;
        }
        return this.cron.size();
    }

    @Override
    public boolean isCronEmpty() {
        int size = this.sizeCron();
        return size == 0;
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("date", (Object)this.date).append("values", this.values).append("event", (Object)this.event).append("cron", this.cron).toString();
        return result;
    }
}

