/*
 * Decompiled with CFR 0.152.
 */
package com.cybelia.sandra.entities;

import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.Societe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class ChauffeurAbstract
extends TopiaEntityAbstract
implements Chauffeur {
    protected String code;
    protected String trigramme;
    protected String nom;
    protected String prenom;
    protected Collection<Camion> camions;
    protected Societe societe;
    private static final long serialVersionUID = 3835151753200022583L;

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "code", String.class, (Object)this.code);
        visitor.visit((TopiaEntity)this, "trigramme", String.class, (Object)this.trigramme);
        visitor.visit((TopiaEntity)this, "nom", String.class, (Object)this.nom);
        visitor.visit((TopiaEntity)this, "prenom", String.class, (Object)this.prenom);
        visitor.visit((TopiaEntity)this, "camions", Collection.class, Camion.class, this.camions);
        visitor.visit((TopiaEntity)this, "societe", Societe.class, (Object)this.societe);
        visitor.end((TopiaEntity)this);
    }

    @Override
    public void setCode(String code) {
        String oldValue = this.code;
        this.fireOnPreWrite("code", oldValue, code);
        this.code = code;
        this.fireOnPostWrite("code", oldValue, code);
    }

    @Override
    public String getCode() {
        this.fireOnPreRead("code", this.code);
        String result = this.code;
        this.fireOnPostRead("code", this.code);
        return result;
    }

    @Override
    public void setTrigramme(String trigramme) {
        String oldValue = this.trigramme;
        this.fireOnPreWrite("trigramme", oldValue, trigramme);
        this.trigramme = trigramme;
        this.fireOnPostWrite("trigramme", oldValue, trigramme);
    }

    @Override
    public String getTrigramme() {
        this.fireOnPreRead("trigramme", this.trigramme);
        String result = this.trigramme;
        this.fireOnPostRead("trigramme", this.trigramme);
        return result;
    }

    @Override
    public void setNom(String nom) {
        String oldValue = this.nom;
        this.fireOnPreWrite("nom", oldValue, nom);
        this.nom = nom;
        this.fireOnPostWrite("nom", oldValue, nom);
    }

    @Override
    public String getNom() {
        this.fireOnPreRead("nom", this.nom);
        String result = this.nom;
        this.fireOnPostRead("nom", this.nom);
        return result;
    }

    @Override
    public void setPrenom(String prenom) {
        String oldValue = this.prenom;
        this.fireOnPreWrite("prenom", oldValue, prenom);
        this.prenom = prenom;
        this.fireOnPostWrite("prenom", oldValue, prenom);
    }

    @Override
    public String getPrenom() {
        this.fireOnPreRead("prenom", this.prenom);
        String result = this.prenom;
        this.fireOnPostRead("prenom", this.prenom);
        return result;
    }

    @Override
    public void addCamions(Camion camions) {
        this.fireOnPreWrite("camions", null, camions);
        if (this.camions == null) {
            this.camions = new ArrayList<Camion>();
        }
        if (camions.getDefautChauffeurs() == null) {
            camions.setDefautChauffeurs(new ArrayList<Chauffeur>());
        }
        camions.getDefautChauffeurs().add(this);
        this.camions.add(camions);
        this.fireOnPostWrite("camions", this.camions.size(), null, camions);
    }

    @Override
    public void addAllCamions(Collection<Camion> camions) {
        if (camions == null) {
            return;
        }
        for (Camion item : camions) {
            this.addCamions(item);
        }
    }

    @Override
    public void setCamions(Collection<Camion> camions) {
        ArrayList<Camion> oldValue = this.camions != null ? new ArrayList<Camion>(this.camions) : null;
        this.fireOnPreWrite("camions", oldValue, camions);
        this.camions = camions;
        this.fireOnPostWrite("camions", oldValue, camions);
    }

    @Override
    public void removeCamions(Camion camions) {
        this.fireOnPreWrite("camions", camions, null);
        if (this.camions == null || !this.camions.remove(camions)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        camions.getDefautChauffeurs().remove(this);
        this.fireOnPostWrite("camions", this.camions.size() + 1, camions, null);
    }

    @Override
    public void clearCamions() {
        if (this.camions == null) {
            return;
        }
        for (Camion item : this.camions) {
            item.getDefautChauffeurs().remove(this);
        }
        ArrayList<Camion> oldValue = new ArrayList<Camion>(this.camions);
        this.fireOnPreWrite("camions", oldValue, this.camions);
        this.camions.clear();
        this.fireOnPostWrite("camions", oldValue, this.camions);
    }

    @Override
    public Collection<Camion> getCamions() {
        return this.camions;
    }

    @Override
    public Camion getCamionsByTopiaId(String topiaId) {
        return (Camion)TopiaEntityHelper.getEntityByTopiaId(this.camions, (String)topiaId);
    }

    @Override
    public int sizeCamions() {
        if (this.camions == null) {
            return 0;
        }
        return this.camions.size();
    }

    @Override
    public boolean isCamionsEmpty() {
        int size = this.sizeCamions();
        return size == 0;
    }

    @Override
    public void setSociete(Societe societe) {
        Societe oldValue = this.societe;
        this.fireOnPreWrite("societe", oldValue, societe);
        this.societe = societe;
        this.fireOnPostWrite("societe", oldValue, societe);
    }

    @Override
    public Societe getSociete() {
        this.fireOnPreRead("societe", this.societe);
        Societe result = this.societe;
        this.fireOnPostRead("societe", this.societe);
        return result;
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("code", (Object)this.code).append("trigramme", (Object)this.trigramme).append("nom", (Object)this.nom).append("prenom", (Object)this.prenom).append("societe", (Object)this.societe).toString();
        return result;
    }
}

