package com.cybelia.sandra.entities.trace;

import com.cybelia.sandra.SandraDAOHelper.SandraEntityEnum;
import com.cybelia.sandra.entities.Usine;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class SuiviUsineDAOAbstract<E extends SuiviUsine> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)SuiviUsine.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.SuiviUsine;
    }

    public E findByCreationOrdre(int v) throws TopiaException {
        E result = findByProperty(SuiviUsine.PROPERTY_CREATION_ORDRE, v);
        return result;
    }

    public List<E> findAllByCreationOrdre(int v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviUsine.PROPERTY_CREATION_ORDRE, v);
        return result;
    }

    public E findByNouvelleOrdre(int v) throws TopiaException {
        E result = findByProperty(SuiviUsine.PROPERTY_NOUVELLE_ORDRE, v);
        return result;
    }

    public List<E> findAllByNouvelleOrdre(int v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviUsine.PROPERTY_NOUVELLE_ORDRE, v);
        return result;
    }

    public E findByDateEntree(Date v) throws TopiaException {
        E result = findByProperty(SuiviUsine.PROPERTY_DATE_ENTREE, v);
        return result;
    }

    public List<E> findAllByDateEntree(Date v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviUsine.PROPERTY_DATE_ENTREE, v);
        return result;
    }

    public E findByDateSortie(Date v) throws TopiaException {
        E result = findByProperty(SuiviUsine.PROPERTY_DATE_SORTIE, v);
        return result;
    }

    public List<E> findAllByDateSortie(Date v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviUsine.PROPERTY_DATE_SORTIE, v);
        return result;
    }

    public E findByTempsChargement(Date v) throws TopiaException {
        E result = findByProperty(SuiviUsine.PROPERTY_TEMPS_CHARGEMENT, v);
        return result;
    }

    public List<E> findAllByTempsChargement(Date v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviUsine.PROPERTY_TEMPS_CHARGEMENT, v);
        return result;
    }

    public E findByHeureChargement(Date v) throws TopiaException {
        E result = findByProperty(SuiviUsine.PROPERTY_HEURE_CHARGEMENT, v);
        return result;
    }

    public List<E> findAllByHeureChargement(Date v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviUsine.PROPERTY_HEURE_CHARGEMENT, v);
        return result;
    }

    public E findByChargePar(int v) throws TopiaException {
        E result = findByProperty(SuiviUsine.PROPERTY_CHARGE_PAR, v);
        return result;
    }

    public List<E> findAllByChargePar(int v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviUsine.PROPERTY_CHARGE_PAR, v);
        return result;
    }

    public E findByDateChargementPrevue(Date v) throws TopiaException {
        E result = findByProperty(SuiviUsine.PROPERTY_DATE_CHARGEMENT_PREVUE, v);
        return result;
    }

    public List<E> findAllByDateChargementPrevue(Date v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviUsine.PROPERTY_DATE_CHARGEMENT_PREVUE, v);
        return result;
    }

    public E findContainsSuiviLigneProduit(SuiviLigneProduit v) throws TopiaException {
        E result = findContains(SuiviUsine.PROPERTY_SUIVI_LIGNE_PRODUIT, v);
        return result;
    }

    public List<E> findAllContainsSuiviLigneProduit(SuiviLigneProduit v) throws TopiaException {
        List<E> result = findAllContains(SuiviUsine.PROPERTY_SUIVI_LIGNE_PRODUIT, v);
        return result;
    }

    public E findByCRUsine(CRUsine v) throws TopiaException {
        E result = findByProperty(SuiviUsine.PROPERTY_C_RUSINE, v);
        return result;
    }

    public List<E> findAllByCRUsine(CRUsine v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviUsine.PROPERTY_C_RUSINE, v);
        return result;
    }

    public E findByUsine(Usine v) throws TopiaException {
        E result = findByProperty(SuiviUsine.PROPERTY_USINE, v);
        return result;
    }

    public List<E> findAllByUsine(Usine v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviUsine.PROPERTY_USINE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == SuiviTour.class) {
            SuiviTourDAO dao = (SuiviTourDAO)
                getContext().getDAO(SuiviTour.class);
            tmp = dao.findAllContainsSuiviUsines(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(SuiviTour.class, entity);
        if (!list.isEmpty()) {
            result.put(SuiviTour.class, list);
        }

        return result;
    }

} //SuiviUsineDAOAbstract<E extends SuiviUsine>
