package com.cybelia.sandra.entities.trace;

import com.cybelia.sandra.entities.Chauffeur;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class SuiviTourAbstract extends TopiaEntityAbstract implements SuiviTour {

    /**
     * Nom de l'attribut en BD : status
     */
    protected int status;

    /**
     * Nom de l'attribut en BD : chauffeurNomPrenom
     */
    protected String chauffeurNomPrenom;

    /**
     * Nom de l'attribut en BD : duree
     */
    protected Date duree;

    /**
     * Nom de l'attribut en BD : litresGasoil
     */
    protected int litresGasoil;

    /**
     * Nom de l'attribut en BD : kmDepart
     */
    protected int kmDepart;

    /**
     * Nom de l'attribut en BD : kmArrivee
     */
    protected int kmArrivee;

    /**
     * Nom de l'attribut en BD : suiviEtapes
     */
    protected List<SuiviEtape> suiviEtapes;

    /**
     * Nom de l'attribut en BD : reel
     */
    protected Chauffeur reel;

    /**
     * Nom de l'attribut en BD : suiviUsines
     */
    protected List<SuiviUsine> suiviUsines;

    /**
     * Nom de l'attribut en BD : cRTour
     */
    protected CRTour cRTour;

    private static final long serialVersionUID = 7366028836710015792L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_STATUS, int.class, status);
        visitor.visit(this, PROPERTY_CHAUFFEUR_NOM_PRENOM, String.class, chauffeurNomPrenom);
        visitor.visit(this, PROPERTY_DUREE, Date.class, duree);
        visitor.visit(this, PROPERTY_LITRES_GASOIL, int.class, litresGasoil);
        visitor.visit(this, PROPERTY_KM_DEPART, int.class, kmDepart);
        visitor.visit(this, PROPERTY_KM_ARRIVEE, int.class, kmArrivee);
        visitor.visit(this, PROPERTY_SUIVI_ETAPES, List.class, SuiviEtape.class, suiviEtapes);
        visitor.visit(this, PROPERTY_REEL, Chauffeur.class, reel);
        visitor.visit(this, PROPERTY_SUIVI_USINES, List.class, SuiviUsine.class, suiviUsines);
        visitor.visit(this, PROPERTY_C_RTOUR, CRTour.class, cRTour);
        visitor.end(this);
    }

    @Override
    public void setStatus(int status) {
        int oldValue = this.status;
        fireOnPreWrite(PROPERTY_STATUS, oldValue, status);
        this.status = status;
        fireOnPostWrite(PROPERTY_STATUS, oldValue, status);
    }

    @Override
    public int getStatus() {
        fireOnPreRead(PROPERTY_STATUS, status);
        int result = this.status;
        fireOnPostRead(PROPERTY_STATUS, status);
        return result;
    }

    @Override
    public void setChauffeurNomPrenom(String chauffeurNomPrenom) {
        String oldValue = this.chauffeurNomPrenom;
        fireOnPreWrite(PROPERTY_CHAUFFEUR_NOM_PRENOM, oldValue, chauffeurNomPrenom);
        this.chauffeurNomPrenom = chauffeurNomPrenom;
        fireOnPostWrite(PROPERTY_CHAUFFEUR_NOM_PRENOM, oldValue, chauffeurNomPrenom);
    }

    @Override
    public String getChauffeurNomPrenom() {
        fireOnPreRead(PROPERTY_CHAUFFEUR_NOM_PRENOM, chauffeurNomPrenom);
        String result = this.chauffeurNomPrenom;
        fireOnPostRead(PROPERTY_CHAUFFEUR_NOM_PRENOM, chauffeurNomPrenom);
        return result;
    }

    @Override
    public void setDuree(Date duree) {
        Date oldValue = this.duree;
        fireOnPreWrite(PROPERTY_DUREE, oldValue, duree);
        this.duree = duree;
        fireOnPostWrite(PROPERTY_DUREE, oldValue, duree);
    }

    @Override
    public Date getDuree() {
        fireOnPreRead(PROPERTY_DUREE, duree);
        Date result = this.duree;
        fireOnPostRead(PROPERTY_DUREE, duree);
        return result;
    }

    @Override
    public void setLitresGasoil(int litresGasoil) {
        int oldValue = this.litresGasoil;
        fireOnPreWrite(PROPERTY_LITRES_GASOIL, oldValue, litresGasoil);
        this.litresGasoil = litresGasoil;
        fireOnPostWrite(PROPERTY_LITRES_GASOIL, oldValue, litresGasoil);
    }

    @Override
    public int getLitresGasoil() {
        fireOnPreRead(PROPERTY_LITRES_GASOIL, litresGasoil);
        int result = this.litresGasoil;
        fireOnPostRead(PROPERTY_LITRES_GASOIL, litresGasoil);
        return result;
    }

    @Override
    public void setKmDepart(int kmDepart) {
        int oldValue = this.kmDepart;
        fireOnPreWrite(PROPERTY_KM_DEPART, oldValue, kmDepart);
        this.kmDepart = kmDepart;
        fireOnPostWrite(PROPERTY_KM_DEPART, oldValue, kmDepart);
    }

    @Override
    public int getKmDepart() {
        fireOnPreRead(PROPERTY_KM_DEPART, kmDepart);
        int result = this.kmDepart;
        fireOnPostRead(PROPERTY_KM_DEPART, kmDepart);
        return result;
    }

    @Override
    public void setKmArrivee(int kmArrivee) {
        int oldValue = this.kmArrivee;
        fireOnPreWrite(PROPERTY_KM_ARRIVEE, oldValue, kmArrivee);
        this.kmArrivee = kmArrivee;
        fireOnPostWrite(PROPERTY_KM_ARRIVEE, oldValue, kmArrivee);
    }

    @Override
    public int getKmArrivee() {
        fireOnPreRead(PROPERTY_KM_ARRIVEE, kmArrivee);
        int result = this.kmArrivee;
        fireOnPostRead(PROPERTY_KM_ARRIVEE, kmArrivee);
        return result;
    }

    @Override
    public void addSuiviEtapes(SuiviEtape suiviEtapes) {
        fireOnPreWrite(PROPERTY_SUIVI_ETAPES, null, suiviEtapes);
        if (this.suiviEtapes == null) {
            this.suiviEtapes = new ArrayList<SuiviEtape>();
        }

        this.suiviEtapes.add(suiviEtapes);
        fireOnPostWrite(PROPERTY_SUIVI_ETAPES, this.suiviEtapes.size(), null, suiviEtapes);
    }

    @Override
    public void addAllSuiviEtapes(List<SuiviEtape> suiviEtapes) {
        if (suiviEtapes == null) {
            return;
        }
        for (SuiviEtape item : suiviEtapes) {
            addSuiviEtapes(item);
        }
    }

    @Override
    public void setSuiviEtapes(List<SuiviEtape> suiviEtapes) {
        // Copy elements to keep data for fire with new reference
        List<SuiviEtape> oldValue = this.suiviEtapes != null ? new ArrayList<SuiviEtape>(this.suiviEtapes) : null;
        fireOnPreWrite(PROPERTY_SUIVI_ETAPES, oldValue, suiviEtapes);
        this.suiviEtapes = suiviEtapes;
        fireOnPostWrite(PROPERTY_SUIVI_ETAPES, oldValue, suiviEtapes);
    }

    @Override
    public void removeSuiviEtapes(SuiviEtape suiviEtapes) {
        fireOnPreWrite(PROPERTY_SUIVI_ETAPES, suiviEtapes, null);
        if (this.suiviEtapes == null || !this.suiviEtapes.remove(suiviEtapes)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_SUIVI_ETAPES, this.suiviEtapes.size() + 1, suiviEtapes, null);
    }

    @Override
    public void clearSuiviEtapes() {
        if (this.suiviEtapes == null) {
            return;
        }
        List<SuiviEtape> oldValue = new ArrayList<SuiviEtape>(this.suiviEtapes);
        fireOnPreWrite(PROPERTY_SUIVI_ETAPES, oldValue, this.suiviEtapes);
        this.suiviEtapes.clear();
        fireOnPostWrite(PROPERTY_SUIVI_ETAPES, oldValue, this.suiviEtapes);
    }

    @Override
    public List<SuiviEtape> getSuiviEtapes() {
        return suiviEtapes;
    }

    @Override
    public SuiviEtape getSuiviEtapesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(suiviEtapes, topiaId);
    }

    @Override
    public int sizeSuiviEtapes() {
        if (suiviEtapes == null) {
            return 0;
        }
        return suiviEtapes.size();
    }

    @Override
    public boolean isSuiviEtapesEmpty() {
        int size = sizeSuiviEtapes();
        return size == 0;
    }

    @Override
    public void setReel(Chauffeur reel) {
        Chauffeur oldValue = this.reel;
        fireOnPreWrite(PROPERTY_REEL, oldValue, reel);
        this.reel = reel;
        fireOnPostWrite(PROPERTY_REEL, oldValue, reel);
    }

    @Override
    public Chauffeur getReel() {
        fireOnPreRead(PROPERTY_REEL, reel);
        Chauffeur result = this.reel;
        fireOnPostRead(PROPERTY_REEL, reel);
        return result;
    }

    @Override
    public void addSuiviUsines(SuiviUsine suiviUsines) {
        fireOnPreWrite(PROPERTY_SUIVI_USINES, null, suiviUsines);
        if (this.suiviUsines == null) {
            this.suiviUsines = new ArrayList<SuiviUsine>();
        }

        this.suiviUsines.add(suiviUsines);
        fireOnPostWrite(PROPERTY_SUIVI_USINES, this.suiviUsines.size(), null, suiviUsines);
    }

    @Override
    public void addAllSuiviUsines(List<SuiviUsine> suiviUsines) {
        if (suiviUsines == null) {
            return;
        }
        for (SuiviUsine item : suiviUsines) {
            addSuiviUsines(item);
        }
    }

    @Override
    public void setSuiviUsines(List<SuiviUsine> suiviUsines) {
        // Copy elements to keep data for fire with new reference
        List<SuiviUsine> oldValue = this.suiviUsines != null ? new ArrayList<SuiviUsine>(this.suiviUsines) : null;
        fireOnPreWrite(PROPERTY_SUIVI_USINES, oldValue, suiviUsines);
        this.suiviUsines = suiviUsines;
        fireOnPostWrite(PROPERTY_SUIVI_USINES, oldValue, suiviUsines);
    }

    @Override
    public void removeSuiviUsines(SuiviUsine suiviUsines) {
        fireOnPreWrite(PROPERTY_SUIVI_USINES, suiviUsines, null);
        if (this.suiviUsines == null || !this.suiviUsines.remove(suiviUsines)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_SUIVI_USINES, this.suiviUsines.size() + 1, suiviUsines, null);
    }

    @Override
    public void clearSuiviUsines() {
        if (this.suiviUsines == null) {
            return;
        }
        List<SuiviUsine> oldValue = new ArrayList<SuiviUsine>(this.suiviUsines);
        fireOnPreWrite(PROPERTY_SUIVI_USINES, oldValue, this.suiviUsines);
        this.suiviUsines.clear();
        fireOnPostWrite(PROPERTY_SUIVI_USINES, oldValue, this.suiviUsines);
    }

    @Override
    public List<SuiviUsine> getSuiviUsines() {
        return suiviUsines;
    }

    @Override
    public SuiviUsine getSuiviUsinesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(suiviUsines, topiaId);
    }

    @Override
    public int sizeSuiviUsines() {
        if (suiviUsines == null) {
            return 0;
        }
        return suiviUsines.size();
    }

    @Override
    public boolean isSuiviUsinesEmpty() {
        int size = sizeSuiviUsines();
        return size == 0;
    }

    @Override
    public void setCRTour(CRTour cRTour) {
        CRTour oldValue = this.cRTour;
        fireOnPreWrite(PROPERTY_C_RTOUR, oldValue, cRTour);
        this.cRTour = cRTour;
        fireOnPostWrite(PROPERTY_C_RTOUR, oldValue, cRTour);
    }

    @Override
    public CRTour getCRTour() {
        fireOnPreRead(PROPERTY_C_RTOUR, cRTour);
        CRTour result = this.cRTour;
        fireOnPostRead(PROPERTY_C_RTOUR, cRTour);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_STATUS, this.status).
            append(PROPERTY_CHAUFFEUR_NOM_PRENOM, this.chauffeurNomPrenom).
            append(PROPERTY_DUREE, this.duree).
            append(PROPERTY_LITRES_GASOIL, this.litresGasoil).
            append(PROPERTY_KM_DEPART, this.kmDepart).
            append(PROPERTY_KM_ARRIVEE, this.kmArrivee).
            append(PROPERTY_SUIVI_ETAPES, this.suiviEtapes).
            append(PROPERTY_REEL, this.reel).
            append(PROPERTY_SUIVI_USINES, this.suiviUsines).
            append(PROPERTY_C_RTOUR, this.cRTour).
         toString();
        return result;
    }

} //SuiviTourAbstract
