package com.cybelia.sandra.entities.trace;

import com.cybelia.sandra.entities.Etape;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class SuiviEtapeAbstract extends TopiaEntityAbstract implements SuiviEtape {

    /**
     * order defined during the chargement. Start at 0 like Etape
     * Nom de l'attribut en BD : nouvelleOrdre
     */
    protected int nouvelleOrdre;

    /**
     * Nom de l'attribut en BD : status
     */
    protected int status;

    /**
     * Nom de l'attribut en BD : dateEntree
     */
    protected Date dateEntree;

    /**
     * l'étape finale n'a pas d'heure de sortie mais une heure de fin de tournée.
     * Nom de l'attribut en BD : dateSortie
     */
    protected Date dateSortie;

    /**
     * Nom de l'attribut en BD : cREtape
     */
    protected CREtape cREtape;

    /**
     * Nom de l'attribut en BD : etape
     */
    protected Etape etape;

    private static final long serialVersionUID = 7075547748059342135L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NOUVELLE_ORDRE, int.class, nouvelleOrdre);
        visitor.visit(this, PROPERTY_STATUS, int.class, status);
        visitor.visit(this, PROPERTY_DATE_ENTREE, Date.class, dateEntree);
        visitor.visit(this, PROPERTY_DATE_SORTIE, Date.class, dateSortie);
        visitor.visit(this, PROPERTY_C_RETAPE, CREtape.class, cREtape);
        visitor.visit(this, PROPERTY_ETAPE, Etape.class, etape);
        visitor.end(this);
    }

    @Override
    public void setNouvelleOrdre(int nouvelleOrdre) {
        int oldValue = this.nouvelleOrdre;
        fireOnPreWrite(PROPERTY_NOUVELLE_ORDRE, oldValue, nouvelleOrdre);
        this.nouvelleOrdre = nouvelleOrdre;
        fireOnPostWrite(PROPERTY_NOUVELLE_ORDRE, oldValue, nouvelleOrdre);
    }

    @Override
    public int getNouvelleOrdre() {
        fireOnPreRead(PROPERTY_NOUVELLE_ORDRE, nouvelleOrdre);
        int result = this.nouvelleOrdre;
        fireOnPostRead(PROPERTY_NOUVELLE_ORDRE, nouvelleOrdre);
        return result;
    }

    @Override
    public void setStatus(int status) {
        int oldValue = this.status;
        fireOnPreWrite(PROPERTY_STATUS, oldValue, status);
        this.status = status;
        fireOnPostWrite(PROPERTY_STATUS, oldValue, status);
    }

    @Override
    public int getStatus() {
        fireOnPreRead(PROPERTY_STATUS, status);
        int result = this.status;
        fireOnPostRead(PROPERTY_STATUS, status);
        return result;
    }

    @Override
    public void setDateEntree(Date dateEntree) {
        Date oldValue = this.dateEntree;
        fireOnPreWrite(PROPERTY_DATE_ENTREE, oldValue, dateEntree);
        this.dateEntree = dateEntree;
        fireOnPostWrite(PROPERTY_DATE_ENTREE, oldValue, dateEntree);
    }

    @Override
    public Date getDateEntree() {
        fireOnPreRead(PROPERTY_DATE_ENTREE, dateEntree);
        Date result = this.dateEntree;
        fireOnPostRead(PROPERTY_DATE_ENTREE, dateEntree);
        return result;
    }

    @Override
    public void setDateSortie(Date dateSortie) {
        Date oldValue = this.dateSortie;
        fireOnPreWrite(PROPERTY_DATE_SORTIE, oldValue, dateSortie);
        this.dateSortie = dateSortie;
        fireOnPostWrite(PROPERTY_DATE_SORTIE, oldValue, dateSortie);
    }

    @Override
    public Date getDateSortie() {
        fireOnPreRead(PROPERTY_DATE_SORTIE, dateSortie);
        Date result = this.dateSortie;
        fireOnPostRead(PROPERTY_DATE_SORTIE, dateSortie);
        return result;
    }

    @Override
    public void setCREtape(CREtape cREtape) {
        CREtape oldValue = this.cREtape;
        fireOnPreWrite(PROPERTY_C_RETAPE, oldValue, cREtape);
        this.cREtape = cREtape;
        fireOnPostWrite(PROPERTY_C_RETAPE, oldValue, cREtape);
    }

    @Override
    public CREtape getCREtape() {
        fireOnPreRead(PROPERTY_C_RETAPE, cREtape);
        CREtape result = this.cREtape;
        fireOnPostRead(PROPERTY_C_RETAPE, cREtape);
        return result;
    }

    @Override
    public void setEtape(Etape etape) {
        Etape oldValue = this.etape;
        fireOnPreWrite(PROPERTY_ETAPE, oldValue, etape);
        this.etape = etape;
        fireOnPostWrite(PROPERTY_ETAPE, oldValue, etape);
    }

    @Override
    public Etape getEtape() {
        fireOnPreRead(PROPERTY_ETAPE, etape);
        Etape result = this.etape;
        fireOnPostRead(PROPERTY_ETAPE, etape);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NOUVELLE_ORDRE, this.nouvelleOrdre).
            append(PROPERTY_STATUS, this.status).
            append(PROPERTY_DATE_ENTREE, this.dateEntree).
            append(PROPERTY_DATE_SORTIE, this.dateSortie).
            append(PROPERTY_C_RETAPE, this.cREtape).
            append(PROPERTY_ETAPE, this.etape).
         toString();
        return result;
    }

} //SuiviEtapeAbstract
