package com.cybelia.sandra.entities.trace;

import com.cybelia.sandra.SandraDAOHelper.SandraEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class CRUsineDAOAbstract<E extends CRUsine> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)CRUsine.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.CRUsine;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<SuiviUsine> list = getContext()
                                                    .getDAO(SuiviUsine.class)
                                                    .findAllByProperties(SuiviUsine.PROPERTY_C_RUSINE, entity);
                                            for (SuiviUsine item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getCRUsine())) {
                                                    item.setCRUsine(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == SuiviUsine.class) {
            SuiviUsineDAO dao = (SuiviUsineDAO)
                getContext().getDAO(SuiviUsine.class);
            tmp = dao.findAllByCRUsine(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(SuiviUsine.class, entity);
        if (!list.isEmpty()) {
            result.put(SuiviUsine.class, list);
        }

        return result;
    }

} //CRUsineDAOAbstract<E extends CRUsine>
