package com.cybelia.sandra.entities.trace;

import com.cybelia.sandra.SandraDAOHelper.SandraEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class CRTourDAOAbstract<E extends CRTour> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)CRTour.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.CRTour;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<SuiviTour> list = getContext()
                                                    .getDAO(SuiviTour.class)
                                                    .findAllByProperties(SuiviTour.PROPERTY_C_RTOUR, entity);
                                            for (SuiviTour item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getCRTour())) {
                                                    item.setCRTour(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByRemarques(String v) throws TopiaException {
        E result = findByProperty(CRTour.PROPERTY_REMARQUES, v);
        return result;
    }

    public List<E> findAllByRemarques(String v) throws TopiaException {
        List<E> result = findAllByProperty(CRTour.PROPERTY_REMARQUES, v);
        return result;
    }

    public E findByRetourMP(String v) throws TopiaException {
        E result = findByProperty(CRTour.PROPERTY_RETOUR_MP, v);
        return result;
    }

    public List<E> findAllByRetourMP(String v) throws TopiaException {
        List<E> result = findAllByProperty(CRTour.PROPERTY_RETOUR_MP, v);
        return result;
    }

    public E findByReprise(String v) throws TopiaException {
        E result = findByProperty(CRTour.PROPERTY_REPRISE, v);
        return result;
    }

    public List<E> findAllByReprise(String v) throws TopiaException {
        List<E> result = findAllByProperty(CRTour.PROPERTY_REPRISE, v);
        return result;
    }

    public E findByTransfert(String v) throws TopiaException {
        E result = findByProperty(CRTour.PROPERTY_TRANSFERT, v);
        return result;
    }

    public List<E> findAllByTransfert(String v) throws TopiaException {
        List<E> result = findAllByProperty(CRTour.PROPERTY_TRANSFERT, v);
        return result;
    }

    public E findByPurgeUsine(boolean v) throws TopiaException {
        E result = findByProperty(CRTour.PROPERTY_PURGE_USINE, v);
        return result;
    }

    public List<E> findAllByPurgeUsine(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(CRTour.PROPERTY_PURGE_USINE, v);
        return result;
    }

    public E findByRincageUsine(boolean v) throws TopiaException {
        E result = findByProperty(CRTour.PROPERTY_RINCAGE_USINE, v);
        return result;
    }

    public List<E> findAllByRincageUsine(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(CRTour.PROPERTY_RINCAGE_USINE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == SuiviTour.class) {
            SuiviTourDAO dao = (SuiviTourDAO)
                getContext().getDAO(SuiviTour.class);
            tmp = dao.findAllByCRTour(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(SuiviTour.class, entity);
        if (!list.isEmpty()) {
            result.put(SuiviTour.class, list);
        }

        return result;
    }

} //CRTourDAOAbstract<E extends CRTour>
