package com.cybelia.sandra.entities.trace;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class CRTourAbstract extends TopiaEntityAbstract implements CRTour {

    /**
     * Nom de l'attribut en BD : remarques
     */
    protected String remarques;

    /**
     * Nom de l'attribut en BD : retourMP
     */
    protected String retourMP;

    /**
     * Nom de l'attribut en BD : reprise
     */
    protected String reprise;

    /**
     * Nom de l'attribut en BD : transfert
     */
    protected String transfert;

    /**
     * Nom de l'attribut en BD : purgeUsine
     */
    protected boolean purgeUsine;

    /**
     * Nom de l'attribut en BD : rincageUsine
     */
    protected boolean rincageUsine;

    private static final long serialVersionUID = 3558466240502915942L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_REMARQUES, String.class, remarques);
        visitor.visit(this, PROPERTY_RETOUR_MP, String.class, retourMP);
        visitor.visit(this, PROPERTY_REPRISE, String.class, reprise);
        visitor.visit(this, PROPERTY_TRANSFERT, String.class, transfert);
        visitor.visit(this, PROPERTY_PURGE_USINE, boolean.class, purgeUsine);
        visitor.visit(this, PROPERTY_RINCAGE_USINE, boolean.class, rincageUsine);
        visitor.end(this);
    }

    @Override
    public void setRemarques(String remarques) {
        String oldValue = this.remarques;
        fireOnPreWrite(PROPERTY_REMARQUES, oldValue, remarques);
        this.remarques = remarques;
        fireOnPostWrite(PROPERTY_REMARQUES, oldValue, remarques);
    }

    @Override
    public String getRemarques() {
        fireOnPreRead(PROPERTY_REMARQUES, remarques);
        String result = this.remarques;
        fireOnPostRead(PROPERTY_REMARQUES, remarques);
        return result;
    }

    @Override
    public void setRetourMP(String retourMP) {
        String oldValue = this.retourMP;
        fireOnPreWrite(PROPERTY_RETOUR_MP, oldValue, retourMP);
        this.retourMP = retourMP;
        fireOnPostWrite(PROPERTY_RETOUR_MP, oldValue, retourMP);
    }

    @Override
    public String getRetourMP() {
        fireOnPreRead(PROPERTY_RETOUR_MP, retourMP);
        String result = this.retourMP;
        fireOnPostRead(PROPERTY_RETOUR_MP, retourMP);
        return result;
    }

    @Override
    public void setReprise(String reprise) {
        String oldValue = this.reprise;
        fireOnPreWrite(PROPERTY_REPRISE, oldValue, reprise);
        this.reprise = reprise;
        fireOnPostWrite(PROPERTY_REPRISE, oldValue, reprise);
    }

    @Override
    public String getReprise() {
        fireOnPreRead(PROPERTY_REPRISE, reprise);
        String result = this.reprise;
        fireOnPostRead(PROPERTY_REPRISE, reprise);
        return result;
    }

    @Override
    public void setTransfert(String transfert) {
        String oldValue = this.transfert;
        fireOnPreWrite(PROPERTY_TRANSFERT, oldValue, transfert);
        this.transfert = transfert;
        fireOnPostWrite(PROPERTY_TRANSFERT, oldValue, transfert);
    }

    @Override
    public String getTransfert() {
        fireOnPreRead(PROPERTY_TRANSFERT, transfert);
        String result = this.transfert;
        fireOnPostRead(PROPERTY_TRANSFERT, transfert);
        return result;
    }

    @Override
    public void setPurgeUsine(boolean purgeUsine) {
        boolean oldValue = this.purgeUsine;
        fireOnPreWrite(PROPERTY_PURGE_USINE, oldValue, purgeUsine);
        this.purgeUsine = purgeUsine;
        fireOnPostWrite(PROPERTY_PURGE_USINE, oldValue, purgeUsine);
    }

    @Override
    public boolean isPurgeUsine() {
        fireOnPreRead(PROPERTY_PURGE_USINE, purgeUsine);
        boolean result = this.purgeUsine;
        fireOnPostRead(PROPERTY_PURGE_USINE, purgeUsine);
        return result;
    }

    @Override
    public boolean getPurgeUsine() {
        fireOnPreRead(PROPERTY_PURGE_USINE, purgeUsine);
        boolean result = this.purgeUsine;
        fireOnPostRead(PROPERTY_PURGE_USINE, purgeUsine);
        return result;
    }

    @Override
    public void setRincageUsine(boolean rincageUsine) {
        boolean oldValue = this.rincageUsine;
        fireOnPreWrite(PROPERTY_RINCAGE_USINE, oldValue, rincageUsine);
        this.rincageUsine = rincageUsine;
        fireOnPostWrite(PROPERTY_RINCAGE_USINE, oldValue, rincageUsine);
    }

    @Override
    public boolean isRincageUsine() {
        fireOnPreRead(PROPERTY_RINCAGE_USINE, rincageUsine);
        boolean result = this.rincageUsine;
        fireOnPostRead(PROPERTY_RINCAGE_USINE, rincageUsine);
        return result;
    }

    @Override
    public boolean getRincageUsine() {
        fireOnPreRead(PROPERTY_RINCAGE_USINE, rincageUsine);
        boolean result = this.rincageUsine;
        fireOnPostRead(PROPERTY_RINCAGE_USINE, rincageUsine);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_REMARQUES, this.remarques).
            append(PROPERTY_RETOUR_MP, this.retourMP).
            append(PROPERTY_REPRISE, this.reprise).
            append(PROPERTY_TRANSFERT, this.transfert).
            append(PROPERTY_PURGE_USINE, this.purgeUsine).
            append(PROPERTY_RINCAGE_USINE, this.rincageUsine).
         toString();
        return result;
    }

} //CRTourAbstract
