package com.cybelia.sandra.entities.trace;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class CREtapeAbstract extends TopiaEntityAbstract implements CREtape {

    /**
     * Nom de l'attribut en BD : etapeHeureLivraison
     */
    protected Date etapeHeureLivraison;

    /**
     * Nom de l'attribut en BD : purge
     */
    protected int purge;

    /**
     * Nom de l'attribut en BD : livraisonStatut
     */
    protected String livraisonStatut;

    /**
     * Nom de l'attribut en BD : commentaireLivraison
     */
    protected String commentaireLivraison;

    private static final long serialVersionUID = 7017563012956436325L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_ETAPE_HEURE_LIVRAISON, Date.class, etapeHeureLivraison);
        visitor.visit(this, PROPERTY_PURGE, int.class, purge);
        visitor.visit(this, PROPERTY_LIVRAISON_STATUT, String.class, livraisonStatut);
        visitor.visit(this, PROPERTY_COMMENTAIRE_LIVRAISON, String.class, commentaireLivraison);
        visitor.end(this);
    }

    @Override
    public void setEtapeHeureLivraison(Date etapeHeureLivraison) {
        Date oldValue = this.etapeHeureLivraison;
        fireOnPreWrite(PROPERTY_ETAPE_HEURE_LIVRAISON, oldValue, etapeHeureLivraison);
        this.etapeHeureLivraison = etapeHeureLivraison;
        fireOnPostWrite(PROPERTY_ETAPE_HEURE_LIVRAISON, oldValue, etapeHeureLivraison);
    }

    @Override
    public Date getEtapeHeureLivraison() {
        fireOnPreRead(PROPERTY_ETAPE_HEURE_LIVRAISON, etapeHeureLivraison);
        Date result = this.etapeHeureLivraison;
        fireOnPostRead(PROPERTY_ETAPE_HEURE_LIVRAISON, etapeHeureLivraison);
        return result;
    }

    @Override
    public void setPurge(int purge) {
        int oldValue = this.purge;
        fireOnPreWrite(PROPERTY_PURGE, oldValue, purge);
        this.purge = purge;
        fireOnPostWrite(PROPERTY_PURGE, oldValue, purge);
    }

    @Override
    public int getPurge() {
        fireOnPreRead(PROPERTY_PURGE, purge);
        int result = this.purge;
        fireOnPostRead(PROPERTY_PURGE, purge);
        return result;
    }

    @Override
    public void setLivraisonStatut(String livraisonStatut) {
        String oldValue = this.livraisonStatut;
        fireOnPreWrite(PROPERTY_LIVRAISON_STATUT, oldValue, livraisonStatut);
        this.livraisonStatut = livraisonStatut;
        fireOnPostWrite(PROPERTY_LIVRAISON_STATUT, oldValue, livraisonStatut);
    }

    @Override
    public String getLivraisonStatut() {
        fireOnPreRead(PROPERTY_LIVRAISON_STATUT, livraisonStatut);
        String result = this.livraisonStatut;
        fireOnPostRead(PROPERTY_LIVRAISON_STATUT, livraisonStatut);
        return result;
    }

    @Override
    public void setCommentaireLivraison(String commentaireLivraison) {
        String oldValue = this.commentaireLivraison;
        fireOnPreWrite(PROPERTY_COMMENTAIRE_LIVRAISON, oldValue, commentaireLivraison);
        this.commentaireLivraison = commentaireLivraison;
        fireOnPostWrite(PROPERTY_COMMENTAIRE_LIVRAISON, oldValue, commentaireLivraison);
    }

    @Override
    public String getCommentaireLivraison() {
        fireOnPreRead(PROPERTY_COMMENTAIRE_LIVRAISON, commentaireLivraison);
        String result = this.commentaireLivraison;
        fireOnPostRead(PROPERTY_COMMENTAIRE_LIVRAISON, commentaireLivraison);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_ETAPE_HEURE_LIVRAISON, this.etapeHeureLivraison).
            append(PROPERTY_PURGE, this.purge).
            append(PROPERTY_LIVRAISON_STATUT, this.livraisonStatut).
            append(PROPERTY_COMMENTAIRE_LIVRAISON, this.commentaireLivraison).
         toString();
        return result;
    }

} //CREtapeAbstract
