package com.cybelia.sandra.entities.synchro;

import com.cybelia.sandra.SandraDAOHelper.SandraEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class LogDAOAbstract<E extends Log> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Log.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.Log;
    }

    public E findBySynchroNumber(long v) throws TopiaException {
        E result = findByProperty(Log.PROPERTY_SYNCHRO_NUMBER, v);
        return result;
    }

    public List<E> findAllBySynchroNumber(long v) throws TopiaException {
        List<E> result = findAllByProperty(Log.PROPERTY_SYNCHRO_NUMBER, v);
        return result;
    }

    public E findByTimeStamp(long v) throws TopiaException {
        E result = findByProperty(Log.PROPERTY_TIME_STAMP, v);
        return result;
    }

    public List<E> findAllByTimeStamp(long v) throws TopiaException {
        List<E> result = findAllByProperty(Log.PROPERTY_TIME_STAMP, v);
        return result;
    }

    public E findByTourTopiaID(String v) throws TopiaException {
        E result = findByProperty(Log.PROPERTY_TOUR_TOPIA_ID, v);
        return result;
    }

    public List<E> findAllByTourTopiaID(String v) throws TopiaException {
        List<E> result = findAllByProperty(Log.PROPERTY_TOUR_TOPIA_ID, v);
        return result;
    }

    public E findByTypeModif(int v) throws TopiaException {
        E result = findByProperty(Log.PROPERTY_TYPE_MODIF, v);
        return result;
    }

    public List<E> findAllByTypeModif(int v) throws TopiaException {
        List<E> result = findAllByProperty(Log.PROPERTY_TYPE_MODIF, v);
        return result;
    }

    public E findByFichierSynchro(String v) throws TopiaException {
        E result = findByProperty(Log.PROPERTY_FICHIER_SYNCHRO, v);
        return result;
    }

    public List<E> findAllByFichierSynchro(String v) throws TopiaException {
        List<E> result = findAllByProperty(Log.PROPERTY_FICHIER_SYNCHRO, v);
        return result;
    }

    public E findByCamionTopiaID(String v) throws TopiaException {
        E result = findByProperty(Log.PROPERTY_CAMION_TOPIA_ID, v);
        return result;
    }

    public List<E> findAllByCamionTopiaID(String v) throws TopiaException {
        List<E> result = findAllByProperty(Log.PROPERTY_CAMION_TOPIA_ID, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //LogDAOAbstract<E extends Log>
