package com.cybelia.sandra.entities.sig;

import com.cybelia.sandra.SandraDAOHelper.SandraEntityEnum;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.InfoAccessDAO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class TraceGPSDAOAbstract<E extends TraceGPS> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)TraceGPS.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.TraceGPS;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<InfoAccess> list = getContext()
                                                    .getDAO(InfoAccess.class)
                                                    .findAllByProperties(InfoAccess.PROPERTY_TRACE, entity);
                                            for (InfoAccess item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getTrace())) {
                                                    item.setTrace(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByLastPointOrder(int v) throws TopiaException {
        E result = findByProperty(TraceGPS.PROPERTY_LAST_POINT_ORDER, v);
        return result;
    }

    public List<E> findAllByLastPointOrder(int v) throws TopiaException {
        List<E> result = findAllByProperty(TraceGPS.PROPERTY_LAST_POINT_ORDER, v);
        return result;
    }

    public E findContainsListePoints(PointGPS v) throws TopiaException {
        E result = findContains(TraceGPS.PROPERTY_LISTE_POINTS, v);
        return result;
    }

    public List<E> findAllContainsListePoints(PointGPS v) throws TopiaException {
        List<E> result = findAllContains(TraceGPS.PROPERTY_LISTE_POINTS, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == InfoAccess.class) {
            InfoAccessDAO dao = (InfoAccessDAO)
                getContext().getDAO(InfoAccess.class);
            tmp = dao.findAllByTrace(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(InfoAccess.class, entity);
        if (!list.isEmpty()) {
            result.put(InfoAccess.class, list);
        }

        return result;
    }

} //TraceGPSDAOAbstract<E extends TraceGPS>
