package com.cybelia.sandra.entities.sig;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class TraceGPSAbstract extends TopiaEntityAbstract implements TraceGPS {

    /**
     * start a -1 : no lieu. from 0 to (n-1) lieu
     * Nom de l'attribut en BD : lastPointOrder
     */
    protected int lastPointOrder;

    /**
     * Nom de l'attribut en BD : listePoints
     */
    protected List<PointGPS> listePoints;

    private static final long serialVersionUID = 3703700765875987765L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_LAST_POINT_ORDER, int.class, lastPointOrder);
        visitor.visit(this, PROPERTY_LISTE_POINTS, List.class, PointGPS.class, listePoints);
        visitor.end(this);
    }

    @Override
    public void setLastPointOrder(int lastPointOrder) {
        int oldValue = this.lastPointOrder;
        fireOnPreWrite(PROPERTY_LAST_POINT_ORDER, oldValue, lastPointOrder);
        this.lastPointOrder = lastPointOrder;
        fireOnPostWrite(PROPERTY_LAST_POINT_ORDER, oldValue, lastPointOrder);
    }

    @Override
    public int getLastPointOrder() {
        fireOnPreRead(PROPERTY_LAST_POINT_ORDER, lastPointOrder);
        int result = this.lastPointOrder;
        fireOnPostRead(PROPERTY_LAST_POINT_ORDER, lastPointOrder);
        return result;
    }

    @Override
    public void addListePoints(PointGPS listePoints) {
        fireOnPreWrite(PROPERTY_LISTE_POINTS, null, listePoints);
        if (this.listePoints == null) {
            this.listePoints = new ArrayList<PointGPS>();
        }

        this.listePoints.add(listePoints);
        fireOnPostWrite(PROPERTY_LISTE_POINTS, this.listePoints.size(), null, listePoints);
    }

    @Override
    public void addAllListePoints(List<PointGPS> listePoints) {
        if (listePoints == null) {
            return;
        }
        for (PointGPS item : listePoints) {
            addListePoints(item);
        }
    }

    @Override
    public void setListePoints(List<PointGPS> listePoints) {
        // Copy elements to keep data for fire with new reference
        List<PointGPS> oldValue = this.listePoints != null ? new ArrayList<PointGPS>(this.listePoints) : null;
        fireOnPreWrite(PROPERTY_LISTE_POINTS, oldValue, listePoints);
        this.listePoints = listePoints;
        fireOnPostWrite(PROPERTY_LISTE_POINTS, oldValue, listePoints);
    }

    @Override
    public void removeListePoints(PointGPS listePoints) {
        fireOnPreWrite(PROPERTY_LISTE_POINTS, listePoints, null);
        if (this.listePoints == null || !this.listePoints.remove(listePoints)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_LISTE_POINTS, this.listePoints.size() + 1, listePoints, null);
    }

    @Override
    public void clearListePoints() {
        if (this.listePoints == null) {
            return;
        }
        List<PointGPS> oldValue = new ArrayList<PointGPS>(this.listePoints);
        fireOnPreWrite(PROPERTY_LISTE_POINTS, oldValue, this.listePoints);
        this.listePoints.clear();
        fireOnPostWrite(PROPERTY_LISTE_POINTS, oldValue, this.listePoints);
    }

    @Override
    public List<PointGPS> getListePoints() {
        return listePoints;
    }

    @Override
    public PointGPS getListePointsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(listePoints, topiaId);
    }

    @Override
    public int sizeListePoints() {
        if (listePoints == null) {
            return 0;
        }
        return listePoints.size();
    }

    @Override
    public boolean isListePointsEmpty() {
        int size = sizeListePoints();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        if (getListePoints() != null) {
              tmp.addAll(getListePoints());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_LAST_POINT_ORDER, this.lastPointOrder).
            append(PROPERTY_LISTE_POINTS, this.listePoints).
         toString();
        return result;
    }

} //TraceGPSAbstract
