package com.cybelia.sandra.entities.sig;

import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class PointGPSAbstract extends TopiaEntityAbstract implements PointGPS {

    /**
     * Nom de l'attribut en BD : ordre
     */
    protected int ordre;

    /**
     * Nom de l'attribut en BD : point
     */
    protected Point point;

    private static final long serialVersionUID = 7365418805254971956L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_ORDRE, int.class, ordre);
        visitor.visit(this, PROPERTY_POINT, Point.class, point);
        visitor.end(this);
    }

    @Override
    public void setOrdre(int ordre) {
        int oldValue = this.ordre;
        fireOnPreWrite(PROPERTY_ORDRE, oldValue, ordre);
        this.ordre = ordre;
        fireOnPostWrite(PROPERTY_ORDRE, oldValue, ordre);
    }

    @Override
    public int getOrdre() {
        fireOnPreRead(PROPERTY_ORDRE, ordre);
        int result = this.ordre;
        fireOnPostRead(PROPERTY_ORDRE, ordre);
        return result;
    }

    @Override
    public void setPoint(Point point) {
        Point oldValue = this.point;
        fireOnPreWrite(PROPERTY_POINT, oldValue, point);
        this.point = point;
        fireOnPostWrite(PROPERTY_POINT, oldValue, point);
    }

    @Override
    public Point getPoint() {
        fireOnPreRead(PROPERTY_POINT, point);
        Point result = this.point;
        fireOnPostRead(PROPERTY_POINT, point);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_ORDRE, this.ordre).
            append(PROPERTY_POINT, this.point).
         toString();
        return result;
    }

} //PointGPSAbstract
