package com.cybelia.sandra.entities.notifier;

import com.cybelia.sandra.SandraDAOHelper.SandraEntityEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class QueueDAOAbstract<E extends Queue> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Queue.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.Queue;
    }

    public E findByDate(Date v) throws TopiaException {
        E result = findByProperty(Queue.PROPERTY_DATE, v);
        return result;
    }

    public List<E> findAllByDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Queue.PROPERTY_DATE, v);
        return result;
    }

    public E findContainsValues(String v) throws TopiaException {
        E result = findContains(Queue.PROPERTY_VALUES, v);
        return result;
    }

    public List<E> findAllContainsValues(String v) throws TopiaException {
        List<E> result = findAllContains(Queue.PROPERTY_VALUES, v);
        return result;
    }

    public E findByEvent(Event v) throws TopiaException {
        E result = findByProperty(Queue.PROPERTY_EVENT, v);
        return result;
    }

    public List<E> findAllByEvent(Event v) throws TopiaException {
        List<E> result = findAllByProperty(Queue.PROPERTY_EVENT, v);
        return result;
    }

    public E findContainsCron(Cron v) throws TopiaException {
        E result = findContains(Queue.PROPERTY_CRON, v);
        return result;
    }

    public List<E> findAllContainsCron(Cron v) throws TopiaException {
        List<E> result = findAllContains(Queue.PROPERTY_CRON, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //QueueDAOAbstract<E extends Queue>
