package com.cybelia.sandra.entities.notifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class QueueAbstract extends TopiaEntityAbstract implements Queue {

    /**
     * Nom de l'attribut en BD : date
     */
    protected Date date;

    /**
     * Nom de l'attribut en BD : values
     */
    protected Collection<String> values;

    /**
     * Nom de l'attribut en BD : event
     */
    protected Event event;

    /**
     * Nom de l'attribut en BD : cron
     */
    protected Collection<Cron> cron;

    private static final long serialVersionUID = 3847817019067216432L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_DATE, Date.class, date);
        visitor.visit(this, PROPERTY_VALUES, Collection.class, String.class, values);
        visitor.visit(this, PROPERTY_EVENT, Event.class, event);
        visitor.visit(this, PROPERTY_CRON, Collection.class, Cron.class, cron);
        visitor.end(this);
    }

    @Override
    public void setDate(Date date) {
        Date oldValue = this.date;
        fireOnPreWrite(PROPERTY_DATE, oldValue, date);
        this.date = date;
        fireOnPostWrite(PROPERTY_DATE, oldValue, date);
    }

    @Override
    public Date getDate() {
        fireOnPreRead(PROPERTY_DATE, date);
        Date result = this.date;
        fireOnPostRead(PROPERTY_DATE, date);
        return result;
    }

    @Override
    public void addValues(String values) {
        fireOnPreWrite(PROPERTY_VALUES, null, values);
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }

        this.values.add(values);
        fireOnPostWrite(PROPERTY_VALUES, this.values.size(), null, values);
    }

    @Override
    public void addAllValues(Collection<String> values) {
        if (values == null) {
            return;
        }
        for (String item : values) {
            addValues(item);
        }
    }

    @Override
    public void setValues(Collection<String> values) {
        // Copy elements to keep data for fire with new reference
        Collection<String> oldValue = this.values != null ? new ArrayList<String>(this.values) : null;
        fireOnPreWrite(PROPERTY_VALUES, oldValue, values);
        this.values = values;
        fireOnPostWrite(PROPERTY_VALUES, oldValue, values);
    }

    @Override
    public void removeValues(String values) {
        fireOnPreWrite(PROPERTY_VALUES, values, null);
        if (this.values == null || !this.values.remove(values)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_VALUES, this.values.size() + 1, values, null);
    }

    @Override
    public void clearValues() {
        if (this.values == null) {
            return;
        }
        Collection<String> oldValue = new ArrayList<String>(this.values);
        fireOnPreWrite(PROPERTY_VALUES, oldValue, this.values);
        this.values.clear();
        fireOnPostWrite(PROPERTY_VALUES, oldValue, this.values);
    }

    @Override
    public Collection<String> getValues() {
        return values;
    }

    @Override
    public int sizeValues() {
        if (values == null) {
            return 0;
        }
        return values.size();
    }

    @Override
    public boolean isValuesEmpty() {
        int size = sizeValues();
        return size == 0;
    }

    @Override
    public void setEvent(Event event) {
        Event oldValue = this.event;
        fireOnPreWrite(PROPERTY_EVENT, oldValue, event);
        this.event = event;
        fireOnPostWrite(PROPERTY_EVENT, oldValue, event);
    }

    @Override
    public Event getEvent() {
        fireOnPreRead(PROPERTY_EVENT, event);
        Event result = this.event;
        fireOnPostRead(PROPERTY_EVENT, event);
        return result;
    }

    @Override
    public void addCron(Cron cron) {
        fireOnPreWrite(PROPERTY_CRON, null, cron);
        if (this.cron == null) {
            this.cron = new ArrayList<Cron>();
        }

        this.cron.add(cron);
        fireOnPostWrite(PROPERTY_CRON, this.cron.size(), null, cron);
    }

    @Override
    public void addAllCron(Collection<Cron> cron) {
        if (cron == null) {
            return;
        }
        for (Cron item : cron) {
            addCron(item);
        }
    }

    @Override
    public void setCron(Collection<Cron> cron) {
        // Copy elements to keep data for fire with new reference
        Collection<Cron> oldValue = this.cron != null ? new ArrayList<Cron>(this.cron) : null;
        fireOnPreWrite(PROPERTY_CRON, oldValue, cron);
        this.cron = cron;
        fireOnPostWrite(PROPERTY_CRON, oldValue, cron);
    }

    @Override
    public void removeCron(Cron cron) {
        fireOnPreWrite(PROPERTY_CRON, cron, null);
        if (this.cron == null || !this.cron.remove(cron)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_CRON, this.cron.size() + 1, cron, null);
    }

    @Override
    public void clearCron() {
        if (this.cron == null) {
            return;
        }
        Collection<Cron> oldValue = new ArrayList<Cron>(this.cron);
        fireOnPreWrite(PROPERTY_CRON, oldValue, this.cron);
        this.cron.clear();
        fireOnPostWrite(PROPERTY_CRON, oldValue, this.cron);
    }

    @Override
    public Collection<Cron> getCron() {
        return cron;
    }

    @Override
    public Cron getCronByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(cron, topiaId);
    }

    @Override
    public int sizeCron() {
        if (cron == null) {
            return 0;
        }
        return cron.size();
    }

    @Override
    public boolean isCronEmpty() {
        int size = sizeCron();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_DATE, this.date).
            append(PROPERTY_VALUES, this.values).
            append(PROPERTY_EVENT, this.event).
            append(PROPERTY_CRON, this.cron).
         toString();
        return result;
    }

} //QueueAbstract
