package com.cybelia.sandra.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class UsineAbstract extends LieuImpl implements Usine {

    /**
     * Nom de l'attribut en BD : adresse
     */
    protected String adresse;

    /**
     * Nom de l'attribut en BD : codePostal
     */
    protected String codePostal;

    /**
     * Nom de l'attribut en BD : ville
     */
    protected String ville;

    /**
     * Nom de l'attribut en BD : codeINSEE
     */
    protected String codeINSEE;

    /**
     * Nom de l'attribut en BD : blockGPSModif
     */
    protected boolean blockGPSModif;

    private static final long serialVersionUID = 7306638711703561010L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_ADRESSE, String.class, adresse);
        visitor.visit(this, PROPERTY_CODE_POSTAL, String.class, codePostal);
        visitor.visit(this, PROPERTY_VILLE, String.class, ville);
        visitor.visit(this, PROPERTY_CODE_INSEE, String.class, codeINSEE);
        visitor.visit(this, PROPERTY_BLOCK_GPSMODIF, boolean.class, blockGPSModif);
        visitor.end(this);
    }

    @Override
    public void setAdresse(String adresse) {
        String oldValue = this.adresse;
        fireOnPreWrite(PROPERTY_ADRESSE, oldValue, adresse);
        this.adresse = adresse;
        fireOnPostWrite(PROPERTY_ADRESSE, oldValue, adresse);
    }

    @Override
    public String getAdresse() {
        fireOnPreRead(PROPERTY_ADRESSE, adresse);
        String result = this.adresse;
        fireOnPostRead(PROPERTY_ADRESSE, adresse);
        return result;
    }

    @Override
    public void setCodePostal(String codePostal) {
        String oldValue = this.codePostal;
        fireOnPreWrite(PROPERTY_CODE_POSTAL, oldValue, codePostal);
        this.codePostal = codePostal;
        fireOnPostWrite(PROPERTY_CODE_POSTAL, oldValue, codePostal);
    }

    @Override
    public String getCodePostal() {
        fireOnPreRead(PROPERTY_CODE_POSTAL, codePostal);
        String result = this.codePostal;
        fireOnPostRead(PROPERTY_CODE_POSTAL, codePostal);
        return result;
    }

    @Override
    public void setVille(String ville) {
        String oldValue = this.ville;
        fireOnPreWrite(PROPERTY_VILLE, oldValue, ville);
        this.ville = ville;
        fireOnPostWrite(PROPERTY_VILLE, oldValue, ville);
    }

    @Override
    public String getVille() {
        fireOnPreRead(PROPERTY_VILLE, ville);
        String result = this.ville;
        fireOnPostRead(PROPERTY_VILLE, ville);
        return result;
    }

    @Override
    public void setCodeINSEE(String codeINSEE) {
        String oldValue = this.codeINSEE;
        fireOnPreWrite(PROPERTY_CODE_INSEE, oldValue, codeINSEE);
        this.codeINSEE = codeINSEE;
        fireOnPostWrite(PROPERTY_CODE_INSEE, oldValue, codeINSEE);
    }

    @Override
    public String getCodeINSEE() {
        fireOnPreRead(PROPERTY_CODE_INSEE, codeINSEE);
        String result = this.codeINSEE;
        fireOnPostRead(PROPERTY_CODE_INSEE, codeINSEE);
        return result;
    }

    @Override
    public void setBlockGPSModif(boolean blockGPSModif) {
        boolean oldValue = this.blockGPSModif;
        fireOnPreWrite(PROPERTY_BLOCK_GPSMODIF, oldValue, blockGPSModif);
        this.blockGPSModif = blockGPSModif;
        fireOnPostWrite(PROPERTY_BLOCK_GPSMODIF, oldValue, blockGPSModif);
    }

    @Override
    public boolean isBlockGPSModif() {
        fireOnPreRead(PROPERTY_BLOCK_GPSMODIF, blockGPSModif);
        boolean result = this.blockGPSModif;
        fireOnPostRead(PROPERTY_BLOCK_GPSMODIF, blockGPSModif);
        return result;
    }

    @Override
    public boolean getBlockGPSModif() {
        fireOnPreRead(PROPERTY_BLOCK_GPSMODIF, blockGPSModif);
        boolean result = this.blockGPSModif;
        fireOnPostRead(PROPERTY_BLOCK_GPSMODIF, blockGPSModif);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_ADRESSE, this.adresse).
            append(PROPERTY_CODE_POSTAL, this.codePostal).
            append(PROPERTY_VILLE, this.ville).
            append(PROPERTY_CODE_INSEE, this.codeINSEE).
            append(PROPERTY_BLOCK_GPSMODIF, this.blockGPSModif).
         toString();
        return result;
    }

} //UsineAbstract
