package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraDAOHelper.SandraEntityEnum;
import com.cybelia.sandra.entities.trace.SuiviTour;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class TourDAOAbstract<E extends Tour> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Tour.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.Tour;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Etape> list = getContext()
                                                    .getDAO(Etape.class)
                                                    .findAllByProperties(Etape.PROPERTY_TOUR, entity);
                                            for (Etape item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getTour())) {
                                                    item.setTour(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByDateLivraison(Date v) throws TopiaException {
        E result = findByProperty(Tour.PROPERTY_DATE_LIVRAISON, v);
        return result;
    }

    public List<E> findAllByDateLivraison(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Tour.PROPERTY_DATE_LIVRAISON, v);
        return result;
    }

    public E findByNumero(int v) throws TopiaException {
        E result = findByProperty(Tour.PROPERTY_NUMERO, v);
        return result;
    }

    public List<E> findAllByNumero(int v) throws TopiaException {
        List<E> result = findAllByProperty(Tour.PROPERTY_NUMERO, v);
        return result;
    }

    public E findByCommentaire(String v) throws TopiaException {
        E result = findByProperty(Tour.PROPERTY_COMMENTAIRE, v);
        return result;
    }

    public List<E> findAllByCommentaire(String v) throws TopiaException {
        List<E> result = findAllByProperty(Tour.PROPERTY_COMMENTAIRE, v);
        return result;
    }

    public E findByDateChargement(Date v) throws TopiaException {
        E result = findByProperty(Tour.PROPERTY_DATE_CHARGEMENT, v);
        return result;
    }

    public List<E> findAllByDateChargement(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Tour.PROPERTY_DATE_CHARGEMENT, v);
        return result;
    }

    public E findContainsEtapes(Etape v) throws TopiaException {
        E result = findContains(Tour.PROPERTY_ETAPES, v);
        return result;
    }

    public List<E> findAllContainsEtapes(Etape v) throws TopiaException {
        List<E> result = findAllContains(Tour.PROPERTY_ETAPES, v);
        return result;
    }

    public E findByCamion(Camion v) throws TopiaException {
        E result = findByProperty(Tour.PROPERTY_CAMION, v);
        return result;
    }

    public List<E> findAllByCamion(Camion v) throws TopiaException {
        List<E> result = findAllByProperty(Tour.PROPERTY_CAMION, v);
        return result;
    }

    public E findByDefautChauffeur(Chauffeur v) throws TopiaException {
        E result = findByProperty(Tour.PROPERTY_DEFAUT_CHAUFFEUR, v);
        return result;
    }

    public List<E> findAllByDefautChauffeur(Chauffeur v) throws TopiaException {
        List<E> result = findAllByProperty(Tour.PROPERTY_DEFAUT_CHAUFFEUR, v);
        return result;
    }

    public E findBySuiviTour(SuiviTour v) throws TopiaException {
        E result = findByProperty(Tour.PROPERTY_SUIVI_TOUR, v);
        return result;
    }

    public List<E> findAllBySuiviTour(SuiviTour v) throws TopiaException {
        List<E> result = findAllByProperty(Tour.PROPERTY_SUIVI_TOUR, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Etape.class) {
            EtapeDAO dao = (EtapeDAO)
                getContext().getDAO(Etape.class);
            tmp = dao.findAllByTour(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Etape.class, entity);
        if (!list.isEmpty()) {
            result.put(Etape.class, list);
        }

        return result;
    }

} //TourDAOAbstract<E extends Tour>
