package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraDAOHelper.SandraEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class NoteDAOAbstract<E extends Note> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Note.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.Note;
    }

    public E findByNom(String v) throws TopiaException {
        E result = findByProperty(Note.PROPERTY_NOM, v);
        return result;
    }

    public List<E> findAllByNom(String v) throws TopiaException {
        List<E> result = findAllByProperty(Note.PROPERTY_NOM, v);
        return result;
    }

    public E findByDescription(String v) throws TopiaException {
        E result = findByProperty(Note.PROPERTY_DESCRIPTION, v);
        return result;
    }

    public List<E> findAllByDescription(String v) throws TopiaException {
        List<E> result = findAllByProperty(Note.PROPERTY_DESCRIPTION, v);
        return result;
    }

    public E findByContentType(String v) throws TopiaException {
        E result = findByProperty(Note.PROPERTY_CONTENT_TYPE, v);
        return result;
    }

    public List<E> findAllByContentType(String v) throws TopiaException {
        List<E> result = findAllByProperty(Note.PROPERTY_CONTENT_TYPE, v);
        return result;
    }

    public E findByEleveur(Eleveur v) throws TopiaException {
        E result = findByProperty(Note.PROPERTY_ELEVEUR, v);
        return result;
    }

    public List<E> findAllByEleveur(Eleveur v) throws TopiaException {
        List<E> result = findAllByProperty(Note.PROPERTY_ELEVEUR, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Eleveur.class) {
            EleveurDAO dao = (EleveurDAO)
                getContext().getDAO(Eleveur.class);
            tmp = dao.findAllContainsNotes(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Eleveur.class, entity);
        if (!list.isEmpty()) {
            result.put(Eleveur.class, list);
        }

        return result;
    }

} //NoteDAOAbstract<E extends Note>
