package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraDAOHelper.SandraEntityEnum;
import com.cybelia.sandra.entities.trace.SuiviLigneProduit;
import com.cybelia.sandra.entities.trace.SuiviLigneProduitDAO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class LigneProduitDAOAbstract<E extends LigneProduit> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)LigneProduit.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.LigneProduit;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<InfoChargement> list = getContext()
                                                    .getDAO(InfoChargement.class)
                                                    .findAllByProperties(InfoChargement.PROPERTY_LIGNE_PRODUIT, entity);
                                            for (InfoChargement item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getLigneProduit())) {
                                                    item.setLigneProduit(null);
                                                }
                        
                    }
                }

                                        {
                                        List<SuiviLigneProduit> list = getContext()
                                                    .getDAO(SuiviLigneProduit.class)
                                                    .findAllByProperties(SuiviLigneProduit.PROPERTY_LIGNE_PRODUIT, entity);
                                            for (SuiviLigneProduit item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getLigneProduit())) {
                                                    item.setLigneProduit(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByCode(String v) throws TopiaException {
        E result = findByProperty(LigneProduit.PROPERTY_CODE, v);
        return result;
    }

    public List<E> findAllByCode(String v) throws TopiaException {
        List<E> result = findAllByProperty(LigneProduit.PROPERTY_CODE, v);
        return result;
    }

    public E findByLibelle(String v) throws TopiaException {
        E result = findByProperty(LigneProduit.PROPERTY_LIBELLE, v);
        return result;
    }

    public List<E> findAllByLibelle(String v) throws TopiaException {
        List<E> result = findAllByProperty(LigneProduit.PROPERTY_LIBELLE, v);
        return result;
    }

    public E findByPresentation(String v) throws TopiaException {
        E result = findByProperty(LigneProduit.PROPERTY_PRESENTATION, v);
        return result;
    }

    public List<E> findAllByPresentation(String v) throws TopiaException {
        List<E> result = findAllByProperty(LigneProduit.PROPERTY_PRESENTATION, v);
        return result;
    }

    public E findByConditionnement(String v) throws TopiaException {
        E result = findByProperty(LigneProduit.PROPERTY_CONDITIONNEMENT, v);
        return result;
    }

    public List<E> findAllByConditionnement(String v) throws TopiaException {
        List<E> result = findAllByProperty(LigneProduit.PROPERTY_CONDITIONNEMENT, v);
        return result;
    }

    public E findByCapaciteUnitaire(String v) throws TopiaException {
        E result = findByProperty(LigneProduit.PROPERTY_CAPACITE_UNITAIRE, v);
        return result;
    }

    public List<E> findAllByCapaciteUnitaire(String v) throws TopiaException {
        List<E> result = findAllByProperty(LigneProduit.PROPERTY_CAPACITE_UNITAIRE, v);
        return result;
    }

    public E findByQuantiteCommandee(int v) throws TopiaException {
        E result = findByProperty(LigneProduit.PROPERTY_QUANTITE_COMMANDEE, v);
        return result;
    }

    public List<E> findAllByQuantiteCommandee(int v) throws TopiaException {
        List<E> result = findAllByProperty(LigneProduit.PROPERTY_QUANTITE_COMMANDEE, v);
        return result;
    }

    public E findByQuantiteACharger(int v) throws TopiaException {
        E result = findByProperty(LigneProduit.PROPERTY_QUANTITE_ACHARGER, v);
        return result;
    }

    public List<E> findAllByQuantiteACharger(int v) throws TopiaException {
        List<E> result = findAllByProperty(LigneProduit.PROPERTY_QUANTITE_ACHARGER, v);
        return result;
    }

    public E findByMedicament(boolean v) throws TopiaException {
        E result = findByProperty(LigneProduit.PROPERTY_MEDICAMENT, v);
        return result;
    }

    public List<E> findAllByMedicament(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(LigneProduit.PROPERTY_MEDICAMENT, v);
        return result;
    }

    public E findByOrdre(int v) throws TopiaException {
        E result = findByProperty(LigneProduit.PROPERTY_ORDRE, v);
        return result;
    }

    public List<E> findAllByOrdre(int v) throws TopiaException {
        List<E> result = findAllByProperty(LigneProduit.PROPERTY_ORDRE, v);
        return result;
    }

    public E findByCommentaire(String v) throws TopiaException {
        E result = findByProperty(LigneProduit.PROPERTY_COMMENTAIRE, v);
        return result;
    }

    public List<E> findAllByCommentaire(String v) throws TopiaException {
        List<E> result = findAllByProperty(LigneProduit.PROPERTY_COMMENTAIRE, v);
        return result;
    }

    public E findByAcces(String v) throws TopiaException {
        E result = findByProperty(LigneProduit.PROPERTY_ACCES, v);
        return result;
    }

    public List<E> findAllByAcces(String v) throws TopiaException {
        List<E> result = findAllByProperty(LigneProduit.PROPERTY_ACCES, v);
        return result;
    }

    public E findByEquipement(String v) throws TopiaException {
        E result = findByProperty(LigneProduit.PROPERTY_EQUIPEMENT, v);
        return result;
    }

    public List<E> findAllByEquipement(String v) throws TopiaException {
        List<E> result = findAllByProperty(LigneProduit.PROPERTY_EQUIPEMENT, v);
        return result;
    }

    public E findByDisponible(boolean v) throws TopiaException {
        E result = findByProperty(LigneProduit.PROPERTY_DISPONIBLE, v);
        return result;
    }

    public List<E> findAllByDisponible(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(LigneProduit.PROPERTY_DISPONIBLE, v);
        return result;
    }

    public E findByEtape(Etape v) throws TopiaException {
        E result = findByProperty(LigneProduit.PROPERTY_ETAPE, v);
        return result;
    }

    public List<E> findAllByEtape(Etape v) throws TopiaException {
        List<E> result = findAllByProperty(LigneProduit.PROPERTY_ETAPE, v);
        return result;
    }

    public E findByCommande(Commande v) throws TopiaException {
        E result = findByProperty(LigneProduit.PROPERTY_COMMANDE, v);
        return result;
    }

    public List<E> findAllByCommande(Commande v) throws TopiaException {
        List<E> result = findAllByProperty(LigneProduit.PROPERTY_COMMANDE, v);
        return result;
    }

    public E findByUsine(Usine v) throws TopiaException {
        E result = findByProperty(LigneProduit.PROPERTY_USINE, v);
        return result;
    }

    public List<E> findAllByUsine(Usine v) throws TopiaException {
        List<E> result = findAllByProperty(LigneProduit.PROPERTY_USINE, v);
        return result;
    }

    public E findByInfoChargement(InfoChargement v) throws TopiaException {
        E result = findByProperty(LigneProduit.PROPERTY_INFO_CHARGEMENT, v);
        return result;
    }

    public List<E> findAllByInfoChargement(InfoChargement v) throws TopiaException {
        List<E> result = findAllByProperty(LigneProduit.PROPERTY_INFO_CHARGEMENT, v);
        return result;
    }

    public E findBySilo(InfoAccess v) throws TopiaException {
        E result = findByProperty(LigneProduit.PROPERTY_SILO, v);
        return result;
    }

    public List<E> findAllBySilo(InfoAccess v) throws TopiaException {
        List<E> result = findAllByProperty(LigneProduit.PROPERTY_SILO, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == InfoChargement.class) {
            InfoChargementDAO dao = (InfoChargementDAO)
                getContext().getDAO(InfoChargement.class);
            tmp = dao.findAllByLigneProduit(entity);
            result.addAll(tmp);
        }

        if (type == Etape.class) {
            EtapeDAO dao = (EtapeDAO)
                getContext().getDAO(Etape.class);
            tmp = dao.findAllContainsProduits(entity);
            result.addAll(tmp);
        }

        if (type == SuiviLigneProduit.class) {
            SuiviLigneProduitDAO dao = (SuiviLigneProduitDAO)
                getContext().getDAO(SuiviLigneProduit.class);
            tmp = dao.findAllByLigneProduit(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(3);

        List<? extends TopiaEntity> list;

        list = findUsages(InfoChargement.class, entity);
        if (!list.isEmpty()) {
            result.put(InfoChargement.class, list);
        }

        list = findUsages(Etape.class, entity);
        if (!list.isEmpty()) {
            result.put(Etape.class, list);
        }

        list = findUsages(SuiviLigneProduit.class, entity);
        if (!list.isEmpty()) {
            result.put(SuiviLigneProduit.class, list);
        }

        return result;
    }

} //LigneProduitDAOAbstract<E extends LigneProduit>
