package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraDAOHelper.SandraEntityEnum;
import com.cybelia.sandra.entities.sig.PointGPS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class LieuDAOAbstract<E extends Lieu> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Lieu.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.Lieu;
    }

    public E findByCode(String v) throws TopiaException {
        E result = findByProperty(Lieu.PROPERTY_CODE, v);
        return result;
    }

    public List<E> findAllByCode(String v) throws TopiaException {
        List<E> result = findAllByProperty(Lieu.PROPERTY_CODE, v);
        return result;
    }

    public E findByTomtomGPS(PointGPS v) throws TopiaException {
        E result = findByProperty(Lieu.PROPERTY_TOMTOM_GPS, v);
        return result;
    }

    public List<E> findAllByTomtomGPS(PointGPS v) throws TopiaException {
        List<E> result = findAllByProperty(Lieu.PROPERTY_TOMTOM_GPS, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //LieuDAOAbstract<E extends Lieu>
