package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraDAOHelper.SandraEntityEnum;
import com.cybelia.sandra.entities.sig.PointGPS;
import com.cybelia.sandra.entities.sig.TraceGPS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.taas.entities.TaasUser;

public abstract class InfoAccessDAOAbstract<E extends InfoAccess> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)InfoAccess.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.InfoAccess;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Eleveur> list = getContext()
                                                    .getDAO(Eleveur.class)
                                                    .findAllByProperties(Eleveur.PROPERTY_ACCES_ELEVEUR, entity);
                                            for (Eleveur item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getAccesEleveur())) {
                                                    item.setAccesEleveur(null);
                                                }
                        
                    }
                }

                                        {
                                        List<ActionSecurite> list = getContext()
                                                    .getDAO(ActionSecurite.class)
                                                    .findAllByProperties(ActionSecurite.PROPERTY_INFO_ACCESS, entity);
                                            for (ActionSecurite item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getInfoAccess())) {
                                                    item.setInfoAccess(null);
                                                }
                        
                    }
                }

                                        {
                                        List<LigneProduit> list = getContext()
                                                    .getDAO(LigneProduit.class)
                                                    .findAllByProperties(LigneProduit.PROPERTY_SILO, entity);
                                            for (LigneProduit item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getSilo())) {
                                                    item.setSilo(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByAccesSilo(String v) throws TopiaException {
        E result = findByProperty(InfoAccess.PROPERTY_ACCES_SILO, v);
        return result;
    }

    public List<E> findAllByAccesSilo(String v) throws TopiaException {
        List<E> result = findAllByProperty(InfoAccess.PROPERTY_ACCES_SILO, v);
        return result;
    }

    public E findByModeChargement(String v) throws TopiaException {
        E result = findByProperty(InfoAccess.PROPERTY_MODE_CHARGEMENT, v);
        return result;
    }

    public List<E> findAllByModeChargement(String v) throws TopiaException {
        List<E> result = findAllByProperty(InfoAccess.PROPERTY_MODE_CHARGEMENT, v);
        return result;
    }

    public E findByNomAcces(String v) throws TopiaException {
        E result = findByProperty(InfoAccess.PROPERTY_NOM_ACCES, v);
        return result;
    }

    public List<E> findAllByNomAcces(String v) throws TopiaException {
        List<E> result = findAllByProperty(InfoAccess.PROPERTY_NOM_ACCES, v);
        return result;
    }

    public E findByType(int v) throws TopiaException {
        E result = findByProperty(InfoAccess.PROPERTY_TYPE, v);
        return result;
    }

    public List<E> findAllByType(int v) throws TopiaException {
        List<E> result = findAllByProperty(InfoAccess.PROPERTY_TYPE, v);
        return result;
    }

    public E findByNiveauSecurite(int v) throws TopiaException {
        E result = findByProperty(InfoAccess.PROPERTY_NIVEAU_SECURITE, v);
        return result;
    }

    public List<E> findAllByNiveauSecurite(int v) throws TopiaException {
        List<E> result = findAllByProperty(InfoAccess.PROPERTY_NIVEAU_SECURITE, v);
        return result;
    }

    public E findByCommentaireSecurite(String v) throws TopiaException {
        E result = findByProperty(InfoAccess.PROPERTY_COMMENTAIRE_SECURITE, v);
        return result;
    }

    public List<E> findAllByCommentaireSecurite(String v) throws TopiaException {
        List<E> result = findAllByProperty(InfoAccess.PROPERTY_COMMENTAIRE_SECURITE, v);
        return result;
    }

    public E findContainsRisques(String v) throws TopiaException {
        E result = findContains(InfoAccess.PROPERTY_RISQUES, v);
        return result;
    }

    public List<E> findAllContainsRisques(String v) throws TopiaException {
        List<E> result = findAllContains(InfoAccess.PROPERTY_RISQUES, v);
        return result;
    }

    public E findByEtat(int v) throws TopiaException {
        E result = findByProperty(InfoAccess.PROPERTY_ETAT, v);
        return result;
    }

    public List<E> findAllByEtat(int v) throws TopiaException {
        List<E> result = findAllByProperty(InfoAccess.PROPERTY_ETAT, v);
        return result;
    }

    public E findByEleveur(Eleveur v) throws TopiaException {
        E result = findByProperty(InfoAccess.PROPERTY_ELEVEUR, v);
        return result;
    }

    public List<E> findAllByEleveur(Eleveur v) throws TopiaException {
        List<E> result = findAllByProperty(InfoAccess.PROPERTY_ELEVEUR, v);
        return result;
    }

    public E findByGps(PointGPS v) throws TopiaException {
        E result = findByProperty(InfoAccess.PROPERTY_GPS, v);
        return result;
    }

    public List<E> findAllByGps(PointGPS v) throws TopiaException {
        List<E> result = findAllByProperty(InfoAccess.PROPERTY_GPS, v);
        return result;
    }

    public E findByTrace(TraceGPS v) throws TopiaException {
        E result = findByProperty(InfoAccess.PROPERTY_TRACE, v);
        return result;
    }

    public List<E> findAllByTrace(TraceGPS v) throws TopiaException {
        List<E> result = findAllByProperty(InfoAccess.PROPERTY_TRACE, v);
        return result;
    }

    public E findContainsUsersVerrouillage(TaasUser v) throws TopiaException {
        E result = findContains(InfoAccess.PROPERTY_USERS_VERROUILLAGE, v);
        return result;
    }

    public List<E> findAllContainsUsersVerrouillage(TaasUser v) throws TopiaException {
        List<E> result = findAllContains(InfoAccess.PROPERTY_USERS_VERROUILLAGE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Eleveur.class) {
            EleveurDAO dao = (EleveurDAO)
                getContext().getDAO(Eleveur.class);
            tmp = dao.findAllByAccesEleveur(entity);
            result.addAll(tmp);
        }

        if (type == Eleveur.class) {
            EleveurDAO dao = (EleveurDAO)
                getContext().getDAO(Eleveur.class);
            tmp = dao.findAllContainsAccesSilos(entity);
            result.addAll(tmp);
        }

        if (type == ActionSecurite.class) {
            ActionSecuriteDAO dao = (ActionSecuriteDAO)
                getContext().getDAO(ActionSecurite.class);
            tmp = dao.findAllByInfoAccess(entity);
            result.addAll(tmp);
        }

        if (type == LigneProduit.class) {
            LigneProduitDAO dao = (LigneProduitDAO)
                getContext().getDAO(LigneProduit.class);
            tmp = dao.findAllBySilo(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(3);

        List<? extends TopiaEntity> list;

        list = findUsages(Eleveur.class, entity);
        if (!list.isEmpty()) {
            result.put(Eleveur.class, list);
        }

        list = findUsages(ActionSecurite.class, entity);
        if (!list.isEmpty()) {
            result.put(ActionSecurite.class, list);
        }

        list = findUsages(LigneProduit.class, entity);
        if (!list.isEmpty()) {
            result.put(LigneProduit.class, list);
        }

        return result;
    }

} //InfoAccessDAOAbstract<E extends InfoAccess>
