package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraDAOHelper.SandraEntityEnum;
import com.cybelia.sandra.entities.trace.SuiviEtape;
import com.cybelia.sandra.entities.trace.SuiviEtapeDAO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class EtapeDAOAbstract<E extends Etape> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Etape.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.Etape;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<LigneProduit> list = getContext()
                                                    .getDAO(LigneProduit.class)
                                                    .findAllByProperties(LigneProduit.PROPERTY_ETAPE, entity);
                                            for (LigneProduit item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getEtape())) {
                                                    item.setEtape(null);
                                                }
                        
                    }
                }

                                        {
                                        List<SuiviEtape> list = getContext()
                                                    .getDAO(SuiviEtape.class)
                                                    .findAllByProperties(SuiviEtape.PROPERTY_ETAPE, entity);
                                            for (SuiviEtape item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getEtape())) {
                                                    item.setEtape(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByOrdre(int v) throws TopiaException {
        E result = findByProperty(Etape.PROPERTY_ORDRE, v);
        return result;
    }

    public List<E> findAllByOrdre(int v) throws TopiaException {
        List<E> result = findAllByProperty(Etape.PROPERTY_ORDRE, v);
        return result;
    }

    public E findByCommentaire(String v) throws TopiaException {
        E result = findByProperty(Etape.PROPERTY_COMMENTAIRE, v);
        return result;
    }

    public List<E> findAllByCommentaire(String v) throws TopiaException {
        List<E> result = findAllByProperty(Etape.PROPERTY_COMMENTAIRE, v);
        return result;
    }

    public E findByEtat(int v) throws TopiaException {
        E result = findByProperty(Etape.PROPERTY_ETAT, v);
        return result;
    }

    public List<E> findAllByEtat(int v) throws TopiaException {
        List<E> result = findAllByProperty(Etape.PROPERTY_ETAT, v);
        return result;
    }

    public E findByTour(Tour v) throws TopiaException {
        E result = findByProperty(Etape.PROPERTY_TOUR, v);
        return result;
    }

    public List<E> findAllByTour(Tour v) throws TopiaException {
        List<E> result = findAllByProperty(Etape.PROPERTY_TOUR, v);
        return result;
    }

    public E findByEleveur(Eleveur v) throws TopiaException {
        E result = findByProperty(Etape.PROPERTY_ELEVEUR, v);
        return result;
    }

    public List<E> findAllByEleveur(Eleveur v) throws TopiaException {
        List<E> result = findAllByProperty(Etape.PROPERTY_ELEVEUR, v);
        return result;
    }

    public E findContainsProduits(LigneProduit v) throws TopiaException {
        E result = findContains(Etape.PROPERTY_PRODUITS, v);
        return result;
    }

    public List<E> findAllContainsProduits(LigneProduit v) throws TopiaException {
        List<E> result = findAllContains(Etape.PROPERTY_PRODUITS, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == SuiviEtape.class) {
            SuiviEtapeDAO dao = (SuiviEtapeDAO)
                getContext().getDAO(SuiviEtape.class);
            tmp = dao.findAllByEtape(entity);
            result.addAll(tmp);
        }

        if (type == Tour.class) {
            TourDAO dao = (TourDAO)
                getContext().getDAO(Tour.class);
            tmp = dao.findAllContainsEtapes(entity);
            result.addAll(tmp);
        }

        if (type == LigneProduit.class) {
            LigneProduitDAO dao = (LigneProduitDAO)
                getContext().getDAO(LigneProduit.class);
            tmp = dao.findAllByEtape(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(3);

        List<? extends TopiaEntity> list;

        list = findUsages(SuiviEtape.class, entity);
        if (!list.isEmpty()) {
            result.put(SuiviEtape.class, list);
        }

        list = findUsages(Tour.class, entity);
        if (!list.isEmpty()) {
            result.put(Tour.class, list);
        }

        list = findUsages(LigneProduit.class, entity);
        if (!list.isEmpty()) {
            result.put(LigneProduit.class, list);
        }

        return result;
    }

} //EtapeDAOAbstract<E extends Etape>
