package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraDAOHelper.SandraEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class EleveursDoublonsDAOAbstract<E extends EleveursDoublons> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)EleveursDoublons.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.EleveursDoublons;
    }

    public E findByCodeSocieteOld(String v) throws TopiaException {
        E result = findByProperty(EleveursDoublons.PROPERTY_CODE_SOCIETE_OLD, v);
        return result;
    }

    public List<E> findAllByCodeSocieteOld(String v) throws TopiaException {
        List<E> result = findAllByProperty(EleveursDoublons.PROPERTY_CODE_SOCIETE_OLD, v);
        return result;
    }

    public E findByCodeEleveurOld(String v) throws TopiaException {
        E result = findByProperty(EleveursDoublons.PROPERTY_CODE_ELEVEUR_OLD, v);
        return result;
    }

    public List<E> findAllByCodeEleveurOld(String v) throws TopiaException {
        List<E> result = findAllByProperty(EleveursDoublons.PROPERTY_CODE_ELEVEUR_OLD, v);
        return result;
    }

    public E findByCodeSocieteNew(String v) throws TopiaException {
        E result = findByProperty(EleveursDoublons.PROPERTY_CODE_SOCIETE_NEW, v);
        return result;
    }

    public List<E> findAllByCodeSocieteNew(String v) throws TopiaException {
        List<E> result = findAllByProperty(EleveursDoublons.PROPERTY_CODE_SOCIETE_NEW, v);
        return result;
    }

    public E findByCodeEleveurNew(String v) throws TopiaException {
        E result = findByProperty(EleveursDoublons.PROPERTY_CODE_ELEVEUR_NEW, v);
        return result;
    }

    public List<E> findAllByCodeEleveurNew(String v) throws TopiaException {
        List<E> result = findAllByProperty(EleveursDoublons.PROPERTY_CODE_ELEVEUR_NEW, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //EleveursDoublonsDAOAbstract<E extends EleveursDoublons>
