package com.cybelia.sandra.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class EleveursDoublonsAbstract extends TopiaEntityAbstract implements EleveursDoublons {

    /**
     * Table servant à IBU pour réferencer les éleveurs en doublons (https://jira.groupe-glon.fr/browse/SDRAMTNC-274)
     * Nom de l'attribut en BD : codeSocieteOld
     */
    protected String codeSocieteOld;

    /**
     * Table servant à IBU pour réferencer les éleveurs en doublons (https://jira.groupe-glon.fr/browse/SDRAMTNC-274)
     * Nom de l'attribut en BD : codeEleveurOld
     */
    protected String codeEleveurOld;

    /**
     * Table servant à IBU pour réferencer les éleveurs en doublons (https://jira.groupe-glon.fr/browse/SDRAMTNC-274)
     * Nom de l'attribut en BD : codeSocieteNew
     */
    protected String codeSocieteNew;

    /**
     * Table servant à IBU pour réferencer les éleveurs en doublons (https://jira.groupe-glon.fr/browse/SDRAMTNC-274)
     * Nom de l'attribut en BD : codeEleveurNew
     */
    protected String codeEleveurNew;

    private static final long serialVersionUID = 7149013816556336433L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_CODE_SOCIETE_OLD, String.class, codeSocieteOld);
        visitor.visit(this, PROPERTY_CODE_ELEVEUR_OLD, String.class, codeEleveurOld);
        visitor.visit(this, PROPERTY_CODE_SOCIETE_NEW, String.class, codeSocieteNew);
        visitor.visit(this, PROPERTY_CODE_ELEVEUR_NEW, String.class, codeEleveurNew);
        visitor.end(this);
    }

    @Override
    public void setCodeSocieteOld(String codeSocieteOld) {
        String oldValue = this.codeSocieteOld;
        fireOnPreWrite(PROPERTY_CODE_SOCIETE_OLD, oldValue, codeSocieteOld);
        this.codeSocieteOld = codeSocieteOld;
        fireOnPostWrite(PROPERTY_CODE_SOCIETE_OLD, oldValue, codeSocieteOld);
    }

    @Override
    public String getCodeSocieteOld() {
        fireOnPreRead(PROPERTY_CODE_SOCIETE_OLD, codeSocieteOld);
        String result = this.codeSocieteOld;
        fireOnPostRead(PROPERTY_CODE_SOCIETE_OLD, codeSocieteOld);
        return result;
    }

    @Override
    public void setCodeEleveurOld(String codeEleveurOld) {
        String oldValue = this.codeEleveurOld;
        fireOnPreWrite(PROPERTY_CODE_ELEVEUR_OLD, oldValue, codeEleveurOld);
        this.codeEleveurOld = codeEleveurOld;
        fireOnPostWrite(PROPERTY_CODE_ELEVEUR_OLD, oldValue, codeEleveurOld);
    }

    @Override
    public String getCodeEleveurOld() {
        fireOnPreRead(PROPERTY_CODE_ELEVEUR_OLD, codeEleveurOld);
        String result = this.codeEleveurOld;
        fireOnPostRead(PROPERTY_CODE_ELEVEUR_OLD, codeEleveurOld);
        return result;
    }

    @Override
    public void setCodeSocieteNew(String codeSocieteNew) {
        String oldValue = this.codeSocieteNew;
        fireOnPreWrite(PROPERTY_CODE_SOCIETE_NEW, oldValue, codeSocieteNew);
        this.codeSocieteNew = codeSocieteNew;
        fireOnPostWrite(PROPERTY_CODE_SOCIETE_NEW, oldValue, codeSocieteNew);
    }

    @Override
    public String getCodeSocieteNew() {
        fireOnPreRead(PROPERTY_CODE_SOCIETE_NEW, codeSocieteNew);
        String result = this.codeSocieteNew;
        fireOnPostRead(PROPERTY_CODE_SOCIETE_NEW, codeSocieteNew);
        return result;
    }

    @Override
    public void setCodeEleveurNew(String codeEleveurNew) {
        String oldValue = this.codeEleveurNew;
        fireOnPreWrite(PROPERTY_CODE_ELEVEUR_NEW, oldValue, codeEleveurNew);
        this.codeEleveurNew = codeEleveurNew;
        fireOnPostWrite(PROPERTY_CODE_ELEVEUR_NEW, oldValue, codeEleveurNew);
    }

    @Override
    public String getCodeEleveurNew() {
        fireOnPreRead(PROPERTY_CODE_ELEVEUR_NEW, codeEleveurNew);
        String result = this.codeEleveurNew;
        fireOnPostRead(PROPERTY_CODE_ELEVEUR_NEW, codeEleveurNew);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_CODE_SOCIETE_OLD, this.codeSocieteOld).
            append(PROPERTY_CODE_ELEVEUR_OLD, this.codeEleveurOld).
            append(PROPERTY_CODE_SOCIETE_NEW, this.codeSocieteNew).
            append(PROPERTY_CODE_ELEVEUR_NEW, this.codeEleveurNew).
         toString();
        return result;
    }

} //EleveursDoublonsAbstract
