package com.cybelia.sandra.entities;

import java.util.ArrayList;
import java.util.Collection;

public class EleveurImpl extends EleveurAbstract {
    private static final long serialVersionUID = -7858496925331782174L;

    public String getNom() {
        return getRaisonSociale();
    }

    public String getCodeRegion() {
        return getCodePostal().substring(0, 2);
    }

    @Override
    public Collection<InfoAccess> getActiveAccesSilo() {

        // Remove deleted
        Collection<InfoAccess> accesSilosFromBeanLessDeleted = new ArrayList<InfoAccess>();
        Collection<InfoAccess> accesSilosFromBean = getAccesSilos();
        if (accesSilosFromBean != null) {
            for (InfoAccess silo : accesSilosFromBean) {
                if (silo.getEtat() != InfoAccessEtat.INFOACCESS_SUPPR) {
                    accesSilosFromBeanLessDeleted.add(silo);
                }
            }
        }
        return accesSilosFromBeanLessDeleted;
    }
} //EleveurImpl
