package com.cybelia.sandra.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class EleveurAbstract extends LieuImpl implements Eleveur {

    /**
     * Nom de l'attribut en BD : raisonSociale
     */
    protected String raisonSociale;

    /**
     * Nom de l'attribut en BD : telephone
     */
    protected String telephone;

    /**
     * Nom de l'attribut en BD : mobile
     */
    protected String mobile;

    /**
     * Nom de l'attribut en BD : adresse
     */
    protected String adresse;

    /**
     * Nom de l'attribut en BD : ville
     */
    protected String ville;

    /**
     * Nom de l'attribut en BD : codePostal
     */
    protected String codePostal;

    /**
     * Nom de l'attribut en BD : niveauSecurite
     */
    protected int niveauSecurite;

    /**
     * Nom de l'attribut en BD : email
     */
    protected String email;

    /**
     * Nom de l'attribut en BD : codeINSEE
     */
    protected String codeINSEE;

    /**
     * Nom de l'attribut en BD : commentaire
     */
    protected String commentaire;

    /**
     * Nom de l'attribut en BD : contrainteHoraire
     */
    protected String contrainteHoraire;

    /**
     * Nom de l'attribut en BD : nbTomTomGPSModif
     */
    protected int nbTomTomGPSModif;

    /**
     * Nom de l'attribut en BD : accesEleveur
     */
    protected InfoAccess accesEleveur;

    /**
     * Nom de l'attribut en BD : accesSilos
     */
    protected Collection<InfoAccess> accesSilos;

    /**
     * Nom de l'attribut en BD : societe
     */
    protected Societe societe;

    /**
     * Nom de l'attribut en BD : notes
     */
    protected Collection<Note> notes;

    /**
     * Nom de l'attribut en BD : actionSecurite
     */
    protected Collection<ActionSecurite> actionSecurite;

    private static final long serialVersionUID = 3978197125806776625L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_RAISON_SOCIALE, String.class, raisonSociale);
        visitor.visit(this, PROPERTY_TELEPHONE, String.class, telephone);
        visitor.visit(this, PROPERTY_MOBILE, String.class, mobile);
        visitor.visit(this, PROPERTY_ADRESSE, String.class, adresse);
        visitor.visit(this, PROPERTY_VILLE, String.class, ville);
        visitor.visit(this, PROPERTY_CODE_POSTAL, String.class, codePostal);
        visitor.visit(this, PROPERTY_NIVEAU_SECURITE, int.class, niveauSecurite);
        visitor.visit(this, PROPERTY_EMAIL, String.class, email);
        visitor.visit(this, PROPERTY_CODE_INSEE, String.class, codeINSEE);
        visitor.visit(this, PROPERTY_COMMENTAIRE, String.class, commentaire);
        visitor.visit(this, PROPERTY_CONTRAINTE_HORAIRE, String.class, contrainteHoraire);
        visitor.visit(this, PROPERTY_NB_TOM_TOM_GPSMODIF, int.class, nbTomTomGPSModif);
        visitor.visit(this, PROPERTY_ACCES_ELEVEUR, InfoAccess.class, accesEleveur);
        visitor.visit(this, PROPERTY_ACCES_SILOS, Collection.class, InfoAccess.class, accesSilos);
        visitor.visit(this, PROPERTY_SOCIETE, Societe.class, societe);
        visitor.visit(this, PROPERTY_NOTES, Collection.class, Note.class, notes);
        visitor.visit(this, PROPERTY_ACTION_SECURITE, Collection.class, ActionSecurite.class, actionSecurite);
        visitor.end(this);
    }

    @Override
    public void setRaisonSociale(String raisonSociale) {
        String oldValue = this.raisonSociale;
        fireOnPreWrite(PROPERTY_RAISON_SOCIALE, oldValue, raisonSociale);
        this.raisonSociale = raisonSociale;
        fireOnPostWrite(PROPERTY_RAISON_SOCIALE, oldValue, raisonSociale);
    }

    @Override
    public String getRaisonSociale() {
        fireOnPreRead(PROPERTY_RAISON_SOCIALE, raisonSociale);
        String result = this.raisonSociale;
        fireOnPostRead(PROPERTY_RAISON_SOCIALE, raisonSociale);
        return result;
    }

    @Override
    public void setTelephone(String telephone) {
        String oldValue = this.telephone;
        fireOnPreWrite(PROPERTY_TELEPHONE, oldValue, telephone);
        this.telephone = telephone;
        fireOnPostWrite(PROPERTY_TELEPHONE, oldValue, telephone);
    }

    @Override
    public String getTelephone() {
        fireOnPreRead(PROPERTY_TELEPHONE, telephone);
        String result = this.telephone;
        fireOnPostRead(PROPERTY_TELEPHONE, telephone);
        return result;
    }

    @Override
    public void setMobile(String mobile) {
        String oldValue = this.mobile;
        fireOnPreWrite(PROPERTY_MOBILE, oldValue, mobile);
        this.mobile = mobile;
        fireOnPostWrite(PROPERTY_MOBILE, oldValue, mobile);
    }

    @Override
    public String getMobile() {
        fireOnPreRead(PROPERTY_MOBILE, mobile);
        String result = this.mobile;
        fireOnPostRead(PROPERTY_MOBILE, mobile);
        return result;
    }

    @Override
    public void setAdresse(String adresse) {
        String oldValue = this.adresse;
        fireOnPreWrite(PROPERTY_ADRESSE, oldValue, adresse);
        this.adresse = adresse;
        fireOnPostWrite(PROPERTY_ADRESSE, oldValue, adresse);
    }

    @Override
    public String getAdresse() {
        fireOnPreRead(PROPERTY_ADRESSE, adresse);
        String result = this.adresse;
        fireOnPostRead(PROPERTY_ADRESSE, adresse);
        return result;
    }

    @Override
    public void setVille(String ville) {
        String oldValue = this.ville;
        fireOnPreWrite(PROPERTY_VILLE, oldValue, ville);
        this.ville = ville;
        fireOnPostWrite(PROPERTY_VILLE, oldValue, ville);
    }

    @Override
    public String getVille() {
        fireOnPreRead(PROPERTY_VILLE, ville);
        String result = this.ville;
        fireOnPostRead(PROPERTY_VILLE, ville);
        return result;
    }

    @Override
    public void setCodePostal(String codePostal) {
        String oldValue = this.codePostal;
        fireOnPreWrite(PROPERTY_CODE_POSTAL, oldValue, codePostal);
        this.codePostal = codePostal;
        fireOnPostWrite(PROPERTY_CODE_POSTAL, oldValue, codePostal);
    }

    @Override
    public String getCodePostal() {
        fireOnPreRead(PROPERTY_CODE_POSTAL, codePostal);
        String result = this.codePostal;
        fireOnPostRead(PROPERTY_CODE_POSTAL, codePostal);
        return result;
    }

    @Override
    public void setNiveauSecurite(int niveauSecurite) {
        int oldValue = this.niveauSecurite;
        fireOnPreWrite(PROPERTY_NIVEAU_SECURITE, oldValue, niveauSecurite);
        this.niveauSecurite = niveauSecurite;
        fireOnPostWrite(PROPERTY_NIVEAU_SECURITE, oldValue, niveauSecurite);
    }

    @Override
    public int getNiveauSecurite() {
        fireOnPreRead(PROPERTY_NIVEAU_SECURITE, niveauSecurite);
        int result = this.niveauSecurite;
        fireOnPostRead(PROPERTY_NIVEAU_SECURITE, niveauSecurite);
        return result;
    }

    @Override
    public void setEmail(String email) {
        String oldValue = this.email;
        fireOnPreWrite(PROPERTY_EMAIL, oldValue, email);
        this.email = email;
        fireOnPostWrite(PROPERTY_EMAIL, oldValue, email);
    }

    @Override
    public String getEmail() {
        fireOnPreRead(PROPERTY_EMAIL, email);
        String result = this.email;
        fireOnPostRead(PROPERTY_EMAIL, email);
        return result;
    }

    @Override
    public void setCodeINSEE(String codeINSEE) {
        String oldValue = this.codeINSEE;
        fireOnPreWrite(PROPERTY_CODE_INSEE, oldValue, codeINSEE);
        this.codeINSEE = codeINSEE;
        fireOnPostWrite(PROPERTY_CODE_INSEE, oldValue, codeINSEE);
    }

    @Override
    public String getCodeINSEE() {
        fireOnPreRead(PROPERTY_CODE_INSEE, codeINSEE);
        String result = this.codeINSEE;
        fireOnPostRead(PROPERTY_CODE_INSEE, codeINSEE);
        return result;
    }

    @Override
    public void setCommentaire(String commentaire) {
        String oldValue = this.commentaire;
        fireOnPreWrite(PROPERTY_COMMENTAIRE, oldValue, commentaire);
        this.commentaire = commentaire;
        fireOnPostWrite(PROPERTY_COMMENTAIRE, oldValue, commentaire);
    }

    @Override
    public String getCommentaire() {
        fireOnPreRead(PROPERTY_COMMENTAIRE, commentaire);
        String result = this.commentaire;
        fireOnPostRead(PROPERTY_COMMENTAIRE, commentaire);
        return result;
    }

    @Override
    public void setContrainteHoraire(String contrainteHoraire) {
        String oldValue = this.contrainteHoraire;
        fireOnPreWrite(PROPERTY_CONTRAINTE_HORAIRE, oldValue, contrainteHoraire);
        this.contrainteHoraire = contrainteHoraire;
        fireOnPostWrite(PROPERTY_CONTRAINTE_HORAIRE, oldValue, contrainteHoraire);
    }

    @Override
    public String getContrainteHoraire() {
        fireOnPreRead(PROPERTY_CONTRAINTE_HORAIRE, contrainteHoraire);
        String result = this.contrainteHoraire;
        fireOnPostRead(PROPERTY_CONTRAINTE_HORAIRE, contrainteHoraire);
        return result;
    }

    @Override
    public void setNbTomTomGPSModif(int nbTomTomGPSModif) {
        int oldValue = this.nbTomTomGPSModif;
        fireOnPreWrite(PROPERTY_NB_TOM_TOM_GPSMODIF, oldValue, nbTomTomGPSModif);
        this.nbTomTomGPSModif = nbTomTomGPSModif;
        fireOnPostWrite(PROPERTY_NB_TOM_TOM_GPSMODIF, oldValue, nbTomTomGPSModif);
    }

    @Override
    public int getNbTomTomGPSModif() {
        fireOnPreRead(PROPERTY_NB_TOM_TOM_GPSMODIF, nbTomTomGPSModif);
        int result = this.nbTomTomGPSModif;
        fireOnPostRead(PROPERTY_NB_TOM_TOM_GPSMODIF, nbTomTomGPSModif);
        return result;
    }

    @Override
    public void setAccesEleveur(InfoAccess accesEleveur) {
        InfoAccess oldValue = this.accesEleveur;
        fireOnPreWrite(PROPERTY_ACCES_ELEVEUR, oldValue, accesEleveur);
        this.accesEleveur = accesEleveur;
        fireOnPostWrite(PROPERTY_ACCES_ELEVEUR, oldValue, accesEleveur);
    }

    @Override
    public InfoAccess getAccesEleveur() {
        fireOnPreRead(PROPERTY_ACCES_ELEVEUR, accesEleveur);
        InfoAccess result = this.accesEleveur;
        fireOnPostRead(PROPERTY_ACCES_ELEVEUR, accesEleveur);
        return result;
    }

    @Override
    public void addAccesSilos(InfoAccess accesSilos) {
        fireOnPreWrite(PROPERTY_ACCES_SILOS, null, accesSilos);
        if (this.accesSilos == null) {
            this.accesSilos = new ArrayList<InfoAccess>();
        }

        accesSilos.setEleveur(this);

        this.accesSilos.add(accesSilos);
        fireOnPostWrite(PROPERTY_ACCES_SILOS, this.accesSilos.size(), null, accesSilos);
    }

    @Override
    public void addAllAccesSilos(Collection<InfoAccess> accesSilos) {
        if (accesSilos == null) {
            return;
        }
        for (InfoAccess item : accesSilos) {
            addAccesSilos(item);
        }
    }

    @Override
    public void setAccesSilos(Collection<InfoAccess> accesSilos) {
        // Copy elements to keep data for fire with new reference
        Collection<InfoAccess> oldValue = this.accesSilos != null ? new ArrayList<InfoAccess>(this.accesSilos) : null;
        fireOnPreWrite(PROPERTY_ACCES_SILOS, oldValue, accesSilos);
        this.accesSilos = accesSilos;
        fireOnPostWrite(PROPERTY_ACCES_SILOS, oldValue, accesSilos);
    }

    @Override
    public void removeAccesSilos(InfoAccess accesSilos) {
        fireOnPreWrite(PROPERTY_ACCES_SILOS, accesSilos, null);
        if (this.accesSilos == null || !this.accesSilos.remove(accesSilos)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        accesSilos.setEleveur(null);

        fireOnPostWrite(PROPERTY_ACCES_SILOS, this.accesSilos.size() + 1, accesSilos, null);
    }

    @Override
    public void clearAccesSilos() {
        if (this.accesSilos == null) {
            return;
        }
        for (InfoAccess item : this.accesSilos) {
            item.setEleveur(null);
        }
        Collection<InfoAccess> oldValue = new ArrayList<InfoAccess>(this.accesSilos);
        fireOnPreWrite(PROPERTY_ACCES_SILOS, oldValue, this.accesSilos);
        this.accesSilos.clear();
        fireOnPostWrite(PROPERTY_ACCES_SILOS, oldValue, this.accesSilos);
    }

    @Override
    public Collection<InfoAccess> getAccesSilos() {
        return accesSilos;
    }

    @Override
    public InfoAccess getAccesSilosByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(accesSilos, topiaId);
    }

    @Override
    public int sizeAccesSilos() {
        if (accesSilos == null) {
            return 0;
        }
        return accesSilos.size();
    }

    @Override
    public boolean isAccesSilosEmpty() {
        int size = sizeAccesSilos();
        return size == 0;
    }

    @Override
    public void setSociete(Societe societe) {
        Societe oldValue = this.societe;
        fireOnPreWrite(PROPERTY_SOCIETE, oldValue, societe);
        this.societe = societe;
        fireOnPostWrite(PROPERTY_SOCIETE, oldValue, societe);
    }

    @Override
    public Societe getSociete() {
        fireOnPreRead(PROPERTY_SOCIETE, societe);
        Societe result = this.societe;
        fireOnPostRead(PROPERTY_SOCIETE, societe);
        return result;
    }

    @Override
    public void addNotes(Note notes) {
        fireOnPreWrite(PROPERTY_NOTES, null, notes);
        if (this.notes == null) {
            this.notes = new ArrayList<Note>();
        }

        notes.setEleveur(this);

        this.notes.add(notes);
        fireOnPostWrite(PROPERTY_NOTES, this.notes.size(), null, notes);
    }

    @Override
    public void addAllNotes(Collection<Note> notes) {
        if (notes == null) {
            return;
        }
        for (Note item : notes) {
            addNotes(item);
        }
    }

    @Override
    public void setNotes(Collection<Note> notes) {
        // Copy elements to keep data for fire with new reference
        Collection<Note> oldValue = this.notes != null ? new ArrayList<Note>(this.notes) : null;
        fireOnPreWrite(PROPERTY_NOTES, oldValue, notes);
        this.notes = notes;
        fireOnPostWrite(PROPERTY_NOTES, oldValue, notes);
    }

    @Override
    public void removeNotes(Note notes) {
        fireOnPreWrite(PROPERTY_NOTES, notes, null);
        if (this.notes == null || !this.notes.remove(notes)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        notes.setEleveur(null);

        fireOnPostWrite(PROPERTY_NOTES, this.notes.size() + 1, notes, null);
    }

    @Override
    public void clearNotes() {
        if (this.notes == null) {
            return;
        }
        for (Note item : this.notes) {
            item.setEleveur(null);
        }
        Collection<Note> oldValue = new ArrayList<Note>(this.notes);
        fireOnPreWrite(PROPERTY_NOTES, oldValue, this.notes);
        this.notes.clear();
        fireOnPostWrite(PROPERTY_NOTES, oldValue, this.notes);
    }

    @Override
    public Collection<Note> getNotes() {
        return notes;
    }

    @Override
    public Note getNotesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(notes, topiaId);
    }

    @Override
    public int sizeNotes() {
        if (notes == null) {
            return 0;
        }
        return notes.size();
    }

    @Override
    public boolean isNotesEmpty() {
        int size = sizeNotes();
        return size == 0;
    }

    @Override
    public void addActionSecurite(ActionSecurite actionSecurite) {
        fireOnPreWrite(PROPERTY_ACTION_SECURITE, null, actionSecurite);
        if (this.actionSecurite == null) {
            this.actionSecurite = new ArrayList<ActionSecurite>();
        }

        actionSecurite.setEleveur(this);

        this.actionSecurite.add(actionSecurite);
        fireOnPostWrite(PROPERTY_ACTION_SECURITE, this.actionSecurite.size(), null, actionSecurite);
    }

    @Override
    public void addAllActionSecurite(Collection<ActionSecurite> actionSecurite) {
        if (actionSecurite == null) {
            return;
        }
        for (ActionSecurite item : actionSecurite) {
            addActionSecurite(item);
        }
    }

    @Override
    public void setActionSecurite(Collection<ActionSecurite> actionSecurite) {
        // Copy elements to keep data for fire with new reference
        Collection<ActionSecurite> oldValue = this.actionSecurite != null ? new ArrayList<ActionSecurite>(this.actionSecurite) : null;
        fireOnPreWrite(PROPERTY_ACTION_SECURITE, oldValue, actionSecurite);
        this.actionSecurite = actionSecurite;
        fireOnPostWrite(PROPERTY_ACTION_SECURITE, oldValue, actionSecurite);
    }

    @Override
    public void removeActionSecurite(ActionSecurite actionSecurite) {
        fireOnPreWrite(PROPERTY_ACTION_SECURITE, actionSecurite, null);
        if (this.actionSecurite == null || !this.actionSecurite.remove(actionSecurite)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        actionSecurite.setEleveur(null);

        fireOnPostWrite(PROPERTY_ACTION_SECURITE, this.actionSecurite.size() + 1, actionSecurite, null);
    }

    @Override
    public void clearActionSecurite() {
        if (this.actionSecurite == null) {
            return;
        }
        for (ActionSecurite item : this.actionSecurite) {
            item.setEleveur(null);
        }
        Collection<ActionSecurite> oldValue = new ArrayList<ActionSecurite>(this.actionSecurite);
        fireOnPreWrite(PROPERTY_ACTION_SECURITE, oldValue, this.actionSecurite);
        this.actionSecurite.clear();
        fireOnPostWrite(PROPERTY_ACTION_SECURITE, oldValue, this.actionSecurite);
    }

    @Override
    public Collection<ActionSecurite> getActionSecurite() {
        return actionSecurite;
    }

    @Override
    public ActionSecurite getActionSecuriteByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(actionSecurite, topiaId);
    }

    @Override
    public int sizeActionSecurite() {
        if (actionSecurite == null) {
            return 0;
        }
        return actionSecurite.size();
    }

    @Override
    public boolean isActionSecuriteEmpty() {
        int size = sizeActionSecurite();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_RAISON_SOCIALE, this.raisonSociale).
            append(PROPERTY_TELEPHONE, this.telephone).
            append(PROPERTY_MOBILE, this.mobile).
            append(PROPERTY_ADRESSE, this.adresse).
            append(PROPERTY_VILLE, this.ville).
            append(PROPERTY_CODE_POSTAL, this.codePostal).
            append(PROPERTY_NIVEAU_SECURITE, this.niveauSecurite).
            append(PROPERTY_EMAIL, this.email).
            append(PROPERTY_CODE_INSEE, this.codeINSEE).
            append(PROPERTY_COMMENTAIRE, this.commentaire).
            append(PROPERTY_CONTRAINTE_HORAIRE, this.contrainteHoraire).
            append(PROPERTY_NB_TOM_TOM_GPSMODIF, this.nbTomTomGPSModif).
            append(PROPERTY_SOCIETE, this.societe).
         toString();
        return result;
    }

} //EleveurAbstract
