package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraDAOHelper.SandraEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class CommandeDAOAbstract<E extends Commande> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Commande.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.Commande;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<LigneProduit> list = getContext()
                                                    .getDAO(LigneProduit.class)
                                                    .findAllByProperties(LigneProduit.PROPERTY_COMMANDE, entity);
                                            for (LigneProduit item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getCommande())) {
                                                    item.setCommande(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByNumero(String v) throws TopiaException {
        E result = findByProperty(Commande.PROPERTY_NUMERO, v);
        return result;
    }

    public List<E> findAllByNumero(String v) throws TopiaException {
        List<E> result = findAllByProperty(Commande.PROPERTY_NUMERO, v);
        return result;
    }

    public E findByCommentaire(String v) throws TopiaException {
        E result = findByProperty(Commande.PROPERTY_COMMENTAIRE, v);
        return result;
    }

    public List<E> findAllByCommentaire(String v) throws TopiaException {
        List<E> result = findAllByProperty(Commande.PROPERTY_COMMENTAIRE, v);
        return result;
    }

    public E findByContrainteHoraire(String v) throws TopiaException {
        E result = findByProperty(Commande.PROPERTY_CONTRAINTE_HORAIRE, v);
        return result;
    }

    public List<E> findAllByContrainteHoraire(String v) throws TopiaException {
        List<E> result = findAllByProperty(Commande.PROPERTY_CONTRAINTE_HORAIRE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == LigneProduit.class) {
            LigneProduitDAO dao = (LigneProduitDAO)
                getContext().getDAO(LigneProduit.class);
            tmp = dao.findAllByCommande(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(LigneProduit.class, entity);
        if (!list.isEmpty()) {
            result.put(LigneProduit.class, list);
        }

        return result;
    }

} //CommandeDAOAbstract<E extends Commande>
