package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraDAOHelper.SandraEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class ChargementUsineConfigDAOAbstract<E extends ChargementUsineConfig> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)ChargementUsineConfig.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.ChargementUsineConfig;
    }

    public E findByNombreHeures(int v) throws TopiaException {
        E result = findByProperty(ChargementUsineConfig.PROPERTY_NOMBRE_HEURES, v);
        return result;
    }

    public List<E> findAllByNombreHeures(int v) throws TopiaException {
        List<E> result = findAllByProperty(ChargementUsineConfig.PROPERTY_NOMBRE_HEURES, v);
        return result;
    }

    public E findByPositionHeureActuelle(int v) throws TopiaException {
        E result = findByProperty(ChargementUsineConfig.PROPERTY_POSITION_HEURE_ACTUELLE, v);
        return result;
    }

    public List<E> findAllByPositionHeureActuelle(int v) throws TopiaException {
        List<E> result = findAllByProperty(ChargementUsineConfig.PROPERTY_POSITION_HEURE_ACTUELLE, v);
        return result;
    }

    public E findByTempFixeParTournee(int v) throws TopiaException {
        E result = findByProperty(ChargementUsineConfig.PROPERTY_TEMP_FIXE_PAR_TOURNEE, v);
        return result;
    }

    public List<E> findAllByTempFixeParTournee(int v) throws TopiaException {
        List<E> result = findAllByProperty(ChargementUsineConfig.PROPERTY_TEMP_FIXE_PAR_TOURNEE, v);
        return result;
    }

    public E findByTempFixeParLigneProduit(int v) throws TopiaException {
        E result = findByProperty(ChargementUsineConfig.PROPERTY_TEMP_FIXE_PAR_LIGNE_PRODUIT, v);
        return result;
    }

    public List<E> findAllByTempFixeParLigneProduit(int v) throws TopiaException {
        List<E> result = findAllByProperty(ChargementUsineConfig.PROPERTY_TEMP_FIXE_PAR_LIGNE_PRODUIT, v);
        return result;
    }

    public E findByTempVariableParQuantite(int v) throws TopiaException {
        E result = findByProperty(ChargementUsineConfig.PROPERTY_TEMP_VARIABLE_PAR_QUANTITE, v);
        return result;
    }

    public List<E> findAllByTempVariableParQuantite(int v) throws TopiaException {
        List<E> result = findAllByProperty(ChargementUsineConfig.PROPERTY_TEMP_VARIABLE_PAR_QUANTITE, v);
        return result;
    }

    public E findByUsine(Usine v) throws TopiaException {
        E result = findByProperty(ChargementUsineConfig.PROPERTY_USINE, v);
        return result;
    }

    public List<E> findAllByUsine(Usine v) throws TopiaException {
        List<E> result = findAllByProperty(ChargementUsineConfig.PROPERTY_USINE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //ChargementUsineConfigDAOAbstract<E extends ChargementUsineConfig>
