package com.cybelia.sandra.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class ChargementUsineConfigAbstract extends TopiaEntityAbstract implements ChargementUsineConfig {

    /**
     * Nom de l'attribut en BD : nombreHeures
     */
    protected int nombreHeures;

    /**
     * Nom de l'attribut en BD : positionHeureActuelle
     */
    protected int positionHeureActuelle;

    /**
     * Nom de l'attribut en BD : tempFixeParTournee
     */
    protected int tempFixeParTournee;

    /**
     * Nom de l'attribut en BD : tempFixeParLigneProduit
     */
    protected int tempFixeParLigneProduit;

    /**
     * Nom de l'attribut en BD : tempVariableParQuantite
     */
    protected int tempVariableParQuantite;

    /**
     * Nom de l'attribut en BD : usine
     */
    protected Usine usine;

    private static final long serialVersionUID = 3761739577935880806L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NOMBRE_HEURES, int.class, nombreHeures);
        visitor.visit(this, PROPERTY_POSITION_HEURE_ACTUELLE, int.class, positionHeureActuelle);
        visitor.visit(this, PROPERTY_TEMP_FIXE_PAR_TOURNEE, int.class, tempFixeParTournee);
        visitor.visit(this, PROPERTY_TEMP_FIXE_PAR_LIGNE_PRODUIT, int.class, tempFixeParLigneProduit);
        visitor.visit(this, PROPERTY_TEMP_VARIABLE_PAR_QUANTITE, int.class, tempVariableParQuantite);
        visitor.visit(this, PROPERTY_USINE, Usine.class, usine);
        visitor.end(this);
    }

    @Override
    public void setNombreHeures(int nombreHeures) {
        int oldValue = this.nombreHeures;
        fireOnPreWrite(PROPERTY_NOMBRE_HEURES, oldValue, nombreHeures);
        this.nombreHeures = nombreHeures;
        fireOnPostWrite(PROPERTY_NOMBRE_HEURES, oldValue, nombreHeures);
    }

    @Override
    public int getNombreHeures() {
        fireOnPreRead(PROPERTY_NOMBRE_HEURES, nombreHeures);
        int result = this.nombreHeures;
        fireOnPostRead(PROPERTY_NOMBRE_HEURES, nombreHeures);
        return result;
    }

    @Override
    public void setPositionHeureActuelle(int positionHeureActuelle) {
        int oldValue = this.positionHeureActuelle;
        fireOnPreWrite(PROPERTY_POSITION_HEURE_ACTUELLE, oldValue, positionHeureActuelle);
        this.positionHeureActuelle = positionHeureActuelle;
        fireOnPostWrite(PROPERTY_POSITION_HEURE_ACTUELLE, oldValue, positionHeureActuelle);
    }

    @Override
    public int getPositionHeureActuelle() {
        fireOnPreRead(PROPERTY_POSITION_HEURE_ACTUELLE, positionHeureActuelle);
        int result = this.positionHeureActuelle;
        fireOnPostRead(PROPERTY_POSITION_HEURE_ACTUELLE, positionHeureActuelle);
        return result;
    }

    @Override
    public void setTempFixeParTournee(int tempFixeParTournee) {
        int oldValue = this.tempFixeParTournee;
        fireOnPreWrite(PROPERTY_TEMP_FIXE_PAR_TOURNEE, oldValue, tempFixeParTournee);
        this.tempFixeParTournee = tempFixeParTournee;
        fireOnPostWrite(PROPERTY_TEMP_FIXE_PAR_TOURNEE, oldValue, tempFixeParTournee);
    }

    @Override
    public int getTempFixeParTournee() {
        fireOnPreRead(PROPERTY_TEMP_FIXE_PAR_TOURNEE, tempFixeParTournee);
        int result = this.tempFixeParTournee;
        fireOnPostRead(PROPERTY_TEMP_FIXE_PAR_TOURNEE, tempFixeParTournee);
        return result;
    }

    @Override
    public void setTempFixeParLigneProduit(int tempFixeParLigneProduit) {
        int oldValue = this.tempFixeParLigneProduit;
        fireOnPreWrite(PROPERTY_TEMP_FIXE_PAR_LIGNE_PRODUIT, oldValue, tempFixeParLigneProduit);
        this.tempFixeParLigneProduit = tempFixeParLigneProduit;
        fireOnPostWrite(PROPERTY_TEMP_FIXE_PAR_LIGNE_PRODUIT, oldValue, tempFixeParLigneProduit);
    }

    @Override
    public int getTempFixeParLigneProduit() {
        fireOnPreRead(PROPERTY_TEMP_FIXE_PAR_LIGNE_PRODUIT, tempFixeParLigneProduit);
        int result = this.tempFixeParLigneProduit;
        fireOnPostRead(PROPERTY_TEMP_FIXE_PAR_LIGNE_PRODUIT, tempFixeParLigneProduit);
        return result;
    }

    @Override
    public void setTempVariableParQuantite(int tempVariableParQuantite) {
        int oldValue = this.tempVariableParQuantite;
        fireOnPreWrite(PROPERTY_TEMP_VARIABLE_PAR_QUANTITE, oldValue, tempVariableParQuantite);
        this.tempVariableParQuantite = tempVariableParQuantite;
        fireOnPostWrite(PROPERTY_TEMP_VARIABLE_PAR_QUANTITE, oldValue, tempVariableParQuantite);
    }

    @Override
    public int getTempVariableParQuantite() {
        fireOnPreRead(PROPERTY_TEMP_VARIABLE_PAR_QUANTITE, tempVariableParQuantite);
        int result = this.tempVariableParQuantite;
        fireOnPostRead(PROPERTY_TEMP_VARIABLE_PAR_QUANTITE, tempVariableParQuantite);
        return result;
    }

    @Override
    public void setUsine(Usine usine) {
        Usine oldValue = this.usine;
        fireOnPreWrite(PROPERTY_USINE, oldValue, usine);
        this.usine = usine;
        fireOnPostWrite(PROPERTY_USINE, oldValue, usine);
    }

    @Override
    public Usine getUsine() {
        fireOnPreRead(PROPERTY_USINE, usine);
        Usine result = this.usine;
        fireOnPostRead(PROPERTY_USINE, usine);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getUsine());

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NOMBRE_HEURES, this.nombreHeures).
            append(PROPERTY_POSITION_HEURE_ACTUELLE, this.positionHeureActuelle).
            append(PROPERTY_TEMP_FIXE_PAR_TOURNEE, this.tempFixeParTournee).
            append(PROPERTY_TEMP_FIXE_PAR_LIGNE_PRODUIT, this.tempFixeParLigneProduit).
            append(PROPERTY_TEMP_VARIABLE_PAR_QUANTITE, this.tempVariableParQuantite).
            append(PROPERTY_USINE, this.usine).
         toString();
        return result;
    }

} //ChargementUsineConfigAbstract
