package com.cybelia.sandra.entities;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class ActionSecuriteAbstract extends TopiaEntityAbstract implements ActionSecurite {

    /**
     * Nom de l'attribut en BD : type
     */
    protected String type;

    /**
     * Nom de l'attribut en BD : userCreation
     */
    protected String userCreation;

    /**
     * Nom de l'attribut en BD : dateCreation
     */
    protected Date dateCreation;

    /**
     * Nom de l'attribut en BD : dateAction
     */
    protected Date dateAction;

    /**
     * Nom de l'attribut en BD : commentaire
     */
    protected String commentaire;

    /**
     * Nom de l'attribut en BD : eleveur
     */
    protected Eleveur eleveur;

    /**
     * Nom de l'attribut en BD : infoAccess
     */
    protected InfoAccess infoAccess;

    private static final long serialVersionUID = 3978984577277703477L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_TYPE, String.class, type);
        visitor.visit(this, PROPERTY_USER_CREATION, String.class, userCreation);
        visitor.visit(this, PROPERTY_DATE_CREATION, Date.class, dateCreation);
        visitor.visit(this, PROPERTY_DATE_ACTION, Date.class, dateAction);
        visitor.visit(this, PROPERTY_COMMENTAIRE, String.class, commentaire);
        visitor.visit(this, PROPERTY_ELEVEUR, Eleveur.class, eleveur);
        visitor.visit(this, PROPERTY_INFO_ACCESS, InfoAccess.class, infoAccess);
        visitor.end(this);
    }

    @Override
    public void setType(String type) {
        String oldValue = this.type;
        fireOnPreWrite(PROPERTY_TYPE, oldValue, type);
        this.type = type;
        fireOnPostWrite(PROPERTY_TYPE, oldValue, type);
    }

    @Override
    public String getType() {
        fireOnPreRead(PROPERTY_TYPE, type);
        String result = this.type;
        fireOnPostRead(PROPERTY_TYPE, type);
        return result;
    }

    @Override
    public void setUserCreation(String userCreation) {
        String oldValue = this.userCreation;
        fireOnPreWrite(PROPERTY_USER_CREATION, oldValue, userCreation);
        this.userCreation = userCreation;
        fireOnPostWrite(PROPERTY_USER_CREATION, oldValue, userCreation);
    }

    @Override
    public String getUserCreation() {
        fireOnPreRead(PROPERTY_USER_CREATION, userCreation);
        String result = this.userCreation;
        fireOnPostRead(PROPERTY_USER_CREATION, userCreation);
        return result;
    }

    @Override
    public void setDateCreation(Date dateCreation) {
        Date oldValue = this.dateCreation;
        fireOnPreWrite(PROPERTY_DATE_CREATION, oldValue, dateCreation);
        this.dateCreation = dateCreation;
        fireOnPostWrite(PROPERTY_DATE_CREATION, oldValue, dateCreation);
    }

    @Override
    public Date getDateCreation() {
        fireOnPreRead(PROPERTY_DATE_CREATION, dateCreation);
        Date result = this.dateCreation;
        fireOnPostRead(PROPERTY_DATE_CREATION, dateCreation);
        return result;
    }

    @Override
    public void setDateAction(Date dateAction) {
        Date oldValue = this.dateAction;
        fireOnPreWrite(PROPERTY_DATE_ACTION, oldValue, dateAction);
        this.dateAction = dateAction;
        fireOnPostWrite(PROPERTY_DATE_ACTION, oldValue, dateAction);
    }

    @Override
    public Date getDateAction() {
        fireOnPreRead(PROPERTY_DATE_ACTION, dateAction);
        Date result = this.dateAction;
        fireOnPostRead(PROPERTY_DATE_ACTION, dateAction);
        return result;
    }

    @Override
    public void setCommentaire(String commentaire) {
        String oldValue = this.commentaire;
        fireOnPreWrite(PROPERTY_COMMENTAIRE, oldValue, commentaire);
        this.commentaire = commentaire;
        fireOnPostWrite(PROPERTY_COMMENTAIRE, oldValue, commentaire);
    }

    @Override
    public String getCommentaire() {
        fireOnPreRead(PROPERTY_COMMENTAIRE, commentaire);
        String result = this.commentaire;
        fireOnPostRead(PROPERTY_COMMENTAIRE, commentaire);
        return result;
    }

    @Override
    public void setEleveur(Eleveur eleveur) {
        Eleveur oldValue = this.eleveur;
        fireOnPreWrite(PROPERTY_ELEVEUR, oldValue, eleveur);
        this.eleveur = eleveur;
        fireOnPostWrite(PROPERTY_ELEVEUR, oldValue, eleveur);
    }

    @Override
    public Eleveur getEleveur() {
        fireOnPreRead(PROPERTY_ELEVEUR, eleveur);
        Eleveur result = this.eleveur;
        fireOnPostRead(PROPERTY_ELEVEUR, eleveur);
        return result;
    }

    @Override
    public void setInfoAccess(InfoAccess infoAccess) {
        InfoAccess oldValue = this.infoAccess;
        fireOnPreWrite(PROPERTY_INFO_ACCESS, oldValue, infoAccess);
        this.infoAccess = infoAccess;
        fireOnPostWrite(PROPERTY_INFO_ACCESS, oldValue, infoAccess);
    }

    @Override
    public InfoAccess getInfoAccess() {
        fireOnPreRead(PROPERTY_INFO_ACCESS, infoAccess);
        InfoAccess result = this.infoAccess;
        fireOnPostRead(PROPERTY_INFO_ACCESS, infoAccess);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_TYPE, this.type).
            append(PROPERTY_USER_CREATION, this.userCreation).
            append(PROPERTY_DATE_CREATION, this.dateCreation).
            append(PROPERTY_DATE_ACTION, this.dateAction).
            append(PROPERTY_COMMENTAIRE, this.commentaire).
            append(PROPERTY_INFO_ACCESS, this.infoAccess).
         toString();
        return result;
    }

} //ActionSecuriteAbstract
