package com.cybelia.sandra;

import com.cybelia.sandra.entities.ActionSecurite;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.ChargementUsineConfig;
import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.Commande;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.EleveursDoublons;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.InfoChargement;
import com.cybelia.sandra.entities.Label;
import com.cybelia.sandra.entities.Lieu;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.Note;
import com.cybelia.sandra.entities.SecuriteGroupe;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.Transporteur;
import com.cybelia.sandra.entities.UserIndicateurs;
import com.cybelia.sandra.entities.Usine;
import com.cybelia.sandra.entities.notifier.Cron;
import com.cybelia.sandra.entities.notifier.Event;
import com.cybelia.sandra.entities.notifier.Queue;
import com.cybelia.sandra.entities.sig.PointGPS;
import com.cybelia.sandra.entities.sig.TraceGPS;
import com.cybelia.sandra.entities.synchro.Log;
import com.cybelia.sandra.entities.synchro.Synchro;
import com.cybelia.sandra.entities.trace.CREtape;
import com.cybelia.sandra.entities.trace.CRTour;
import com.cybelia.sandra.entities.trace.CRUsine;
import com.cybelia.sandra.entities.trace.SuiviEtape;
import com.cybelia.sandra.entities.trace.SuiviLigneProduit;
import com.cybelia.sandra.entities.trace.SuiviTour;
import com.cybelia.sandra.entities.trace.SuiviUsine;
import java.util.HashMap;
import java.util.Map;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.taas.entities.TaasUser;

public class SandraQueryHelper {
    public static abstract class EntityProperty<E> {

            protected String alias;

            protected Map<String, String> propertiesCache;

            public EntityProperty()         {
            propertiesCache = new HashMap<String, String>();
            }

            protected void setAlias(String alias)         {
            this.alias = alias;
            }

            public String $alias()         {
            return alias;
            }

            public String $property(String propertyName)         {
            String result = propertiesCache.get(propertyName);
            if (result == null) {
                result = TopiaQuery.getProperty(alias, propertyName);
                propertiesCache.put(propertyName, result);
            }
            return result;
            }

            public String topiaCreateDate()         {
            return $property(TopiaEntity.TOPIA_CREATE_DATE);
            }

            public String topiaId()         {
            return $property(TopiaEntity.TOPIA_ID);
            }

            public String topiaVersion()         {
            return $property(TopiaEntity.TOPIA_VERSION);
            }

            public abstract Class<E> getEntityClass();

            public abstract String defaultAlias();

        } //EntityProperty<E>
        public static class CREtapeProperty extends EntityProperty<CREtape> {

                protected CREtapeProperty()             {
                }

                @Override
                public Class<CREtape> getEntityClass()             {
            return CREtape.class;
                }

                @Override
                public String defaultAlias()             {
            return ALIAS_CRETAPE;
                }

                public String etapeHeureLivraison()             {
            return $property(CREtape.PROPERTY_ETAPE_HEURE_LIVRAISON);
                }

                public String purge()             {
            return $property(CREtape.PROPERTY_PURGE);
                }

                public String livraisonStatut()             {
            return $property(CREtape.PROPERTY_LIVRAISON_STATUT);
                }

                public String commentaireLivraison()             {
            return $property(CREtape.PROPERTY_COMMENTAIRE_LIVRAISON);
                }

            } //CREtapeProperty
            public static class TourProperty extends EntityProperty<Tour> {

                    protected TourProperty()                 {
                    }

                    @Override
                    public Class<Tour> getEntityClass()                 {
            return Tour.class;
                    }

                    @Override
                    public String defaultAlias()                 {
            return ALIAS_TOUR;
                    }

                    public String dateLivraison()                 {
            return $property(Tour.PROPERTY_DATE_LIVRAISON);
                    }

                    public String numero()                 {
            return $property(Tour.PROPERTY_NUMERO);
                    }

                    public String commentaire()                 {
            return $property(Tour.PROPERTY_COMMENTAIRE);
                    }

                    public String dateChargement()                 {
            return $property(Tour.PROPERTY_DATE_CHARGEMENT);
                    }

                    public String etapes()                 {
            return $property(Tour.PROPERTY_ETAPES);
                    }

                    public String camion()                 {
            return $property(Tour.PROPERTY_CAMION);
                    }

                    public CamionProperty camionProperty()                 {
            return newCamionProperty(camion());
                    }

                    public String defautChauffeur()                 {
            return $property(Tour.PROPERTY_DEFAUT_CHAUFFEUR);
                    }

                    public ChauffeurProperty defautChauffeurProperty()                 {
            return newChauffeurProperty(defautChauffeur());
                    }

                    public String suiviTour()                 {
            return $property(Tour.PROPERTY_SUIVI_TOUR);
                    }

                    public SuiviTourProperty suiviTourProperty()                 {
            return newSuiviTourProperty(suiviTour());
                    }

                } //TourProperty
                public static class CRUsineProperty extends EntityProperty<CRUsine> {

                        protected CRUsineProperty()                     {
                        }

                        @Override
                        public Class<CRUsine> getEntityClass()                     {
            return CRUsine.class;
                        }

                        @Override
                        public String defaultAlias()                     {
            return ALIAS_CRUSINE;
                        }

                    } //CRUsineProperty
                    public static class LigneProduitProperty extends EntityProperty<LigneProduit> {

                            protected LigneProduitProperty()                         {
                            }

                            @Override
                            public Class<LigneProduit> getEntityClass()                         {
            return LigneProduit.class;
                            }

                            @Override
                            public String defaultAlias()                         {
            return ALIAS_LIGNE_PRODUIT;
                            }

                            public String code()                         {
            return $property(LigneProduit.PROPERTY_CODE);
                            }

                            public String libelle()                         {
            return $property(LigneProduit.PROPERTY_LIBELLE);
                            }

                            public String presentation()                         {
            return $property(LigneProduit.PROPERTY_PRESENTATION);
                            }

                            public String conditionnement()                         {
            return $property(LigneProduit.PROPERTY_CONDITIONNEMENT);
                            }

                            public String capaciteUnitaire()                         {
            return $property(LigneProduit.PROPERTY_CAPACITE_UNITAIRE);
                            }

                            public String quantiteCommandee()                         {
            return $property(LigneProduit.PROPERTY_QUANTITE_COMMANDEE);
                            }

                            public String quantiteACharger()                         {
            return $property(LigneProduit.PROPERTY_QUANTITE_ACHARGER);
                            }

                            public String medicament()                         {
            return $property(LigneProduit.PROPERTY_MEDICAMENT);
                            }

                            public String ordre()                         {
            return $property(LigneProduit.PROPERTY_ORDRE);
                            }

                            public String commentaire()                         {
            return $property(LigneProduit.PROPERTY_COMMENTAIRE);
                            }

                            public String acces()                         {
            return $property(LigneProduit.PROPERTY_ACCES);
                            }

                            public String equipement()                         {
            return $property(LigneProduit.PROPERTY_EQUIPEMENT);
                            }

                            public String disponible()                         {
            return $property(LigneProduit.PROPERTY_DISPONIBLE);
                            }

                            public String etape()                         {
            return $property(LigneProduit.PROPERTY_ETAPE);
                            }

                            public EtapeProperty etapeProperty()                         {
            return newEtapeProperty(etape());
                            }

                            public String commande()                         {
            return $property(LigneProduit.PROPERTY_COMMANDE);
                            }

                            public CommandeProperty commandeProperty()                         {
            return newCommandeProperty(commande());
                            }

                            public String usine()                         {
            return $property(LigneProduit.PROPERTY_USINE);
                            }

                            public UsineProperty usineProperty()                         {
            return newUsineProperty(usine());
                            }

                            public String infoChargement()                         {
            return $property(LigneProduit.PROPERTY_INFO_CHARGEMENT);
                            }

                            public InfoChargementProperty infoChargementProperty()                         {
            return newInfoChargementProperty(infoChargement());
                            }

                            public String silo()                         {
            return $property(LigneProduit.PROPERTY_SILO);
                            }

                            public InfoAccessProperty siloProperty()                         {
            return newInfoAccessProperty(silo());
                            }

                        } //LigneProduitProperty
                        public static class EleveursDoublonsProperty extends EntityProperty<EleveursDoublons> {

                                protected EleveursDoublonsProperty()                             {
                                }

                                @Override
                                public Class<EleveursDoublons> getEntityClass()                             {
            return EleveursDoublons.class;
                                }

                                @Override
                                public String defaultAlias()                             {
            return ALIAS_ELEVEURS_DOUBLONS;
                                }

                                public String codeSocieteOld()                             {
            return $property(EleveursDoublons.PROPERTY_CODE_SOCIETE_OLD);
                                }

                                public String codeEleveurOld()                             {
            return $property(EleveursDoublons.PROPERTY_CODE_ELEVEUR_OLD);
                                }

                                public String codeSocieteNew()                             {
            return $property(EleveursDoublons.PROPERTY_CODE_SOCIETE_NEW);
                                }

                                public String codeEleveurNew()                             {
            return $property(EleveursDoublons.PROPERTY_CODE_ELEVEUR_NEW);
                                }

                            } //EleveursDoublonsProperty
                            public static class InfoAccessProperty extends EntityProperty<InfoAccess> {

                                    protected InfoAccessProperty()                                 {
                                    }

                                    @Override
                                    public Class<InfoAccess> getEntityClass()                                 {
            return InfoAccess.class;
                                    }

                                    @Override
                                    public String defaultAlias()                                 {
            return ALIAS_INFO_ACCESS;
                                    }

                                    public String accesSilo()                                 {
            return $property(InfoAccess.PROPERTY_ACCES_SILO);
                                    }

                                    public String modeChargement()                                 {
            return $property(InfoAccess.PROPERTY_MODE_CHARGEMENT);
                                    }

                                    public String nomAcces()                                 {
            return $property(InfoAccess.PROPERTY_NOM_ACCES);
                                    }

                                    public String type()                                 {
            return $property(InfoAccess.PROPERTY_TYPE);
                                    }

                                    public String niveauSecurite()                                 {
            return $property(InfoAccess.PROPERTY_NIVEAU_SECURITE);
                                    }

                                    public String commentaireSecurite()                                 {
            return $property(InfoAccess.PROPERTY_COMMENTAIRE_SECURITE);
                                    }

                                    public String risques()                                 {
            return $property(InfoAccess.PROPERTY_RISQUES);
                                    }

                                    public String etat()                                 {
            return $property(InfoAccess.PROPERTY_ETAT);
                                    }

                                    public String eleveur()                                 {
            return $property(InfoAccess.PROPERTY_ELEVEUR);
                                    }

                                    public EleveurProperty eleveurProperty()                                 {
            return newEleveurProperty(eleveur());
                                    }

                                    public String gps()                                 {
            return $property(InfoAccess.PROPERTY_GPS);
                                    }

                                    public PointGPSProperty gpsProperty()                                 {
            return newPointGPSProperty(gps());
                                    }

                                    public String trace()                                 {
            return $property(InfoAccess.PROPERTY_TRACE);
                                    }

                                    public TraceGPSProperty traceProperty()                                 {
            return newTraceGPSProperty(trace());
                                    }

                                    public String usersVerrouillage()                                 {
            return $property(InfoAccess.PROPERTY_USERS_VERROUILLAGE);
                                    }

                                } //InfoAccessProperty
                                public static class PointGPSProperty extends EntityProperty<PointGPS> {

                                        protected PointGPSProperty()                                     {
                                        }

                                        @Override
                                        public Class<PointGPS> getEntityClass()                                     {
            return PointGPS.class;
                                        }

                                        @Override
                                        public String defaultAlias()                                     {
            return ALIAS_POINT_GPS;
                                        }

                                        public String ordre()                                     {
            return $property(PointGPS.PROPERTY_ORDRE);
                                        }

                                        public String point()                                     {
            return $property(PointGPS.PROPERTY_POINT);
                                        }

                                    } //PointGPSProperty
                                    public static class TaasUserProperty extends EntityProperty<TaasUser> {

                                            protected TaasUserProperty()                                         {
                                            }

                                            @Override
                                            public Class<TaasUser> getEntityClass()                                         {
            return TaasUser.class;
                                            }

                                            @Override
                                            public String defaultAlias()                                         {
            return ALIAS_TAAS_USER;
                                            }

                                        } //TaasUserProperty
                                        public static class SynchroProperty extends EntityProperty<Synchro> {

                                                protected SynchroProperty()                                             {
                                                }

                                                @Override
                                                public Class<Synchro> getEntityClass()                                             {
            return Synchro.class;
                                                }

                                                @Override
                                                public String defaultAlias()                                             {
            return ALIAS_SYNCHRO;
                                                }

                                                public String value()                                             {
            return $property(Synchro.PROPERTY_VALUE);
                                                }

                                            } //SynchroProperty
                                            public static class InfoChargementProperty extends EntityProperty<InfoChargement> {

                                                    protected InfoChargementProperty()                                                 {
                                                    }

                                                    @Override
                                                    public Class<InfoChargement> getEntityClass()                                                 {
            return InfoChargement.class;
                                                    }

                                                    @Override
                                                    public String defaultAlias()                                                 {
            return ALIAS_INFO_CHARGEMENT;
                                                    }

                                                    public String date()                                                 {
            return $property(InfoChargement.PROPERTY_DATE);
                                                    }

                                                    public String quantite()                                                 {
            return $property(InfoChargement.PROPERTY_QUANTITE);
                                                    }

                                                    public String compartiments()                                                 {
            return $property(InfoChargement.PROPERTY_COMPARTIMENTS);
                                                    }

                                                    public String notifier()                                                 {
            return $property(InfoChargement.PROPERTY_NOTIFIER);
                                                    }

                                                    public String ligneProduit()                                                 {
            return $property(InfoChargement.PROPERTY_LIGNE_PRODUIT);
                                                    }

                                                    public LigneProduitProperty ligneProduitProperty()                                                 {
            return newLigneProduitProperty(ligneProduit());
                                                    }

                                                } //InfoChargementProperty
                                                public static class QueueProperty extends EntityProperty<Queue> {

                                                        protected QueueProperty()                                                     {
                                                        }

                                                        @Override
                                                        public Class<Queue> getEntityClass()                                                     {
            return Queue.class;
                                                        }

                                                        @Override
                                                        public String defaultAlias()                                                     {
            return ALIAS_QUEUE;
                                                        }

                                                        public String date()                                                     {
            return $property(Queue.PROPERTY_DATE);
                                                        }

                                                        public String values()                                                     {
            return $property(Queue.PROPERTY_VALUES);
                                                        }

                                                        public String event()                                                     {
            return $property(Queue.PROPERTY_EVENT);
                                                        }

                                                        public EventProperty eventProperty()                                                     {
            return newEventProperty(event());
                                                        }

                                                        public String cron()                                                     {
            return $property(Queue.PROPERTY_CRON);
                                                        }

                                                    } //QueueProperty
                                                    public static class EventProperty extends EntityProperty<Event> {

                                                            protected EventProperty()                                                         {
                                                            }

                                                            @Override
                                                            public Class<Event> getEntityClass()                                                         {
            return Event.class;
                                                            }

                                                            @Override
                                                            public String defaultAlias()                                                         {
            return ALIAS_EVENT;
                                                            }

                                                            public String type()                                                         {
            return $property(Event.PROPERTY_TYPE);
                                                            }

                                                            public String variables()                                                         {
            return $property(Event.PROPERTY_VARIABLES);
                                                            }

                                                        } //EventProperty
                                                        public static class LabelProperty extends EntityProperty<Label> {

                                                                protected LabelProperty()                                                             {
                                                                }

                                                                @Override
                                                                public Class<Label> getEntityClass()                                                             {
            return Label.class;
                                                                }

                                                                @Override
                                                                public String defaultAlias()                                                             {
            return ALIAS_LABEL;
                                                                }

                                                                public String id()                                                             {
            return $property(Label.PROPERTY_ID);
                                                                }

                                                                public String valeur()                                                             {
            return $property(Label.PROPERTY_VALEUR);
                                                                }

                                                                public String categorie()                                                             {
            return $property(Label.PROPERTY_CATEGORIE);
                                                                }

                                                            } //LabelProperty
                                                            public static class UserIndicateursProperty extends EntityProperty<UserIndicateurs> {

                                                                    protected UserIndicateursProperty()                                                                 {
                                                                    }

                                                                    @Override
                                                                    public Class<UserIndicateurs> getEntityClass()                                                                 {
            return UserIndicateurs.class;
                                                                    }

                                                                    @Override
                                                                    public String defaultAlias()                                                                 {
            return ALIAS_USER_INDICATEURS;
                                                                    }

                                                                    public String nbGpsMaj()                                                                 {
            return $property(UserIndicateurs.PROPERTY_NB_GPS_MAJ);
                                                                    }

                                                                    public String nbSecuMaj()                                                                 {
            return $property(UserIndicateurs.PROPERTY_NB_SECU_MAJ);
                                                                    }

                                                                    public String nbMaj()                                                                 {
            return $property(UserIndicateurs.PROPERTY_NB_MAJ);
                                                                    }

                                                                    public String nbSynchWifi()                                                                 {
            return $property(UserIndicateurs.PROPERTY_NB_SYNCH_WIFI);
                                                                    }

                                                                    public String nbSynchAuto()                                                                 {
            return $property(UserIndicateurs.PROPERTY_NB_SYNCH_AUTO);
                                                                    }

                                                                    public String nbSynchGPRS()                                                                 {
            return $property(UserIndicateurs.PROPERTY_NB_SYNCH_GPRS);
                                                                    }

                                                                    public String nbSynchKo()                                                                 {
            return $property(UserIndicateurs.PROPERTY_NB_SYNCH_KO);
                                                                    }

                                                                    public String nbOctetsReceivedGPRS()                                                                 {
            return $property(UserIndicateurs.PROPERTY_NB_OCTETS_RECEIVED_GPRS);
                                                                    }

                                                                    public String nbOctetsSendGPRS()                                                                 {
            return $property(UserIndicateurs.PROPERTY_NB_OCTETS_SEND_GPRS);
                                                                    }

                                                                    public String nbOctetsReceivedWifi()                                                                 {
            return $property(UserIndicateurs.PROPERTY_NB_OCTETS_RECEIVED_WIFI);
                                                                    }

                                                                    public String nbOctetsSendWifi()                                                                 {
            return $property(UserIndicateurs.PROPERTY_NB_OCTETS_SEND_WIFI);
                                                                    }

                                                                    public String nbNotifs()                                                                 {
            return $property(UserIndicateurs.PROPERTY_NB_NOTIFS);
                                                                    }

                                                                    public String lastSynch()                                                                 {
            return $property(UserIndicateurs.PROPERTY_LAST_SYNCH);
                                                                    }

                                                                    public String lastModif()                                                                 {
            return $property(UserIndicateurs.PROPERTY_LAST_MODIF);
                                                                    }

                                                                    public String taasUser()                                                                 {
            return $property(UserIndicateurs.PROPERTY_TAAS_USER);
                                                                    }

                                                                    public TaasUserProperty taasUserProperty()                                                                 {
            return newTaasUserProperty(taasUser());
                                                                    }

                                                                } //UserIndicateursProperty
                                                                public static class TraceGPSProperty extends EntityProperty<TraceGPS> {

                                                                        protected TraceGPSProperty()                                                                     {
                                                                        }

                                                                        @Override
                                                                        public Class<TraceGPS> getEntityClass()                                                                     {
            return TraceGPS.class;
                                                                        }

                                                                        @Override
                                                                        public String defaultAlias()                                                                     {
            return ALIAS_TRACE_GPS;
                                                                        }

                                                                        public String lastPointOrder()                                                                     {
            return $property(TraceGPS.PROPERTY_LAST_POINT_ORDER);
                                                                        }

                                                                        public String listePoints()                                                                     {
            return $property(TraceGPS.PROPERTY_LISTE_POINTS);
                                                                        }

                                                                    } //TraceGPSProperty
                                                                    public static class SecuriteGroupeProperty extends EntityProperty<SecuriteGroupe> {

                                                                            protected SecuriteGroupeProperty()                                                                         {
                                                                            }

                                                                            @Override
                                                                            public Class<SecuriteGroupe> getEntityClass()                                                                         {
            return SecuriteGroupe.class;
                                                                            }

                                                                            @Override
                                                                            public String defaultAlias()                                                                         {
            return ALIAS_SECURITE_GROUPE;
                                                                            }

                                                                            public String nom()                                                                         {
            return $property(SecuriteGroupe.PROPERTY_NOM);
                                                                            }

                                                                        } //SecuriteGroupeProperty
                                                                        public static class SuiviEtapeProperty extends EntityProperty<SuiviEtape> {

                                                                                protected SuiviEtapeProperty()                                                                             {
                                                                                }

                                                                                @Override
                                                                                public Class<SuiviEtape> getEntityClass()                                                                             {
            return SuiviEtape.class;
                                                                                }

                                                                                @Override
                                                                                public String defaultAlias()                                                                             {
            return ALIAS_SUIVI_ETAPE;
                                                                                }

                                                                                public String nouvelleOrdre()                                                                             {
            return $property(SuiviEtape.PROPERTY_NOUVELLE_ORDRE);
                                                                                }

                                                                                public String status()                                                                             {
            return $property(SuiviEtape.PROPERTY_STATUS);
                                                                                }

                                                                                public String dateEntree()                                                                             {
            return $property(SuiviEtape.PROPERTY_DATE_ENTREE);
                                                                                }

                                                                                public String dateSortie()                                                                             {
            return $property(SuiviEtape.PROPERTY_DATE_SORTIE);
                                                                                }

                                                                                public String cREtape()                                                                             {
            return $property(SuiviEtape.PROPERTY_C_RETAPE);
                                                                                }

                                                                                public CREtapeProperty cREtapeProperty()                                                                             {
            return newCREtapeProperty(cREtape());
                                                                                }

                                                                                public String etape()                                                                             {
            return $property(SuiviEtape.PROPERTY_ETAPE);
                                                                                }

                                                                                public EtapeProperty etapeProperty()                                                                             {
            return newEtapeProperty(etape());
                                                                                }

                                                                            } //SuiviEtapeProperty
                                                                            public static class EleveurProperty extends EntityProperty<Eleveur> {

                                                                                    protected EleveurProperty()                                                                                 {
                                                                                    }

                                                                                    @Override
                                                                                    public Class<Eleveur> getEntityClass()                                                                                 {
            return Eleveur.class;
                                                                                    }

                                                                                    @Override
                                                                                    public String defaultAlias()                                                                                 {
            return ALIAS_ELEVEUR;
                                                                                    }

                                                                                    public String raisonSociale()                                                                                 {
            return $property(Eleveur.PROPERTY_RAISON_SOCIALE);
                                                                                    }

                                                                                    public String telephone()                                                                                 {
            return $property(Eleveur.PROPERTY_TELEPHONE);
                                                                                    }

                                                                                    public String mobile()                                                                                 {
            return $property(Eleveur.PROPERTY_MOBILE);
                                                                                    }

                                                                                    public String adresse()                                                                                 {
            return $property(Eleveur.PROPERTY_ADRESSE);
                                                                                    }

                                                                                    public String ville()                                                                                 {
            return $property(Eleveur.PROPERTY_VILLE);
                                                                                    }

                                                                                    public String codePostal()                                                                                 {
            return $property(Eleveur.PROPERTY_CODE_POSTAL);
                                                                                    }

                                                                                    public String niveauSecurite()                                                                                 {
            return $property(Eleveur.PROPERTY_NIVEAU_SECURITE);
                                                                                    }

                                                                                    public String email()                                                                                 {
            return $property(Eleveur.PROPERTY_EMAIL);
                                                                                    }

                                                                                    public String codeINSEE()                                                                                 {
            return $property(Eleveur.PROPERTY_CODE_INSEE);
                                                                                    }

                                                                                    public String commentaire()                                                                                 {
            return $property(Eleveur.PROPERTY_COMMENTAIRE);
                                                                                    }

                                                                                    public String contrainteHoraire()                                                                                 {
            return $property(Eleveur.PROPERTY_CONTRAINTE_HORAIRE);
                                                                                    }

                                                                                    public String nbTomTomGPSModif()                                                                                 {
            return $property(Eleveur.PROPERTY_NB_TOM_TOM_GPSMODIF);
                                                                                    }

                                                                                    public String accesEleveur()                                                                                 {
            return $property(Eleveur.PROPERTY_ACCES_ELEVEUR);
                                                                                    }

                                                                                    public InfoAccessProperty accesEleveurProperty()                                                                                 {
            return newInfoAccessProperty(accesEleveur());
                                                                                    }

                                                                                    public String accesSilos()                                                                                 {
            return $property(Eleveur.PROPERTY_ACCES_SILOS);
                                                                                    }

                                                                                    public String societe()                                                                                 {
            return $property(Eleveur.PROPERTY_SOCIETE);
                                                                                    }

                                                                                    public SocieteProperty societeProperty()                                                                                 {
            return newSocieteProperty(societe());
                                                                                    }

                                                                                    public String notes()                                                                                 {
            return $property(Eleveur.PROPERTY_NOTES);
                                                                                    }

                                                                                    public String actionSecurite()                                                                                 {
            return $property(Eleveur.PROPERTY_ACTION_SECURITE);
                                                                                    }

                                                                                } //EleveurProperty
                                                                                public static class ChargementUsineConfigProperty extends EntityProperty<ChargementUsineConfig> {

                                                                                        protected ChargementUsineConfigProperty()                                                                                     {
                                                                                        }

                                                                                        @Override
                                                                                        public Class<ChargementUsineConfig> getEntityClass()                                                                                     {
            return ChargementUsineConfig.class;
                                                                                        }

                                                                                        @Override
                                                                                        public String defaultAlias()                                                                                     {
            return ALIAS_CHARGEMENT_USINE_CONFIG;
                                                                                        }

                                                                                        public String nombreHeures()                                                                                     {
            return $property(ChargementUsineConfig.PROPERTY_NOMBRE_HEURES);
                                                                                        }

                                                                                        public String positionHeureActuelle()                                                                                     {
            return $property(ChargementUsineConfig.PROPERTY_POSITION_HEURE_ACTUELLE);
                                                                                        }

                                                                                        public String tempFixeParTournee()                                                                                     {
            return $property(ChargementUsineConfig.PROPERTY_TEMP_FIXE_PAR_TOURNEE);
                                                                                        }

                                                                                        public String tempFixeParLigneProduit()                                                                                     {
            return $property(ChargementUsineConfig.PROPERTY_TEMP_FIXE_PAR_LIGNE_PRODUIT);
                                                                                        }

                                                                                        public String tempVariableParQuantite()                                                                                     {
            return $property(ChargementUsineConfig.PROPERTY_TEMP_VARIABLE_PAR_QUANTITE);
                                                                                        }

                                                                                        public String usine()                                                                                     {
            return $property(ChargementUsineConfig.PROPERTY_USINE);
                                                                                        }

                                                                                        public UsineProperty usineProperty()                                                                                     {
            return newUsineProperty(usine());
                                                                                        }

                                                                                    } //ChargementUsineConfigProperty
                                                                                    public static class UsineProperty extends EntityProperty<Usine> {

                                                                                            protected UsineProperty()                                                                                         {
                                                                                            }

                                                                                            @Override
                                                                                            public Class<Usine> getEntityClass()                                                                                         {
            return Usine.class;
                                                                                            }

                                                                                            @Override
                                                                                            public String defaultAlias()                                                                                         {
            return ALIAS_USINE;
                                                                                            }

                                                                                            public String adresse()                                                                                         {
            return $property(Usine.PROPERTY_ADRESSE);
                                                                                            }

                                                                                            public String codePostal()                                                                                         {
            return $property(Usine.PROPERTY_CODE_POSTAL);
                                                                                            }

                                                                                            public String ville()                                                                                         {
            return $property(Usine.PROPERTY_VILLE);
                                                                                            }

                                                                                            public String codeINSEE()                                                                                         {
            return $property(Usine.PROPERTY_CODE_INSEE);
                                                                                            }

                                                                                            public String blockGPSModif()                                                                                         {
            return $property(Usine.PROPERTY_BLOCK_GPSMODIF);
                                                                                            }

                                                                                        } //UsineProperty
                                                                                        public static class LogProperty extends EntityProperty<Log> {

                                                                                                protected LogProperty()                                                                                             {
                                                                                                }

                                                                                                @Override
                                                                                                public Class<Log> getEntityClass()                                                                                             {
            return Log.class;
                                                                                                }

                                                                                                @Override
                                                                                                public String defaultAlias()                                                                                             {
            return ALIAS_LOG;
                                                                                                }

                                                                                                public String synchroNumber()                                                                                             {
            return $property(Log.PROPERTY_SYNCHRO_NUMBER);
                                                                                                }

                                                                                                public String timeStamp()                                                                                             {
            return $property(Log.PROPERTY_TIME_STAMP);
                                                                                                }

                                                                                                public String tourTopiaID()                                                                                             {
            return $property(Log.PROPERTY_TOUR_TOPIA_ID);
                                                                                                }

                                                                                                public String typeModif()                                                                                             {
            return $property(Log.PROPERTY_TYPE_MODIF);
                                                                                                }

                                                                                                public String fichierSynchro()                                                                                             {
            return $property(Log.PROPERTY_FICHIER_SYNCHRO);
                                                                                                }

                                                                                                public String camionTopiaID()                                                                                             {
            return $property(Log.PROPERTY_CAMION_TOPIA_ID);
                                                                                                }

                                                                                            } //LogProperty
                                                                                            public static class CommandeProperty extends EntityProperty<Commande> {

                                                                                                    protected CommandeProperty()                                                                                                 {
                                                                                                    }

                                                                                                    @Override
                                                                                                    public Class<Commande> getEntityClass()                                                                                                 {
            return Commande.class;
                                                                                                    }

                                                                                                    @Override
                                                                                                    public String defaultAlias()                                                                                                 {
            return ALIAS_COMMANDE;
                                                                                                    }

                                                                                                    public String numero()                                                                                                 {
            return $property(Commande.PROPERTY_NUMERO);
                                                                                                    }

                                                                                                    public String commentaire()                                                                                                 {
            return $property(Commande.PROPERTY_COMMENTAIRE);
                                                                                                    }

                                                                                                    public String contrainteHoraire()                                                                                                 {
            return $property(Commande.PROPERTY_CONTRAINTE_HORAIRE);
                                                                                                    }

                                                                                                } //CommandeProperty
                                                                                                public static class NoteProperty extends EntityProperty<Note> {

                                                                                                        protected NoteProperty()                                                                                                     {
                                                                                                        }

                                                                                                        @Override
                                                                                                        public Class<Note> getEntityClass()                                                                                                     {
            return Note.class;
                                                                                                        }

                                                                                                        @Override
                                                                                                        public String defaultAlias()                                                                                                     {
            return ALIAS_NOTE;
                                                                                                        }

                                                                                                        public String nom()                                                                                                     {
            return $property(Note.PROPERTY_NOM);
                                                                                                        }

                                                                                                        public String description()                                                                                                     {
            return $property(Note.PROPERTY_DESCRIPTION);
                                                                                                        }

                                                                                                        public String contentType()                                                                                                     {
            return $property(Note.PROPERTY_CONTENT_TYPE);
                                                                                                        }

                                                                                                        public String eleveur()                                                                                                     {
            return $property(Note.PROPERTY_ELEVEUR);
                                                                                                        }

                                                                                                        public EleveurProperty eleveurProperty()                                                                                                     {
            return newEleveurProperty(eleveur());
                                                                                                        }

                                                                                                    } //NoteProperty
                                                                                                    public static class SuiviTourProperty extends EntityProperty<SuiviTour> {

                                                                                                            protected SuiviTourProperty()                                                                                                         {
                                                                                                            }

                                                                                                            @Override
                                                                                                            public Class<SuiviTour> getEntityClass()                                                                                                         {
            return SuiviTour.class;
                                                                                                            }

                                                                                                            @Override
                                                                                                            public String defaultAlias()                                                                                                         {
            return ALIAS_SUIVI_TOUR;
                                                                                                            }

                                                                                                            public String status()                                                                                                         {
            return $property(SuiviTour.PROPERTY_STATUS);
                                                                                                            }

                                                                                                            public String chauffeurNomPrenom()                                                                                                         {
            return $property(SuiviTour.PROPERTY_CHAUFFEUR_NOM_PRENOM);
                                                                                                            }

                                                                                                            public String duree()                                                                                                         {
            return $property(SuiviTour.PROPERTY_DUREE);
                                                                                                            }

                                                                                                            public String litresGasoil()                                                                                                         {
            return $property(SuiviTour.PROPERTY_LITRES_GASOIL);
                                                                                                            }

                                                                                                            public String kmDepart()                                                                                                         {
            return $property(SuiviTour.PROPERTY_KM_DEPART);
                                                                                                            }

                                                                                                            public String kmArrivee()                                                                                                         {
            return $property(SuiviTour.PROPERTY_KM_ARRIVEE);
                                                                                                            }

                                                                                                            public String suiviEtapes()                                                                                                         {
            return $property(SuiviTour.PROPERTY_SUIVI_ETAPES);
                                                                                                            }

                                                                                                            public String reel()                                                                                                         {
            return $property(SuiviTour.PROPERTY_REEL);
                                                                                                            }

                                                                                                            public ChauffeurProperty reelProperty()                                                                                                         {
            return newChauffeurProperty(reel());
                                                                                                            }

                                                                                                            public String suiviUsines()                                                                                                         {
            return $property(SuiviTour.PROPERTY_SUIVI_USINES);
                                                                                                            }

                                                                                                            public String cRTour()                                                                                                         {
            return $property(SuiviTour.PROPERTY_C_RTOUR);
                                                                                                            }

                                                                                                            public CRTourProperty cRTourProperty()                                                                                                         {
            return newCRTourProperty(cRTour());
                                                                                                            }

                                                                                                        } //SuiviTourProperty
                                                                                                        public static class CronProperty extends EntityProperty<Cron> {

                                                                                                                protected CronProperty()                                                                                                             {
                                                                                                                }

                                                                                                                @Override
                                                                                                                public Class<Cron> getEntityClass()                                                                                                             {
            return Cron.class;
                                                                                                                }

                                                                                                                @Override
                                                                                                                public String defaultAlias()                                                                                                             {
            return ALIAS_CRON;
                                                                                                                }

                                                                                                                public String label()                                                                                                             {
            return $property(Cron.PROPERTY_LABEL);
                                                                                                                }

                                                                                                                public String dateStart()                                                                                                             {
            return $property(Cron.PROPERTY_DATE_START);
                                                                                                                }

                                                                                                                public String dateEnd()                                                                                                             {
            return $property(Cron.PROPERTY_DATE_END);
                                                                                                                }

                                                                                                                public String template()                                                                                                             {
            return $property(Cron.PROPERTY_TEMPLATE);
                                                                                                                }

                                                                                                                public String expression()                                                                                                             {
            return $property(Cron.PROPERTY_EXPRESSION);
                                                                                                                }

                                                                                                                public String recipients()                                                                                                             {
            return $property(Cron.PROPERTY_RECIPIENTS);
                                                                                                                }

                                                                                                                public String enable()                                                                                                             {
            return $property(Cron.PROPERTY_ENABLE);
                                                                                                                }

                                                                                                                public String author()                                                                                                             {
            return $property(Cron.PROPERTY_AUTHOR);
                                                                                                                }

                                                                                                                public String event()                                                                                                             {
            return $property(Cron.PROPERTY_EVENT);
                                                                                                                }

                                                                                                                public EventProperty eventProperty()                                                                                                             {
            return newEventProperty(event());
                                                                                                                }

                                                                                                            } //CronProperty
                                                                                                            public static class CRTourProperty extends EntityProperty<CRTour> {

                                                                                                                    protected CRTourProperty()                                                                                                                 {
                                                                                                                    }

                                                                                                                    @Override
                                                                                                                    public Class<CRTour> getEntityClass()                                                                                                                 {
            return CRTour.class;
                                                                                                                    }

                                                                                                                    @Override
                                                                                                                    public String defaultAlias()                                                                                                                 {
            return ALIAS_CRTOUR;
                                                                                                                    }

                                                                                                                    public String remarques()                                                                                                                 {
            return $property(CRTour.PROPERTY_REMARQUES);
                                                                                                                    }

                                                                                                                    public String retourMP()                                                                                                                 {
            return $property(CRTour.PROPERTY_RETOUR_MP);
                                                                                                                    }

                                                                                                                    public String reprise()                                                                                                                 {
            return $property(CRTour.PROPERTY_REPRISE);
                                                                                                                    }

                                                                                                                    public String transfert()                                                                                                                 {
            return $property(CRTour.PROPERTY_TRANSFERT);
                                                                                                                    }

                                                                                                                    public String purgeUsine()                                                                                                                 {
            return $property(CRTour.PROPERTY_PURGE_USINE);
                                                                                                                    }

                                                                                                                    public String rincageUsine()                                                                                                                 {
            return $property(CRTour.PROPERTY_RINCAGE_USINE);
                                                                                                                    }

                                                                                                                } //CRTourProperty
                                                                                                                public static class TransporteurProperty extends EntityProperty<Transporteur> {

                                                                                                                        protected TransporteurProperty()                                                                                                                     {
                                                                                                                        }

                                                                                                                        @Override
                                                                                                                        public Class<Transporteur> getEntityClass()                                                                                                                     {
            return Transporteur.class;
                                                                                                                        }

                                                                                                                        @Override
                                                                                                                        public String defaultAlias()                                                                                                                     {
            return ALIAS_TRANSPORTEUR;
                                                                                                                        }

                                                                                                                        public String code()                                                                                                                     {
            return $property(Transporteur.PROPERTY_CODE);
                                                                                                                        }

                                                                                                                        public String name()                                                                                                                     {
            return $property(Transporteur.PROPERTY_NAME);
                                                                                                                        }

                                                                                                                        public String societe()                                                                                                                     {
            return $property(Transporteur.PROPERTY_SOCIETE);
                                                                                                                        }

                                                                                                                        public SocieteProperty societeProperty()                                                                                                                     {
            return newSocieteProperty(societe());
                                                                                                                        }

                                                                                                                    } //TransporteurProperty
                                                                                                                    public static class EtapeProperty extends EntityProperty<Etape> {

                                                                                                                            protected EtapeProperty()                                                                                                                         {
                                                                                                                            }

                                                                                                                            @Override
                                                                                                                            public Class<Etape> getEntityClass()                                                                                                                         {
            return Etape.class;
                                                                                                                            }

                                                                                                                            @Override
                                                                                                                            public String defaultAlias()                                                                                                                         {
            return ALIAS_ETAPE;
                                                                                                                            }

                                                                                                                            public String ordre()                                                                                                                         {
            return $property(Etape.PROPERTY_ORDRE);
                                                                                                                            }

                                                                                                                            public String commentaire()                                                                                                                         {
            return $property(Etape.PROPERTY_COMMENTAIRE);
                                                                                                                            }

                                                                                                                            public String etat()                                                                                                                         {
            return $property(Etape.PROPERTY_ETAT);
                                                                                                                            }

                                                                                                                            public String tour()                                                                                                                         {
            return $property(Etape.PROPERTY_TOUR);
                                                                                                                            }

                                                                                                                            public TourProperty tourProperty()                                                                                                                         {
            return newTourProperty(tour());
                                                                                                                            }

                                                                                                                            public String eleveur()                                                                                                                         {
            return $property(Etape.PROPERTY_ELEVEUR);
                                                                                                                            }

                                                                                                                            public EleveurProperty eleveurProperty()                                                                                                                         {
            return newEleveurProperty(eleveur());
                                                                                                                            }

                                                                                                                            public String produits()                                                                                                                         {
            return $property(Etape.PROPERTY_PRODUITS);
                                                                                                                            }

                                                                                                                        } //EtapeProperty
                                                                                                                        public static class LieuProperty extends EntityProperty<Lieu> {

                                                                                                                                protected LieuProperty()                                                                                                                             {
                                                                                                                                }

                                                                                                                                @Override
                                                                                                                                public Class<Lieu> getEntityClass()                                                                                                                             {
            return Lieu.class;
                                                                                                                                }

                                                                                                                                @Override
                                                                                                                                public String defaultAlias()                                                                                                                             {
            return ALIAS_LIEU;
                                                                                                                                }

                                                                                                                                public String code()                                                                                                                             {
            return $property(Lieu.PROPERTY_CODE);
                                                                                                                                }

                                                                                                                                public String tomtomGPS()                                                                                                                             {
            return $property(Lieu.PROPERTY_TOMTOM_GPS);
                                                                                                                                }

                                                                                                                                public PointGPSProperty tomtomGPSProperty()                                                                                                                             {
            return newPointGPSProperty(tomtomGPS());
                                                                                                                                }

                                                                                                                            } //LieuProperty
                                                                                                                            public static class SuiviLigneProduitProperty extends EntityProperty<SuiviLigneProduit> {

                                                                                                                                    protected SuiviLigneProduitProperty()                                                                                                                                 {
                                                                                                                                    }

                                                                                                                                    @Override
                                                                                                                                    public Class<SuiviLigneProduit> getEntityClass()                                                                                                                                 {
            return SuiviLigneProduit.class;
                                                                                                                                    }

                                                                                                                                    @Override
                                                                                                                                    public String defaultAlias()                                                                                                                                 {
            return ALIAS_SUIVI_LIGNE_PRODUIT;
                                                                                                                                    }

                                                                                                                                    public String quantite()                                                                                                                                 {
            return $property(SuiviLigneProduit.PROPERTY_QUANTITE);
                                                                                                                                    }

                                                                                                                                    public String compartiments()                                                                                                                                 {
            return $property(SuiviLigneProduit.PROPERTY_COMPARTIMENTS);
                                                                                                                                    }

                                                                                                                                    public String ligneProduit()                                                                                                                                 {
            return $property(SuiviLigneProduit.PROPERTY_LIGNE_PRODUIT);
                                                                                                                                    }

                                                                                                                                    public LigneProduitProperty ligneProduitProperty()                                                                                                                                 {
            return newLigneProduitProperty(ligneProduit());
                                                                                                                                    }

                                                                                                                                } //SuiviLigneProduitProperty
                                                                                                                                public static class SocieteProperty extends EntityProperty<Societe> {

                                                                                                                                        protected SocieteProperty()                                                                                                                                     {
                                                                                                                                        }

                                                                                                                                        @Override
                                                                                                                                        public Class<Societe> getEntityClass()                                                                                                                                     {
            return Societe.class;
                                                                                                                                        }

                                                                                                                                        @Override
                                                                                                                                        public String defaultAlias()                                                                                                                                     {
            return ALIAS_SOCIETE;
                                                                                                                                        }

                                                                                                                                        public String code()                                                                                                                                     {
            return $property(Societe.PROPERTY_CODE);
                                                                                                                                        }

                                                                                                                                    } //SocieteProperty
                                                                                                                                    public static class CamionProperty extends EntityProperty<Camion> {

                                                                                                                                            protected CamionProperty()                                                                                                                                         {
                                                                                                                                            }

                                                                                                                                            @Override
                                                                                                                                            public Class<Camion> getEntityClass()                                                                                                                                         {
            return Camion.class;
                                                                                                                                            }

                                                                                                                                            @Override
                                                                                                                                            public String defaultAlias()                                                                                                                                         {
            return ALIAS_CAMION;
                                                                                                                                            }

                                                                                                                                            public String code()                                                                                                                                         {
            return $property(Camion.PROPERTY_CODE);
                                                                                                                                            }

                                                                                                                                            public String nombreCompartiments()                                                                                                                                         {
            return $property(Camion.PROPERTY_NOMBRE_COMPARTIMENTS);
                                                                                                                                            }

                                                                                                                                            public String actif()                                                                                                                                         {
            return $property(Camion.PROPERTY_ACTIF);
                                                                                                                                            }

                                                                                                                                            public String camionsAssocies()                                                                                                                                         {
            return $property(Camion.PROPERTY_CAMIONS_ASSOCIES);
                                                                                                                                            }

                                                                                                                                            public String defautChauffeurs()                                                                                                                                         {
            return $property(Camion.PROPERTY_DEFAUT_CHAUFFEURS);
                                                                                                                                            }

                                                                                                                                            public String transporteur()                                                                                                                                         {
            return $property(Camion.PROPERTY_TRANSPORTEUR);
                                                                                                                                            }

                                                                                                                                            public TransporteurProperty transporteurProperty()                                                                                                                                         {
            return newTransporteurProperty(transporteur());
                                                                                                                                            }

                                                                                                                                            public String societe()                                                                                                                                         {
            return $property(Camion.PROPERTY_SOCIETE);
                                                                                                                                            }

                                                                                                                                            public SocieteProperty societeProperty()                                                                                                                                         {
            return newSocieteProperty(societe());
                                                                                                                                            }

                                                                                                                                            public String userIndicateurs()                                                                                                                                         {
            return $property(Camion.PROPERTY_USER_INDICATEURS);
                                                                                                                                            }

                                                                                                                                            public UserIndicateursProperty userIndicateursProperty()                                                                                                                                         {
            return newUserIndicateursProperty(userIndicateurs());
                                                                                                                                            }

                                                                                                                                        } //CamionProperty
                                                                                                                                        public static class SuiviUsineProperty extends EntityProperty<SuiviUsine> {

                                                                                                                                                protected SuiviUsineProperty()                                                                                                                                             {
                                                                                                                                                }

                                                                                                                                                @Override
                                                                                                                                                public Class<SuiviUsine> getEntityClass()                                                                                                                                             {
            return SuiviUsine.class;
                                                                                                                                                }

                                                                                                                                                @Override
                                                                                                                                                public String defaultAlias()                                                                                                                                             {
            return ALIAS_SUIVI_USINE;
                                                                                                                                                }

                                                                                                                                                public String creationOrdre()                                                                                                                                             {
            return $property(SuiviUsine.PROPERTY_CREATION_ORDRE);
                                                                                                                                                }

                                                                                                                                                public String nouvelleOrdre()                                                                                                                                             {
            return $property(SuiviUsine.PROPERTY_NOUVELLE_ORDRE);
                                                                                                                                                }

                                                                                                                                                public String dateEntree()                                                                                                                                             {
            return $property(SuiviUsine.PROPERTY_DATE_ENTREE);
                                                                                                                                                }

                                                                                                                                                public String dateSortie()                                                                                                                                             {
            return $property(SuiviUsine.PROPERTY_DATE_SORTIE);
                                                                                                                                                }

                                                                                                                                                public String tempsChargement()                                                                                                                                             {
            return $property(SuiviUsine.PROPERTY_TEMPS_CHARGEMENT);
                                                                                                                                                }

                                                                                                                                                public String heureChargement()                                                                                                                                             {
            return $property(SuiviUsine.PROPERTY_HEURE_CHARGEMENT);
                                                                                                                                                }

                                                                                                                                                public String chargePar()                                                                                                                                             {
            return $property(SuiviUsine.PROPERTY_CHARGE_PAR);
                                                                                                                                                }

                                                                                                                                                public String dateChargementPrevue()                                                                                                                                             {
            return $property(SuiviUsine.PROPERTY_DATE_CHARGEMENT_PREVUE);
                                                                                                                                                }

                                                                                                                                                public String suiviLigneProduit()                                                                                                                                             {
            return $property(SuiviUsine.PROPERTY_SUIVI_LIGNE_PRODUIT);
                                                                                                                                                }

                                                                                                                                                public String cRUsine()                                                                                                                                             {
            return $property(SuiviUsine.PROPERTY_C_RUSINE);
                                                                                                                                                }

                                                                                                                                                public CRUsineProperty cRUsineProperty()                                                                                                                                             {
            return newCRUsineProperty(cRUsine());
                                                                                                                                                }

                                                                                                                                                public String usine()                                                                                                                                             {
            return $property(SuiviUsine.PROPERTY_USINE);
                                                                                                                                                }

                                                                                                                                                public UsineProperty usineProperty()                                                                                                                                             {
            return newUsineProperty(usine());
                                                                                                                                                }

                                                                                                                                            } //SuiviUsineProperty
                                                                                                                                            public static class ChauffeurProperty extends EntityProperty<Chauffeur> {

                                                                                                                                                    protected ChauffeurProperty()                                                                                                                                                 {
                                                                                                                                                    }

                                                                                                                                                    @Override
                                                                                                                                                    public Class<Chauffeur> getEntityClass()                                                                                                                                                 {
            return Chauffeur.class;
                                                                                                                                                    }

                                                                                                                                                    @Override
                                                                                                                                                    public String defaultAlias()                                                                                                                                                 {
            return ALIAS_CHAUFFEUR;
                                                                                                                                                    }

                                                                                                                                                    public String code()                                                                                                                                                 {
            return $property(Chauffeur.PROPERTY_CODE);
                                                                                                                                                    }

                                                                                                                                                    public String trigramme()                                                                                                                                                 {
            return $property(Chauffeur.PROPERTY_TRIGRAMME);
                                                                                                                                                    }

                                                                                                                                                    public String nom()                                                                                                                                                 {
            return $property(Chauffeur.PROPERTY_NOM);
                                                                                                                                                    }

                                                                                                                                                    public String prenom()                                                                                                                                                 {
            return $property(Chauffeur.PROPERTY_PRENOM);
                                                                                                                                                    }

                                                                                                                                                    public String camions()                                                                                                                                                 {
            return $property(Chauffeur.PROPERTY_CAMIONS);
                                                                                                                                                    }

                                                                                                                                                    public String societe()                                                                                                                                                 {
            return $property(Chauffeur.PROPERTY_SOCIETE);
                                                                                                                                                    }

                                                                                                                                                    public SocieteProperty societeProperty()                                                                                                                                                 {
            return newSocieteProperty(societe());
                                                                                                                                                    }

                                                                                                                                                } //ChauffeurProperty
                                                                                                                                                public static class ActionSecuriteProperty extends EntityProperty<ActionSecurite> {

                                                                                                                                                        protected ActionSecuriteProperty()                                                                                                                                                     {
                                                                                                                                                        }

                                                                                                                                                        @Override
                                                                                                                                                        public Class<ActionSecurite> getEntityClass()                                                                                                                                                     {
            return ActionSecurite.class;
                                                                                                                                                        }

                                                                                                                                                        @Override
                                                                                                                                                        public String defaultAlias()                                                                                                                                                     {
            return ALIAS_ACTION_SECURITE;
                                                                                                                                                        }

                                                                                                                                                        public String type()                                                                                                                                                     {
            return $property(ActionSecurite.PROPERTY_TYPE);
                                                                                                                                                        }

                                                                                                                                                        public String userCreation()                                                                                                                                                     {
            return $property(ActionSecurite.PROPERTY_USER_CREATION);
                                                                                                                                                        }

                                                                                                                                                        public String dateCreation()                                                                                                                                                     {
            return $property(ActionSecurite.PROPERTY_DATE_CREATION);
                                                                                                                                                        }

                                                                                                                                                        public String dateAction()                                                                                                                                                     {
            return $property(ActionSecurite.PROPERTY_DATE_ACTION);
                                                                                                                                                        }

                                                                                                                                                        public String commentaire()                                                                                                                                                     {
            return $property(ActionSecurite.PROPERTY_COMMENTAIRE);
                                                                                                                                                        }

                                                                                                                                                        public String eleveur()                                                                                                                                                     {
            return $property(ActionSecurite.PROPERTY_ELEVEUR);
                                                                                                                                                        }

                                                                                                                                                        public EleveurProperty eleveurProperty()                                                                                                                                                     {
            return newEleveurProperty(eleveur());
                                                                                                                                                        }

                                                                                                                                                        public String infoAccess()                                                                                                                                                     {
            return $property(ActionSecurite.PROPERTY_INFO_ACCESS);
                                                                                                                                                        }

                                                                                                                                                        public InfoAccessProperty infoAccessProperty()                                                                                                                                                     {
            return newInfoAccessProperty(infoAccess());
                                                                                                                                                        }

                                                                                                                                                    } //ActionSecuriteProperty

    public static final String ALIAS_CRETAPE = "C";

    public static final String ALIAS_TOUR = "T";

    public static final String ALIAS_CRUSINE = "CR";

    public static final String ALIAS_LIGNE_PRODUIT = "LP";

    public static final String ALIAS_ELEVEURS_DOUBLONS = "ED";

    public static final String ALIAS_INFO_ACCESS = "IA";

    public static final String ALIAS_POINT_GPS = "PG";

    public static final String ALIAS_TAAS_USER = "TU";

    public static final String ALIAS_SYNCHRO = "S";

    public static final String ALIAS_INFO_CHARGEMENT = "IC";

    public static final String ALIAS_QUEUE = "Q";

    public static final String ALIAS_EVENT = "E";

    public static final String ALIAS_LABEL = "L";

    public static final String ALIAS_USER_INDICATEURS = "UI";

    public static final String ALIAS_TRACE_GPS = "TG";

    public static final String ALIAS_SECURITE_GROUPE = "SG";

    public static final String ALIAS_SUIVI_ETAPE = "SE";

    public static final String ALIAS_ELEVEUR = "EL";

    public static final String ALIAS_CHARGEMENT_USINE_CONFIG = "CUC";

    public static final String ALIAS_USINE = "U";

    public static final String ALIAS_LOG = "LO";

    public static final String ALIAS_COMMANDE = "CO";

    public static final String ALIAS_NOTE = "N";

    public static final String ALIAS_SUIVI_TOUR = "ST";

    public static final String ALIAS_CRON = "CRO";

    public static final String ALIAS_CRTOUR = "CRT";

    public static final String ALIAS_TRANSPORTEUR = "TR";

    public static final String ALIAS_ETAPE = "ET";

    public static final String ALIAS_LIEU = "LI";

    public static final String ALIAS_SUIVI_LIGNE_PRODUIT = "SLP";

    public static final String ALIAS_SOCIETE = "SO";

    public static final String ALIAS_CAMION = "CA";

    public static final String ALIAS_CAMION_CAMIONS_ASSOCIES = "CCA";

    public static final String ALIAS_SUIVI_USINE = "SU";

    public static final String ALIAS_CHAUFFEUR = "CH";

    public static final String ALIAS_ACTION_SECURITE = "AS";

    public static TopiaQuery createQuery(EntityProperty property) {
        return new TopiaQuery((Class<? extends TopiaEntity>)property.getEntityClass(), property.$alias());
    }

    public static String format(String statement, String... propertyNames) {
        for (int i = 1; i <= propertyNames.length; i++) {
           statement = statement.replace("$" + i, propertyNames[i-1]);
        }
        return statement;
    }

    private static <P extends EntityProperty> P newEntityProperty(Class<P> propertyClass) {
        return newEntityProperty(propertyClass, null);
    }

    private static <P extends EntityProperty> P newEntityProperty(Class<P> propertyClass, String alias) {
        try {
            P property = propertyClass.newInstance();
            if (alias == null) {
                alias = property.defaultAlias();
            }
            property.setAlias(alias);
            return property;
        } catch (Exception eee) {
    
            throw new Error("Error instantiate " + propertyClass.getName(), eee);
    
        }
    }

    public static CREtapeProperty newCREtapeProperty() {
        return newCREtapeProperty(null);
    }

    public static CREtapeProperty newCREtapeProperty(String alias) {
        return newEntityProperty(CREtapeProperty.class, alias);
    }

    public static TourProperty newTourProperty() {
        return newTourProperty(null);
    }

    public static TourProperty newTourProperty(String alias) {
        return newEntityProperty(TourProperty.class, alias);
    }

    public static CRUsineProperty newCRUsineProperty() {
        return newCRUsineProperty(null);
    }

    public static CRUsineProperty newCRUsineProperty(String alias) {
        return newEntityProperty(CRUsineProperty.class, alias);
    }

    public static LigneProduitProperty newLigneProduitProperty() {
        return newLigneProduitProperty(null);
    }

    public static LigneProduitProperty newLigneProduitProperty(String alias) {
        return newEntityProperty(LigneProduitProperty.class, alias);
    }

    public static EleveursDoublonsProperty newEleveursDoublonsProperty() {
        return newEleveursDoublonsProperty(null);
    }

    public static EleveursDoublonsProperty newEleveursDoublonsProperty(String alias) {
        return newEntityProperty(EleveursDoublonsProperty.class, alias);
    }

    public static InfoAccessProperty newInfoAccessProperty() {
        return newInfoAccessProperty(null);
    }

    public static InfoAccessProperty newInfoAccessProperty(String alias) {
        return newEntityProperty(InfoAccessProperty.class, alias);
    }

    public static PointGPSProperty newPointGPSProperty() {
        return newPointGPSProperty(null);
    }

    public static PointGPSProperty newPointGPSProperty(String alias) {
        return newEntityProperty(PointGPSProperty.class, alias);
    }

    public static TaasUserProperty newTaasUserProperty() {
        return newTaasUserProperty(null);
    }

    public static TaasUserProperty newTaasUserProperty(String alias) {
        return newEntityProperty(TaasUserProperty.class, alias);
    }

    public static SynchroProperty newSynchroProperty() {
        return newSynchroProperty(null);
    }

    public static SynchroProperty newSynchroProperty(String alias) {
        return newEntityProperty(SynchroProperty.class, alias);
    }

    public static InfoChargementProperty newInfoChargementProperty() {
        return newInfoChargementProperty(null);
    }

    public static InfoChargementProperty newInfoChargementProperty(String alias) {
        return newEntityProperty(InfoChargementProperty.class, alias);
    }

    public static QueueProperty newQueueProperty() {
        return newQueueProperty(null);
    }

    public static QueueProperty newQueueProperty(String alias) {
        return newEntityProperty(QueueProperty.class, alias);
    }

    public static EventProperty newEventProperty() {
        return newEventProperty(null);
    }

    public static EventProperty newEventProperty(String alias) {
        return newEntityProperty(EventProperty.class, alias);
    }

    public static LabelProperty newLabelProperty() {
        return newLabelProperty(null);
    }

    public static LabelProperty newLabelProperty(String alias) {
        return newEntityProperty(LabelProperty.class, alias);
    }

    public static UserIndicateursProperty newUserIndicateursProperty() {
        return newUserIndicateursProperty(null);
    }

    public static UserIndicateursProperty newUserIndicateursProperty(String alias) {
        return newEntityProperty(UserIndicateursProperty.class, alias);
    }

    public static TraceGPSProperty newTraceGPSProperty() {
        return newTraceGPSProperty(null);
    }

    public static TraceGPSProperty newTraceGPSProperty(String alias) {
        return newEntityProperty(TraceGPSProperty.class, alias);
    }

    public static SecuriteGroupeProperty newSecuriteGroupeProperty() {
        return newSecuriteGroupeProperty(null);
    }

    public static SecuriteGroupeProperty newSecuriteGroupeProperty(String alias) {
        return newEntityProperty(SecuriteGroupeProperty.class, alias);
    }

    public static SuiviEtapeProperty newSuiviEtapeProperty() {
        return newSuiviEtapeProperty(null);
    }

    public static SuiviEtapeProperty newSuiviEtapeProperty(String alias) {
        return newEntityProperty(SuiviEtapeProperty.class, alias);
    }

    public static EleveurProperty newEleveurProperty() {
        return newEleveurProperty(null);
    }

    public static EleveurProperty newEleveurProperty(String alias) {
        return newEntityProperty(EleveurProperty.class, alias);
    }

    public static ChargementUsineConfigProperty newChargementUsineConfigProperty() {
        return newChargementUsineConfigProperty(null);
    }

    public static ChargementUsineConfigProperty newChargementUsineConfigProperty(String alias) {
        return newEntityProperty(ChargementUsineConfigProperty.class, alias);
    }

    public static UsineProperty newUsineProperty() {
        return newUsineProperty(null);
    }

    public static UsineProperty newUsineProperty(String alias) {
        return newEntityProperty(UsineProperty.class, alias);
    }

    public static LogProperty newLogProperty() {
        return newLogProperty(null);
    }

    public static LogProperty newLogProperty(String alias) {
        return newEntityProperty(LogProperty.class, alias);
    }

    public static CommandeProperty newCommandeProperty() {
        return newCommandeProperty(null);
    }

    public static CommandeProperty newCommandeProperty(String alias) {
        return newEntityProperty(CommandeProperty.class, alias);
    }

    public static NoteProperty newNoteProperty() {
        return newNoteProperty(null);
    }

    public static NoteProperty newNoteProperty(String alias) {
        return newEntityProperty(NoteProperty.class, alias);
    }

    public static SuiviTourProperty newSuiviTourProperty() {
        return newSuiviTourProperty(null);
    }

    public static SuiviTourProperty newSuiviTourProperty(String alias) {
        return newEntityProperty(SuiviTourProperty.class, alias);
    }

    public static CronProperty newCronProperty() {
        return newCronProperty(null);
    }

    public static CronProperty newCronProperty(String alias) {
        return newEntityProperty(CronProperty.class, alias);
    }

    public static CRTourProperty newCRTourProperty() {
        return newCRTourProperty(null);
    }

    public static CRTourProperty newCRTourProperty(String alias) {
        return newEntityProperty(CRTourProperty.class, alias);
    }

    public static TransporteurProperty newTransporteurProperty() {
        return newTransporteurProperty(null);
    }

    public static TransporteurProperty newTransporteurProperty(String alias) {
        return newEntityProperty(TransporteurProperty.class, alias);
    }

    public static EtapeProperty newEtapeProperty() {
        return newEtapeProperty(null);
    }

    public static EtapeProperty newEtapeProperty(String alias) {
        return newEntityProperty(EtapeProperty.class, alias);
    }

    public static LieuProperty newLieuProperty() {
        return newLieuProperty(null);
    }

    public static LieuProperty newLieuProperty(String alias) {
        return newEntityProperty(LieuProperty.class, alias);
    }

    public static SuiviLigneProduitProperty newSuiviLigneProduitProperty() {
        return newSuiviLigneProduitProperty(null);
    }

    public static SuiviLigneProduitProperty newSuiviLigneProduitProperty(String alias) {
        return newEntityProperty(SuiviLigneProduitProperty.class, alias);
    }

    public static SocieteProperty newSocieteProperty() {
        return newSocieteProperty(null);
    }

    public static SocieteProperty newSocieteProperty(String alias) {
        return newEntityProperty(SocieteProperty.class, alias);
    }

    public static CamionProperty newCamionProperty() {
        return newCamionProperty(null);
    }

    public static CamionProperty newCamionProperty(String alias) {
        return newEntityProperty(CamionProperty.class, alias);
    }

    public static CamionProperty newCamionCamionsAssociesProperty() {
        return newCamionProperty(ALIAS_CAMION_CAMIONS_ASSOCIES);
    }

    public static SuiviUsineProperty newSuiviUsineProperty() {
        return newSuiviUsineProperty(null);
    }

    public static SuiviUsineProperty newSuiviUsineProperty(String alias) {
        return newEntityProperty(SuiviUsineProperty.class, alias);
    }

    public static ChauffeurProperty newChauffeurProperty() {
        return newChauffeurProperty(null);
    }

    public static ChauffeurProperty newChauffeurProperty(String alias) {
        return newEntityProperty(ChauffeurProperty.class, alias);
    }

    public static ActionSecuriteProperty newActionSecuriteProperty() {
        return newActionSecuriteProperty(null);
    }

    public static ActionSecuriteProperty newActionSecuriteProperty(String alias) {
        return newEntityProperty(ActionSecuriteProperty.class, alias);
    }

} //SandraQueryHelper
